/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.backStageManagement.mapper.CrawlerOperationMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.CrawlerOperation;
import com.chinamcloud.haihe.backStageManagement.pojo.CrawlerOperationInc;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.utils.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CrawlerOperationService {
    private static final Logger log = LogManager.getLogger(CrawlerOperationService.class);
    @Autowired
    private CrawlerOperationMapper crawlerOperationMapper;

    public Object addOperation(CrawlerOperation crawlerOperation) {
        try {
            this.crawlerOperationMapper.insertSelective(crawlerOperation);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u64cd\u4f5c\u4fe1\u606f\u5f02\u5e38\uff1a{}" + e.getMessage());
            return new CodeResult(CodeResult.Code.Failed);
        }
        return new CodeResult(CodeResult.Code.SUCCESS);
    }

    public Object updateOperation(CrawlerOperation crawlerOperation) {
        try {
            this.crawlerOperationMapper.updateByPrimaryKeySelective(crawlerOperation);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u64cd\u4f5c\u4fe1\u606f\u5f02\u5e38\uff1a{}" + e.getMessage());
            return new CodeResult(CodeResult.Code.Failed);
        }
        return new CodeResult(CodeResult.Code.SUCCESS);
    }

    public Object deleteOperation(List<Integer> ids) {
        try {
            if (ids != null && !ids.isEmpty()) {
                this.crawlerOperationMapper.deleteByPrimaryKey(ids);
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u64cd\u4f5c\u4fe1\u606f\u5f02\u5e38\uff1a{}" + e.getMessage());
            return new CodeResult(CodeResult.Code.Failed);
        }
        return new CodeResult(CodeResult.Code.SUCCESS);
    }

    public Object selectOperation(CrawlerOperationInc crawlerOperationInc) {
        Long fromDt = crawlerOperationInc.getFromDt();
        Long fromExitTime = NumberUtils.exitDigit(fromDt, 10);
        if (fromExitTime == -1L) {
            crawlerOperationInc.setFromDt(null);
        } else {
            crawlerOperationInc.setFromDt(fromExitTime);
        }
        Long toDt = crawlerOperationInc.getToDt();
        Long toExitTime = NumberUtils.exitDigit(toDt, 10);
        if (toExitTime == -1L) {
            crawlerOperationInc.setToDt(null);
        } else {
            crawlerOperationInc.setToDt(toExitTime);
        }
        Integer siteId = crawlerOperationInc.getSiteId();
        if (siteId == null) {
            return new CodeResult<1>(CodeResult.Code.SUCCESS, new ArrayList<CrawlerOperation>(){
                private static final long serialVersionUID = -5965826077217968757L;
                {
                    this.add(new CrawlerOperation());
                }
            });
        }
        List<CrawlerOperation> crawlerOperations = this.crawlerOperationMapper.selectByPrimaryKey(crawlerOperationInc);
        this.exitDetails(crawlerOperations);
        return new CodeResult<List<CrawlerOperation>>(CodeResult.Code.SUCCESS, crawlerOperations);
    }

    private void exitDetails(List<CrawlerOperation> crawlerOperations) {
        for (CrawlerOperation crawlerOperation : crawlerOperations) {
            String operationDetailsStr = crawlerOperation.getOperationDetailsStr();
            crawlerOperation.setOperationDetails(JSON.parse((String)operationDetailsStr));
        }
    }

    @Scheduled(cron="0 0 0 */7 * ?")
    public void deleteOperation() {
        CrawlerOperationInc crawlerOperationInc = new CrawlerOperationInc();
        long begin = NumberUtils.exitDigit(System.currentTimeMillis() - 604800000L, 10);
        crawlerOperationInc.setFromDt(0L);
        crawlerOperationInc.setToDt(begin);
        log.info("\u5220\u6389\uff1a" + begin + " \u65f6\u95f4\u524d\u7684\u6570\u636e");
        List<CrawlerOperation> crawlerOperations = this.crawlerOperationMapper.selectByPrimaryKey(crawlerOperationInc);
        List<Integer> collect = crawlerOperations.stream().map(CrawlerOperation::getId).collect(Collectors.toList());
        this.deleteOperation(collect);
    }
}

