/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.chinamcloud.haihe.backStageManagement.mapper.HaiheAreaMapper;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class RegionService {
    private static final Logger log = LogManager.getLogger(RegionService.class);
    @Autowired
    private HaiheAreaMapper haiheAreaMapper;

    @Cacheable(value={"redis#3600"}, key="#root.methodName+#code", unless="#result == null")
    public CodeResult<List<Map<String, Object>>> getAddrTree(String code, Boolean ... aBoolean) {
        if (StringUtils.isBlank((CharSequence)code)) {
            log.error(MessageSource.getMsg("params_error"));
            return CodeResult.SUCCESSRESULT("params_error", new ArrayList(1));
        }
        Integer provinceCode = null;
        try {
            provinceCode = Integer.valueOf(code);
        }
        catch (Exception e) {
            log.error(MessageSource.getMsg("params_error"));
            e.printStackTrace();
            return CodeResult.SUCCESSRESULT("params_error", new ArrayList(1));
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
        List<Map<String, Object>> city = this.haiheAreaMapper.getCity(provinceCode);
        if (city != null && !city.isEmpty()) {
            for (Map<String, Object> objectMap : city) {
                Integer cityCode = Integer.valueOf((String)objectMap.get("code"));
                List<Map<String, Object>> district = this.haiheAreaMapper.getDistrict(cityCode);
                objectMap.put("childList", district);
            }
            mapList.addAll(city);
        } else {
            List<Map<String, Object>> district = this.haiheAreaMapper.getDistrict(provinceCode);
            mapList.addAll(district);
        }
        if (mapList.isEmpty()) {
            log.error(MessageSource.getMsg("data_empty"));
            return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, new ArrayList(1));
        }
        if (aBoolean != null && aBoolean.length > 0 && aBoolean[0].booleanValue()) {
            RegionService.setRegionName(mapList);
        }
        return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, mapList);
    }

    @Cacheable(value={"redis#604800"}, key="#root.methodName+#root.targetClass", unless="#result == null")
    public CodeResult<List<Map<String, Object>>> getProvinces(Boolean ... aBoolean) {
        List<Map<String, Object>> city = this.haiheAreaMapper.getProvinces();
        if (city == null || city.isEmpty()) {
            log.error(MessageSource.getMsg("data_empty"));
            return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, new ArrayList());
        }
        if (aBoolean != null && aBoolean.length > 0 && aBoolean[0].booleanValue()) {
            RegionService.setRegionName(city);
        }
        return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, city);
    }

    public CodeResult<List<Map<String, Object>>> getAddr(Map<String, String> map, Boolean ... aBoolean) {
        String name = map.get("name");
        String code = map.get("code");
        List<Map<String, Object>> addr = this.haiheAreaMapper.getAddr(code, name);
        if (aBoolean != null && aBoolean.length > 0 && aBoolean[0].booleanValue()) {
            RegionService.setRegionName(addr);
        }
        return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, addr);
    }

    @Cacheable(value={"redis#604800"}, unless="#result == null")
    public Map<String, Set<String>> getAllAddr(List<String> regionNames, final String regionCode, String regionType) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Set<String>> mapList = new HashMap<String, Set<String>>();
        if (regionNames.isEmpty() && StringUtils.isBlank((CharSequence)regionCode)) {
            result.addAll((Collection)this.getProvinces(true).getResult());
            result.forEach(x -> {
                List<Map<String, Object>> code = this.getAddrTree(x.get("code").toString(), true).getResult();
                code.add((Map<String, Object>)x);
                mapList.put((String)x.get("name"), code.stream().map(y -> y.get("name").toString()).collect(Collectors.toSet()));
            });
        } else if (!regionNames.isEmpty()) {
            for (final String regionName : regionNames) {
                result.addAll((Collection)this.getAddr((Map<String, String>)new HashMap<String, String>(){
                    private static final long serialVersionUID = -4114582448443599672L;
                    {
                        this.put("name", regionName);
                    }
                }, true).getResult());
            }
            result.forEach(x -> {
                List<Map<String, Object>> code = this.getAddrTree(x.get("code").toString(), true).getResult();
                code.add((Map<String, Object>)x);
                mapList.put((String)x.get("name"), code.stream().map(y -> y.get("name").toString()).collect(Collectors.toSet()));
            });
        } else {
            result.addAll((Collection)this.getAddrTree(regionCode, true).getResult());
            if (StringUtils.isBlank((CharSequence)regionType)) {
                List<Map<String, Object>> code = this.getAddr((Map<String, String>)new HashMap<String, String>(){
                    private static final long serialVersionUID = -4114582448443599672L;
                    {
                        this.put("code", regionCode);
                    }
                }, true).getResult();
                result.addAll(code);
                mapList.put(code.get(0).get("name").toString(), result.stream().map(x -> x.get("name").toString()).collect(Collectors.toSet()));
            } else {
                result.forEach(x -> mapList.put((String)x.get("name"), new HashSet<String>(){
                    private static final long serialVersionUID = 4366603200725713615L;
                    {
                        this.add(x.get("name").toString());
                    }
                }));
            }
        }
        return mapList;
    }

    public static void setRegionName(List<Map<String, Object>> list) {
        if (list != null) {
            for (Map<String, Object> map : list) {
                String name = map.get("name").toString();
                if (name.endsWith("\u7701")) {
                    name = name.substring(0, name.lastIndexOf("\u7701"));
                } else if (name.endsWith("\u5e02")) {
                    name = name.substring(0, name.lastIndexOf("\u5e02"));
                } else if (name.endsWith("\u81ea\u6cbb\u533a")) {
                    name = name.substring(0, name.lastIndexOf("\u81ea\u6cbb\u533a"));
                } else if (name.endsWith("\u81ea\u6cbb\u5dde")) {
                    name = name.substring(0, name.lastIndexOf("\u81ea\u6cbb\u5dde"));
                } else if (name.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                    name = name.substring(0, name.lastIndexOf("\u7279\u522b\u884c\u653f\u533a"));
                } else if (name.endsWith("\u533a")) {
                    name = name.substring(0, name.lastIndexOf("\u533a"));
                }
                map.put("name", name);
            }
        }
    }
}

