/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.backStageManagement.config.CimConfig;
import com.chinamcloud.haihe.backStageManagement.mapper.HaiheAreaMapper;
import com.chinamcloud.haihe.backStageManagement.mapper.SiteManageMapper;
import com.chinamcloud.haihe.backStageManagement.mapper.SiteQueryMapper;
import com.chinamcloud.haihe.backStageManagement.mapper.UserMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.AppSpiderTemplate;
import com.chinamcloud.haihe.backStageManagement.pojo.CrawlerOperation;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteInc;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteRequirements;
import com.chinamcloud.haihe.backStageManagement.pojo.SpiderTemplate;
import com.chinamcloud.haihe.backStageManagement.pojo.User;
import com.chinamcloud.haihe.backStageManagement.service.CrawlerOperationService;
import com.chinamcloud.haihe.backStageManagement.service.SiteRequirementsService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.cache.RedisUtil;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.spider.processor.AppProcessor;
import com.chinamcloud.haihe.common.spider.processor.WebProcessor;
import com.chinamcloud.haihe.common.spider.processor.WeiXinProcessor;
import com.chinamcloud.haihe.common.spider.processor.WeiboProcessor;
import com.chinamcloud.haihe.common.utils.HttpClientDownloaderTLS;
import com.chinamcloud.haihe.common.utils.HttpUtils;
import com.chinamcloud.haihe.common.utils.NumberUtils;
import com.chinamcloud.haihe.common.utils.RegionUtils;
import com.chinamcloud.haihe.common.utils.ToolUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.selector.Html;

@Service
public class SiteManageService {
    private static final Logger log = LogManager.getLogger(SiteManageService.class);
    @Autowired
    private SiteManageMapper siteManageMapper;
    @Autowired
    private SiteQueryMapper siteQueryMapper;
    @Autowired
    private CrawlerOperationService crawlerOperationService;
    @Autowired
    private HaiheAreaMapper haiheAreaMapper;
    @Autowired
    private AppProcessor appProcessor;
    @Autowired
    private WebProcessor webProcessor;
    @Autowired
    private WeiboProcessor weiboProcessor;
    @Autowired
    private WeiXinProcessor weiXinProcessor;
    @Autowired
    private SiteRequirementsService siteRequirementsService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final List<String> templates = new ArrayList<String>(2){
        private static final long serialVersionUID = 7085897830926659331L;
        {
            this.add("{}");
            this.add("{\"listUrls\":{},\"pics\":{},\"pubTime\":{},\"reprint\":{},\"subject\":{}}");
        }
    };
    private static final Map<String, Object> cimParam;
    private static final Map<String, String> cimTemplate;

    public Object add(com.chinamcloud.haihe.backStageManagement.pojo.Site site) {
        Integer active;
        long beginTime = System.currentTimeMillis();
        String userChatId = "";
        Integer type = site.getType();
        if (type == null) {
            log.error(MessageSource.getMsg("site_type_empty"));
            return CodeResult.failedResultByMsgSource("site_type_empty");
        }
        String siteName = site.getSiteName();
        if (StringUtils.isBlank((CharSequence)siteName)) {
            log.error(MessageSource.getMsg("site_name_empty"));
            return CodeResult.failedResultByMsgSource("site_name_empty");
        }
        siteName = siteName.trim();
        site.setSiteName(siteName);
        Integer siteId = site.getSiteId();
        if (siteId == null || siteId == 0) {
            siteId = Math.abs((type + siteName).hashCode());
            site.setSiteId(siteId);
        } else {
            User user;
            CodeResult<SiteRequirements> siteRequirementsBySiteId = this.siteRequirementsService.getSiteRequirementsBySiteId(siteId);
            SiteRequirements result = siteRequirementsBySiteId.getResult();
            String userToken = "";
            if (result != null) {
                userToken = result.getUserToken();
            }
            if ((user = this.userMapper.selectByUserToken(userToken)) != null) {
                userChatId = user.getUserChatId();
            }
        }
        com.chinamcloud.haihe.backStageManagement.pojo.Site dbSite = this.siteQueryMapper.getSiteById(siteId);
        if (dbSite != null) {
            log.error(MessageSource.getMsg("site_repeat"));
            return CodeResult.failedResultByMsgSource("site_repeat");
        }
        Integer pid = site.getPid();
        if (pid == null) {
            log.error(MessageSource.getMsg("site_pid_empty"));
            return CodeResult.failedResultByMsgSource("site_pid_empty");
        }
        this.siteSetPids(site);
        Integer level = site.getLevel();
        if (level == null) {
            log.error(MessageSource.getMsg("site_level_empty"));
            return CodeResult.failedResultByMsgSource("site_level_empty");
        }
        Date now = new Date(System.currentTimeMillis());
        site.setCreateTime(now);
        site.setUpdateTime(now);
        String province = site.getProvince();
        String municipality = site.getMunicipality();
        String prefecture = site.getPrefecture();
        String location = new RegionUtils().getLocation(province, municipality, prefecture);
        if (StringUtils.isNotBlank((CharSequence)location)) {
            site.setLocation(location);
        }
        Integer pagetype = site.getPagetype();
        if ((type == 1 || type == 5) && pagetype == null) {
            log.error(MessageSource.getMsg("site_pagetype_empty"));
            return CodeResult.failedResultByMsgSource("site_pagetype_empty");
        }
        if (type == 2 || type == 3 || type == 4) {
            site.setPagetype(1);
        }
        if ((active = site.getActive()) == null) {
            site.setActive(0);
            active = 0;
        }
        if (type == 2 || type == 3 || type == 4 || pagetype == 1 && (type == 1 || type == 5)) {
            String classify;
            String bizid;
            String url = site.getUrl();
            if (StringUtils.isBlank((CharSequence)url)) {
                return CodeResult.failedResultByMsgSource("site_weixihao_empty");
            }
            if (type == 2 && StringUtils.isBlank((CharSequence)(bizid = site.getBizid()))) {
                return CodeResult.failedResultByMsgSource("site_bizid_empty");
            }
            if (pagetype == 1 && (type == 1 || type == 5) || type == 4) {
                String template;
                AppSpiderTemplate appSpiderTemplate;
                SpiderTemplate webSpiderTemplate = site.getSpiderTemplate();
                if (webSpiderTemplate != null) {
                    String templateJson = JSON.toJSONString((Object)webSpiderTemplate);
                    site.setTemplate(templateJson);
                }
                if ((appSpiderTemplate = site.getAppSpiderTemplate()) != null) {
                    String templateJson = JSON.toJSONString((Object)appSpiderTemplate);
                    site.setTemplate(templateJson);
                }
                if (StringUtils.isBlank((CharSequence)(template = site.getTemplate())) && active == 1) {
                    return CodeResult.failedResultByMsgSource("site_can_not_active");
                }
            }
            if (StringUtils.isBlank((CharSequence)(classify = site.getClassify()))) {
                return CodeResult.failedResultByMsgSource("site_classify_empty");
            }
            site.setStatus(1);
            site.setCrawlTime(null);
            site.setRepetition(0);
            site.setCrawlNum(0);
            Integer frequency = site.getFrequency();
            if (frequency == null) {
                site.setFrequency(86400);
            } else if (frequency < 21600) {
                site.setFrequency(21600);
            }
        }
        Set<String> SiteQueryServicegetDetailsPageSite = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetDetailsPageSite*");
        this.redisUtil.del(SiteQueryServicegetDetailsPageSite);
        Set<String> getDetailsPageSite = this.redisUtil.scan("redis#60::getDetailsPageSite*");
        this.redisUtil.del(getDetailsPageSite);
        if (pagetype != 1) {
            Set<String> SiteQueryServicegetSiteHead = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetSiteHead*");
            this.redisUtil.del(SiteQueryServicegetSiteHead);
            Set<String> selectByPrimaryKey = this.redisUtil.scan("redis#600::selectByPrimaryKey*");
            this.redisUtil.del(selectByPrimaryKey);
            Set<String> SiteQueryServicegetTree = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetTree*");
            this.redisUtil.del(SiteQueryServicegetTree);
        }
        this.siteManageMapper.insertSelective(site);
        log.info("\u6dfb\u52a0\u7684\u7ad9\u70b9\uff1a" + JSON.toJSONString((Object)site));
        CrawlerOperation crawlerOperation = new CrawlerOperation(site.getSiteId(), new Date(beginTime), System.currentTimeMillis() - beginTime, 1, 0, site, JSON.toJSONString((Object)site), 1);
        this.crawlerOperationService.addOperation(crawlerOperation);
        this.sendMessage(userChatId, site, 1);
        return CodeResult.SUCCESSRESULT("success");
    }

    public Object sendAddFailMsg(com.chinamcloud.haihe.backStageManagement.pojo.Site site) {
        User user;
        String userChatId = "";
        Integer siteId = site.getSiteId();
        if (siteId == null) {
            log.error(MessageSource.getMsg("site_id_empty"));
            throw new CustomException("site_id_empty");
        }
        CodeResult<SiteRequirements> siteRequirementsBySiteId = this.siteRequirementsService.getSiteRequirementsBySiteId(siteId);
        SiteRequirements result = siteRequirementsBySiteId.getResult();
        String userToken = "";
        if (result != null) {
            userToken = result.getUserToken();
        }
        if ((user = this.userMapper.selectByUserToken(userToken)) != null) {
            userChatId = user.getUserChatId();
        }
        this.sendMessage(userChatId, site, -1);
        return CodeResult.SUCCESSRESULT("success");
    }

    @Transactional
    public Object delete(List<com.chinamcloud.haihe.backStageManagement.pojo.Site> sites) {
        long beginTime = System.currentTimeMillis();
        if (sites.isEmpty()) {
            return null;
        }
        for (com.chinamcloud.haihe.backStageManagement.pojo.Site site : sites) {
            if (site.getSiteId() == null) {
                log.error(MessageSource.getMsg("site_id_empty"));
                throw new CustomException("site_id_empty");
            }
            com.chinamcloud.haihe.backStageManagement.pojo.Site siteById = this.siteQueryMapper.getSiteById(site.getSiteId());
            if (siteById == null) {
                log.error(MessageSource.getMsg("site_not_exist"));
                throw new CustomException("site_not_exist");
            }
            Integer active = siteById.getActive();
            if (active == 1) {
                log.error(MessageSource.getMsg("site_run_cannot_be_deleted"));
                throw new CustomException("site_run_cannot_be_deleted");
            }
            SiteInc siteInc = new SiteInc();
            siteInc.setPids("[" + site.getSiteId() + "]");
            List<com.chinamcloud.haihe.backStageManagement.pojo.Site> activityCollectBeans = this.siteQueryMapper.getDetailsPageSite(siteInc);
            if (activityCollectBeans != null && !activityCollectBeans.isEmpty()) {
                log.error(MessageSource.getMsg("site_contains_subset"));
                throw new CustomException("site_contains_subset");
            }
            this.siteManageMapper.deleteByPrimaryKey(site.getSiteId());
            Integer pagetype = siteById.getPagetype();
            this.redisUtil.del("redis#600::" + site.getSiteId());
            Set<String> SiteQueryServicegetDetailsPageSite = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetDetailsPageSite*");
            this.redisUtil.del(SiteQueryServicegetDetailsPageSite);
            Set<String> getDetailsPageSite = this.redisUtil.scan("redis#60::getDetailsPageSite*");
            this.redisUtil.del(getDetailsPageSite);
            if (pagetype == 1) continue;
            Set<String> SiteQueryServicegetSiteHead = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetSiteHead*");
            this.redisUtil.del(SiteQueryServicegetSiteHead);
            Set<String> selectByPrimaryKey = this.redisUtil.scan("redis#600::selectByPrimaryKey*");
            this.redisUtil.del(selectByPrimaryKey);
            Set<String> SiteQueryServicegetTree = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetTree*");
            this.redisUtil.del(SiteQueryServicegetTree);
        }
        long endTime = System.currentTimeMillis();
        for (com.chinamcloud.haihe.backStageManagement.pojo.Site site : sites) {
            this.crawlerOperationService.addOperation(new CrawlerOperation(site.getSiteId(), new Date(beginTime), endTime - beginTime, sites.size(), 0, site, JSON.toJSONString((Object)site), 3));
        }
        return CodeResult.SUCCESSRESULT("delete_success");
    }

    @Transactional
    public Object update(List<com.chinamcloud.haihe.backStageManagement.pojo.Site> sites) {
        if (sites.isEmpty()) {
            return null;
        }
        long beginTime = System.currentTimeMillis();
        for (com.chinamcloud.haihe.backStageManagement.pojo.Site site : sites) {
            Integer siteId = site.getSiteId();
            if (siteId == null) {
                log.error(MessageSource.getMsg("site_id_empty"));
                throw new CustomException("site_id_empty");
            }
            site.setTemplate(null);
            site.setLocation(null);
            site.setPids(null);
            com.chinamcloud.haihe.backStageManagement.pojo.Site siteDb = this.siteQueryMapper.getSiteById(site.getSiteId());
            if (siteDb == null) {
                log.error(MessageSource.getMsg("site_not_exist"));
                throw new CustomException("site_not_exist");
            }
            Integer pid = site.getPid();
            if (pid != null) {
                this.siteSetPids(site);
            }
            Integer active = site.getActive();
            Integer activeDb = siteDb.getActive();
            Integer type = site.getType();
            if (type == null) {
                type = siteDb.getType();
            }
            Integer pagetype = site.getPagetype();
            if ((type == 2 || type == 3 || type == 4) && pagetype != null && pagetype != 1) {
                log.error(MessageSource.getMsg("site_pagetype_not_empty"));
                throw new CustomException("site_pagetype_not_empty");
            }
            if (type == 1 || type == 5 || type == 4) {
                AppSpiderTemplate appSpiderTemplate;
                SpiderTemplate webSpiderTemplate = site.getSpiderTemplate();
                if (webSpiderTemplate != null) {
                    String templateJson = JSON.toJSONString((Object)webSpiderTemplate);
                    site.setTemplate(templateJson);
                }
                if ((appSpiderTemplate = site.getAppSpiderTemplate()) != null) {
                    String templateJson = JSON.toJSONString((Object)appSpiderTemplate);
                    site.setTemplate(templateJson);
                }
                String template = site.getTemplate();
                String templateDb = siteDb.getTemplate();
                if (active != null && active == 1 && ((StringUtils.isBlank((CharSequence)templateDb) || templates.contains(templateDb)) && template == null || template != null && (StringUtils.isBlank((CharSequence)template) || templates.contains(template)))) {
                    log.error(MessageSource.getMsg("site_can_not_active"));
                    throw new CustomException("site_can_not_active");
                }
                if (templates.contains(template) && (activeDb != null && activeDb == 1 && active == null || active != null && active == 1)) {
                    log.error(MessageSource.getMsg("site_template_cannot_be_empty"));
                    throw new CustomException("site_template_cannot_be_empty");
                }
            }
            try {
                this.siteManageMapper.updateByPrimaryKeySelective(site);
                this.redisUtil.del("redis#600::" + site.getSiteId());
                Set<String> SiteQueryServicegetDetailsPageSite = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetDetailsPageSite*");
                this.redisUtil.del(SiteQueryServicegetDetailsPageSite);
                Set<String> getDetailsPageSite = this.redisUtil.scan("redis#60::getDetailsPageSite*");
                this.redisUtil.del(getDetailsPageSite);
                if (pagetype == 1) continue;
                Set<String> SiteQueryServicegetSiteHead = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetSiteHead*");
                this.redisUtil.del(SiteQueryServicegetSiteHead);
                Set<String> selectByPrimaryKey = this.redisUtil.scan("redis#600::selectByPrimaryKey*");
                this.redisUtil.del(selectByPrimaryKey);
                Set<String> SiteQueryServicegetTree = this.redisUtil.scan("redis#86400::com.chinamcloud.haihe.backStageManagement.service.SiteQueryServicegetTree*");
                this.redisUtil.del(SiteQueryServicegetTree);
            }
            catch (Exception e) {
                log.error("siteId: " + site.getSiteId() + " --- " + "update_failed");
                throw new CustomException("update_failed");
            }
        }
        long endTime = System.currentTimeMillis();
        for (com.chinamcloud.haihe.backStageManagement.pojo.Site site : sites) {
            this.crawlerOperationService.addOperation(new CrawlerOperation(site.getSiteId(), new Date(beginTime), endTime - beginTime, sites.size(), 0, site, JSON.toJSONString((Object)site), 3));
        }
        return CodeResult.SUCCESSRESULT("update_success");
    }

    public Object crawlTest(SiteInc siteInc) {
        String url;
        String detailsUrl = siteInc.getDetailsUrl();
        String charset = siteInc.getCharset();
        Integer type = siteInc.getType();
        Integer siteId = siteInc.getSiteId();
        com.chinamcloud.haihe.backStageManagement.pojo.Site dbSite = null;
        if (siteId != null) {
            dbSite = this.siteQueryMapper.getSiteById(siteId);
        }
        if (type == null && dbSite != null) {
            type = dbSite.getType();
            siteInc.setType(type);
        }
        String siteName = siteInc.getSiteName();
        if (siteId == null && StringUtils.isNotBlank((CharSequence)siteName) && type != null) {
            siteId = Math.abs((type + siteName).hashCode());
            siteInc.setSiteId(siteId);
            dbSite = this.siteQueryMapper.getSiteById(siteId);
            if (dbSite != null) {
                log.error(MessageSource.getMsg("site_repeat"));
                return CodeResult.failedResultByMsgSource("site_repeat");
            }
        }
        if (type == null) {
            log.error(MessageSource.getMsg("params_error"));
            return CodeResult.failedResult("params_error");
        }
        CrawlerOperation crawlerOperation = null;
        if (type == 2) {
            crawlerOperation = this.weiXinProcessor.crawlNew(null, siteInc);
        }
        if (type == 3) {
            crawlerOperation = this.weiboProcessor.crawlNew(null, siteInc);
        }
        if (StringUtils.isBlank((CharSequence)(url = siteInc.getUrl()))) {
            if (dbSite == null || StringUtils.isBlank((CharSequence)dbSite.getUrl())) {
                log.error(MessageSource.getMsg("url_empty"));
                return CodeResult.failedResultByMsgSource("url_empty");
            }
            url = dbSite.getUrl();
            siteInc.setUrl(dbSite.getUrl());
        }
        ArrayList<String> newsList = new ArrayList<String>(16);
        if (type == 1 || type == 4) {
            newsList.addAll(this.webProcessor.getListUrl(siteInc, dbSite, url, charset, detailsUrl));
            crawlerOperation = this.webProcessor.crawlNew(newsList, siteInc);
        }
        if (type == 5) {
            newsList.addAll(this.appProcessor.getListUrl(siteInc, dbSite, url, charset, detailsUrl));
            crawlerOperation = this.appProcessor.crawlNew(newsList, siteInc);
        }
        List mapList = (List)crawlerOperation.getOperationDetails();
        if (siteInc.getSiteId() != null) {
            this.crawlerOperationService.addOperation(crawlerOperation);
        }
        if (mapList.size() == 1) {
            Object o;
            if (((Map)mapList.get(0)).size() == 2) {
                return CodeResult.failedResult(((Map)mapList.get(0)).get("msg").toString());
            }
            if (((Map)mapList.get(0)).get("weibo") != null && (o = ((Map)((Map)mapList.get(0)).get("weibo")).get("message")) != null && o.toString().equalsIgnoreCase("search no result")) {
                log.error(o.toString());
                return CodeResult.failedResult(o.toString());
            }
            if (((Map)mapList.get(0)).get("WeiXin") != null) {
                // empty if block
            }
        }
        return CodeResult.SUCCESSRESULT("success", crawlerOperation);
    }

    @Cacheable(value={"redis#3600"}, key="#p0+#p1", unless="#result != null && #result != \"\"")
    public String getPage(String detailUrl, String charset) {
        String htmlStr = "";
        HttpClientDownloader downloader = new HttpClientDownloader();
        try {
            Page page = downloader.download(new Request(detailUrl), Site.me().setCharset(null).toTask());
            htmlStr = page.getRawText();
        }
        catch (Exception e) {
            log.error(MessageSource.getMsg("failed_to_get_HTML"));
        }
        return htmlStr;
    }

    public static void main(String[] args) {
        String html = new SiteManageService().getHtml("https://hhrb.dbw.cn/Html/szbz/20200831/Index.Html", "utf-8");
        System.out.println(html);
    }

    @Cacheable(value={"redis#3600"}, key="#p0+#p1", unless="#result == null && #result == \"\"")
    public String getHtml(String detailUrl, String charset) {
        String htmlStr = "";
        HttpClientDownloaderTLS downloader = new HttpClientDownloaderTLS();
        Html html = null;
        try {
            html = downloader.download(detailUrl);
        }
        catch (Exception e) {
            log.error(MessageSource.getMsg("failed_to_get_HTML"));
        }
        if (html != null) {
            htmlStr = html.toString();
        }
        int time = 1;
        while (htmlStr.equals("") || htmlStr.indexOf("405 Not Allowed") >= 0 || htmlStr.indexOf("404 Not Found") >= 0) {
            HttpUtils.HttpRequestResult httpRequestResult = HttpUtils.executeGet(detailUrl, null, StringUtils.isBlank((CharSequence)charset) ? "utf-8" : charset);
            if (httpRequestResult != null) {
                String msg = httpRequestResult.getMsg();
                if (httpRequestResult.getStatus().equals((Object)HttpUtils.Status.SUCCESS)) {
                    htmlStr = msg;
                }
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (++time <= 2) continue;
            break;
        }
        return htmlStr;
    }

    private void siteSetPids(com.chinamcloud.haihe.backStageManagement.pojo.Site site) {
        if (ToolUtil.isEmpty(site.getPid()) || site.getPid().equals(0)) {
            site.setPid(0);
            site.setPids("[0],");
        } else {
            Integer pid = site.getPid();
            com.chinamcloud.haihe.backStageManagement.pojo.Site temp = this.siteQueryMapper.getSiteById(pid);
            if (temp == null) {
                log.error(MessageSource.getMsg("pSite_empty"));
                throw new CustomException("pSite_empty");
            }
            String pids = temp.getPids();
            site.setPid(pid);
            site.setPids(pids + "[" + pid + "],");
        }
    }

    public void sendMessage(final String userChatId, com.chinamcloud.haihe.backStageManagement.pojo.Site site, int by) {
        if (StringUtils.isNotBlank((CharSequence)userChatId)) {
            cimParam.put("template_key", CimConfig.template_key);
            cimParam.put("to_users", new ArrayList<String>(){
                private static final long serialVersionUID = 4675066641721044569L;
                {
                    this.add(userChatId);
                }
            });
            String tempLate = CimConfig.template;
            cimTemplate.put("siteName", site.getSiteName());
            SiteRequirements siteRequirements = new SiteRequirements();
            siteRequirements.setSiteId(site.getSiteId());
            tempLate = tempLate.replace("{{siteName}}", site.getSiteName());
            String result = "";
            if (by == 1) {
                result = "\u6210\u529f";
                siteRequirements.setStatus((byte)2);
            } else {
                result = "\u5931\u8d25";
                siteRequirements.setStatus((byte)3);
            }
            cimTemplate.put("result", result);
            tempLate = tempLate.replace("{{result}}", result);
            cimTemplate.put("keyword2", tempLate);
            HttpUtils.HttpRequestResult httpRequestResult = HttpUtils.executePost(CimConfig.host + CimConfig.sendMsg + "?appid=" + CimConfig.appid, JSON.toJSONString(cimParam));
            this.siteRequirementsService.update(siteRequirements);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u7684\u8fd4\u56de\u4fe1\u606f\uff1a" + httpRequestResult.getMsg());
        }
    }

    private String getAddrByCode(String code) {
        List<Map<String, Object>> addr = NumberUtils.isNumeric(code) ? this.haiheAreaMapper.getAddr(code, "") : this.haiheAreaMapper.getAddr("", code);
        if (addr != null && !addr.isEmpty() && addr.get(0) != null && addr.get(0).get("name") != null) {
            return addr.get(0).get("name").toString();
        }
        throw new CustomException("site_address_error");
    }

    static {
        cimTemplate = new HashMap<String, String>(7);
        cimTemplate.put("first", "\u606d\u559c\uff0c\u7ad9\u70b9\u6dfb\u52a0\u6210\uff01");
        cimTemplate.put("keyword1", "\u6210\u529f");
        cimTemplate.put("keyword2", "\u3010\u6d77\u6cb3\u5927\u6570\u636e\u3011\u60a8\u6dfb\u52a0\u7684\u4eba\u6c11\u7f51\u7ad9\u70b9\uff0c\u5df2\u7ecf\u6dfb\u52a0\u6210\u529f\uff0c\u8bf7\u70b9\u51fb\u5927\u6570\u636e\u8206\u60c5\u9884\u8b66\u67e5\u770b\u3002");
        cimTemplate.put("keyword3", "2020.08.06");
        cimTemplate.put("remark", "\u606d\u559c\uff0c\u6dfb\u52a0\u6210\u529f\uff01");
        cimTemplate.put("siteName", "\u4eba\u6c11\u7f51");
        cimTemplate.put("result", "\u6210\u529f");
        cimParam = new HashMap<String, Object>(6);
        cimParam.put("send_type", "cim");
        cimParam.put("class_key", "cmc_notice");
        cimParam.put("template_key", "haihe_bigdata_warning");
        cimParam.put("template_variables", cimTemplate);
        cimParam.put("to_users", new ArrayList<String>(){
            private static final long serialVersionUID = -7997789022811982140L;
            {
                this.add("a666a9a4dda5a2fa206648c01314d76d");
            }
        });
        cimParam.put("send_out", new String[]{"in_mail"});
    }
}

