/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.backStageManagement.mapper.SiteQueryMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.AppSpiderTemplate;
import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteInc;
import com.chinamcloud.haihe.backStageManagement.pojo.SpiderTemplate;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.PagerResult;
import com.chinamcloud.haihe.common.utils.DefaultTreeBuildFactory;
import com.chinamcloud.haihe.configService.entity.DataConfig;
import com.chinamcloud.haihe.configService.mapper.DataConfigMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SiteQueryService {
    private static final Logger log = LogManager.getLogger(SiteQueryService.class);
    @Autowired
    private SiteQueryMapper siteQueryMapper;
    @Autowired
    private DataConfigMapper dataconfigMapper;
    private static final Map<String, String> classifyBySite = new HashMap<String, String>(5);

    public Object getType(String useChildrenNum) {
        List<Site> list = this.siteQueryMapper.getType();
        if (list.isEmpty()) {
            log.error(MessageSource.getMsg("data_empty"));
            return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
        if ("true".equals(useChildrenNum)) {
            this.getChildrenNum(list, new SiteInc());
        }
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, list);
    }

    public Object getMergeClassify(List<String> params) {
        ObjectMapper mapper = new ObjectMapper();
        if (params == null) {
            log.error(MessageSource.getMsg("data_empty"));
            return new CodeResult<Map>(CodeResult.Code.SUCCESS, Collections.EMPTY_MAP);
        }
        if (params.isEmpty()) {
            params = new ArrayList<String>(){
                {
                    this.add("1");
                    this.add("2");
                    this.add("3");
                    this.add("4");
                    this.add("5");
                }
            };
        }
        HashSet<String> set = new HashSet<String>();
        for (String param : params) {
            DataConfig dataConfig = null;
            String classifyParam = classifyBySite.get(param);
            if (StringUtils.isBlank((CharSequence)classifyParam)) continue;
            try {
                dataConfig = this.dataconfigMapper.selectByPrimaryKey("default", classifyParam, "1");
            }
            catch (Exception e) {
                continue;
            }
            try {
                Map map = (Map)mapper.readValue(dataConfig.getData(), Map.class);
                List classify_list = (List)map.get("classify_list");
                if (classify_list == null) continue;
                for (Map classifyMap : classify_list) {
                    String name = (String)classifyMap.get("name");
                    if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                    set.add(name);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList mapList = new ArrayList();
        set.stream().forEach(x -> mapList.add(new HashMap<String, String>(){
            private static final long serialVersionUID = 1531065567357928937L;
            {
                this.put("name", x);
            }
        }));
        return new CodeResult(CodeResult.Code.SUCCESS, mapList);
    }

    public Object getClassify(Integer level, Boolean useChildrenNum) {
        List<Map<String, Object>> classify = this.siteQueryMapper.getClassify(level);
        if (classify == null || classify.isEmpty()) {
            log.error(MessageSource.getMsg("data_empty"));
            return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
        if (useChildrenNum.booleanValue()) {
            this.getSiteNumByMapData(classify, "Classify");
        }
        return new CodeResult<List<Map<String, Object>>>(CodeResult.Code.SUCCESS, classify);
    }

    @Cacheable(value={"redis#7200"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#site.validate()")
    public Object getSiteTree(SiteInc site) {
        List<Site> sites;
        if (site == null) {
            log.error(MessageSource.getMsg("params_error"));
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Site resultSite = null;
        Integer siteId = site.getSiteId();
        if (siteId != null) {
            CodeResult codeResult = (CodeResult)this.getDetailsPageSite(site);
            List result = (List)codeResult.getResult();
            if (!result.isEmpty()) {
                resultSite = (Site)result.get(0);
                site.setPids("[" + resultSite.getSiteId() + "]");
                site.setSiteName(null);
                site.setSiteId(null);
            } else {
                return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
            }
        }
        if ((sites = this.siteQueryMapper.selectByPrimaryKey(site)) == null || sites.isEmpty()) {
            if (resultSite == null) {
                log.error(MessageSource.getMsg("data_empty"));
                return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
            }
            final Site finalResultSite = resultSite;
            return new CodeResult<3>(CodeResult.Code.SUCCESS, new ArrayList<Site>(){
                {
                    this.add(finalResultSite);
                }
            });
        }
        List<Site> results = this.CompletionOfTree(site, sites, resultSite);
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, results);
    }

    public List<Site> CompletionOfTree(SiteInc site, List<Site> sites, Site resultSite) {
        this.getList(sites);
        DefaultTreeBuildFactory<Site> factory = new DefaultTreeBuildFactory<Site>();
        int targetId = 0;
        if (site.isUsePid()) {
            Integer pid = site.getPid();
            if (pid != null) {
                targetId = pid;
            } else {
                String pids = site.getPids();
                if (StringUtils.isNotBlank((CharSequence)pids)) {
                    String replace = pids.replace("[", "").replace("]", "");
                    targetId = Integer.parseInt(replace.substring(replace.lastIndexOf(",") + 1));
                }
            }
        }
        factory.setRootParentId(String.valueOf(targetId));
        List<Site> list = factory.doTreeBuild(sites);
        ArrayList<Site> results = new ArrayList<Site>();
        if (resultSite != null && resultSite.getSiteId().equals(targetId)) {
            resultSite.setSites(list);
            results.add(resultSite);
        } else {
            results.addAll(list);
        }
        return results;
    }

    @Cacheable(value={"redis#86400"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getTree(SiteInc site) {
        List result;
        if (site == null) {
            log.error(MessageSource.getMsg("params_error"));
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Site resultSite = null;
        Integer siteId = site.getSiteId();
        if (siteId != null) {
            SiteInc temp = new SiteInc();
            temp.setSiteId(site.getSiteId());
            temp.setPagetype(site.getPagetype());
            temp.setHasListPage(site.isHasListPage());
            CodeResult codeResult = (CodeResult)this.getDetailsPageSite(temp);
            result = (List)codeResult.getResult();
            if (result.isEmpty()) {
                return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
            }
        } else {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        resultSite = (Site)result.get(0);
        site.setPids("[" + resultSite.getSiteId() + "]");
        site.setSiteId(null);
        List<Site> sites = this.siteQueryMapper.selectByPrimaryKey(site);
        if (sites == null || sites.isEmpty()) {
            if (resultSite == null) {
                log.error(MessageSource.getMsg("data_empty"));
                return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
            }
            final Site finalResultSite = resultSite;
            return new CodeResult<4>(CodeResult.Code.SUCCESS, new ArrayList<Site>(){
                private static final long serialVersionUID = -1913560158811971773L;
                {
                    this.add(finalResultSite);
                }
            });
        }
        List<Site> results = this.CompletionOfTree(site, sites, resultSite);
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, results);
    }

    @Cacheable(value={"redis#86400"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getSiteHead(SiteInc site) {
        if (site == null) {
            log.error(MessageSource.getMsg("params_error"));
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<Site> sites = this.siteQueryMapper.getSiteHead(site);
        if (sites == null || sites.isEmpty()) {
            log.error(MessageSource.getMsg("data_empty"));
            return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
        if (site.isUseChildrenNum() && (site.getType() == 1 || site.getType() == 4)) {
            this.getChildrenNum(sites, site);
        }
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, sites);
    }

    @Cacheable(value={"redis#300"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getDetailsPageSite(SiteInc siteInc) {
        if (siteInc == null) {
            log.error(MessageSource.getMsg("data_empty"));
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (siteInc.getPage() != null && siteInc.getPageSize() != null) {
            PageHelper.startPage((int)siteInc.getPage(), (int)siteInc.getPageSize());
            List<Site> activityCollectBeans = this.siteQueryMapper.getDetailsPageSite(siteInc);
            if (activityCollectBeans == null || activityCollectBeans.isEmpty()) {
                log.error(MessageSource.getMsg("data_empty"));
            } else {
                this.setTemplate(activityCollectBeans);
            }
            PageInfo pageInfo = new PageInfo(activityCollectBeans);
            PagerResult bean = new PagerResult();
            BeanUtils.copyProperties((Object)pageInfo, bean);
            return new CodeResult(CodeResult.Code.SUCCESS, bean);
        }
        List<Site> sites = this.siteQueryMapper.getDetailsPageSite(siteInc);
        if (sites == null || sites.isEmpty()) {
            log.error(MessageSource.getMsg("data_empty"));
            return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
        this.setTemplate(sites);
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, sites);
    }

    public void getChildrenNum(List<Site> sites, SiteInc siteInc) {
        for (Site site : sites) {
            Integer siteId = site.getSiteId();
            Site siteParameter = new Site();
            if (siteId != null) {
                siteParameter.setPids("[" + siteId + "]");
            }
            siteParameter.setType(siteInc.getType());
            siteParameter.setLevel(siteInc.getLevel());
            siteParameter.setClassify(siteInc.getClassify());
            siteParameter.setProvince(siteInc.getProvince());
            siteParameter.setPrefecture(siteInc.getPrefecture());
            siteParameter.setMunicipality(siteInc.getMunicipality());
            Integer childrenNum = this.siteQueryMapper.getChildrenNum(siteParameter);
            site.setChildrenNum(childrenNum == null ? 0 : childrenNum);
        }
    }

    public Object getPrepareCrawlSite(Site site) {
        if (site != null && site.getSiteId() != null) {
            Site siteById = this.siteQueryMapper.getSiteById(site.getSiteId());
            return new CodeResult<Site>(CodeResult.Code.SUCCESS, siteById);
        }
        if (site.getType() == null || site.getActive() == null || site.getPagetype() == null) {
            log.error(MessageSource.getMsg("params_error"));
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<Site> prepareCrawlSite = this.siteQueryMapper.getPrepareCrawlSite(site);
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, prepareCrawlSite);
    }

    public Object getNewCrawlSite(Site site) {
        List<Site> prepareCrawlSite = this.siteQueryMapper.getNewCrawlSite(site);
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, prepareCrawlSite);
    }

    public void getSiteNumByMapData(List<Map<String, Object>> readValue, String value) {
        block10: for (Map<String, Object> map : readValue) {
            ArrayList<Site> list = new ArrayList<Site>();
            Site site = new Site();
            switch (value) {
                case "Type": {
                    site.setType(Integer.valueOf(map.get("code").toString()));
                    break;
                }
                case "Level": {
                    site.setLevel(Integer.valueOf(map.get("code").toString()));
                    break;
                }
                case "Classify": {
                    site.setClassify(map.get("name").toString());
                    break;
                }
                default: {
                    continue block10;
                }
            }
            list.add(site);
            this.getChildrenNum(list, new SiteInc());
            map.put("childrenNum", ((Site)list.get(0)).getChildrenNum().toString());
        }
    }

    public void getList(List<Site> siteList) {
        Map maps = siteList.stream().collect(Collectors.toMap(Site::getSiteId, Function.identity(), (key1, key2) -> key2));
        HashSet<Integer> set = new HashSet<Integer>();
        for (Site node : siteList) {
            String nodeParentIds = node.getNodeParentIds();
            if (StringUtils.isBlank((CharSequence)nodeParentIds)) {
                nodeParentIds = node.getNodeParentId();
            }
            String[] split = nodeParentIds.replace("[", "").replace("]", "").split(",");
            for (int i = 1; i < split.length; ++i) {
                String s = split[i];
                if (maps.containsKey(Integer.valueOf(s))) continue;
                set.add(Integer.valueOf(s));
            }
        }
        if (!set.isEmpty()) {
            List<Site> siteByIds = this.siteQueryMapper.getSiteByIds(set);
            siteByIds.forEach(x -> {
                if (x != null && x.getSiteId() != null) {
                    x.setVersion(10);
                    maps.put(x.getSiteId(), x);
                }
            });
        }
        siteList.clear();
        siteList.addAll(new ArrayList(maps.values()));
    }

    public void setList(List<Site> results, List<Site> list, Integer targetId) {
        for (Site result : list) {
            if (targetId == 0) {
                if (!result.getPid().equals(targetId)) continue;
                results.addAll(result.getSites());
                continue;
            }
            if (result.getSiteId().equals(targetId)) {
                results.addAll(result.getSites());
                continue;
            }
            this.setList(results, result.getSites(), targetId);
        }
    }

    public void setTemplate(List<Site> sites) {
        for (Site site : sites) {
            String template = site.getTemplate();
            if (!StringUtils.isNotBlank((CharSequence)template)) continue;
            try {
                if (site.getType() == 1 || site.getType() == 4) {
                    site.setSpiderTemplate((SpiderTemplate)JSON.parseObject((String)template, SpiderTemplate.class));
                }
                if (site.getType() != 5) continue;
                site.setAppSpiderTemplate((AppSpiderTemplate)JSON.parseObject((String)template, AppSpiderTemplate.class));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public CodeResult<Site> getSiteById(Integer siteId) {
        Site site = this.siteQueryMapper.getSiteById(siteId);
        return new CodeResult<Site>(CodeResult.Code.SUCCESS, site);
    }

    public CodeResult<List<Site>> getSiteByIds(Set<Integer> siteIds) {
        if (siteIds == null || siteIds.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<Site> sites = this.siteQueryMapper.getSiteByIds(siteIds);
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, sites);
    }

    public CodeResult<List<Site>> getSiteByUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            log.error(MessageSource.getMsg("params_error"));
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Site siteByUrl = new Site();
        siteByUrl.setUrl(url);
        List<Site> siteList = this.siteQueryMapper.getSite(siteByUrl);
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, siteList);
    }

    static {
        classifyBySite.put("1", "site_classify");
        classifyBySite.put("2", "site_weixi_classify");
        classifyBySite.put("3", "site_weibo_classify");
        classifyBySite.put("4", "site_dianzibao_classify");
        classifyBySite.put("5", "site_classify");
    }
}

