/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.haihe.backStageManagement.mapper.UserSubscriptionSitesMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteRequirements;
import com.chinamcloud.haihe.backStageManagement.pojo.UserSubscriptionSites;
import com.chinamcloud.haihe.backStageManagement.service.SiteQueryService;
import com.chinamcloud.haihe.backStageManagement.service.SiteRequirementsService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.utils.DefaultTreeBuildFactory;
import com.chinamcloud.haihe.common.utils.ZipUtils;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserSiteManageService {
    private static final Logger log = LogManager.getLogger(UserSiteManageService.class);
    @Autowired
    private UserSubscriptionSitesMapper userSubscriptionSitesMapper;
    @Autowired
    private SiteQueryService siteQueryService;
    @Autowired
    private SiteRequirementsService siteRequirementsService;
    private final String start = "$.*.";

    public Object operatorSite(Site site, String userToken, String actionType) {
        if (site.getType() == null || StringUtils.isBlank((CharSequence)userToken)) {
            log.error("\u7528\u6237\u7ba1\u7406\u7ad9\u70b9\u65f6\u7f3a\u5c11\u53c2\u6570");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String siteData = "";
        UserSubscriptionSites userSubscription = this.userSubscriptionSitesMapper.getUserSubscriptionSites(userToken, site.getType());
        if (userSubscription != null) {
            siteData = userSubscription.getSiteData();
        }
        String data = ZipUtils.unzip(siteData);
        int siteHeadNum = 0;
        if (StringUtils.isNotBlank((CharSequence)siteData)) {
            List<Site> sites = site.getSites();
            if (sites != null) {
                for (Site temp : sites) {
                    List list;
                    List<Site> result;
                    CodeResult<Site> codeResult = this.siteQueryService.getSiteById(temp.getSiteId());
                    if ("subscription".equalsIgnoreCase(actionType)) {
                        Site dbSite = codeResult.getResult();
                        if (StringUtils.isBlank((CharSequence)temp.getPids())) {
                            temp.setPids(dbSite.getPids());
                        }
                        if (temp.getPid() == null) {
                            temp.setPid(dbSite.getPid());
                        }
                        if (StringUtils.isBlank((CharSequence)temp.getSiteName())) {
                            temp.setSiteName(dbSite.getSiteName());
                        }
                    }
                    if (temp == null || temp.getPid() == null || StringUtils.isBlank((CharSequence)temp.getPids()) || StringUtils.isBlank((CharSequence)temp.getSiteName()) || ("delete".equalsIgnoreCase(actionType) || "subscription".equalsIgnoreCase(actionType) && StringUtils.isBlank((CharSequence)temp.getUrl()) || "update".equalsIgnoreCase(actionType)) && temp.getSiteId() == null) continue;
                    if ("add".equalsIgnoreCase(actionType)) {
                        Site siteById;
                        actionType = "add";
                        if (StringUtils.isBlank((CharSequence)temp.getUrl()) || StringUtils.isBlank((CharSequence)temp.getSiteName())) {
                            log.error("\u6dfb\u52a0\u7684\u7ad9\u70b9\u7684\u6570\u636e\u4e2d\u6ca1\u6709url \u6216\u8005 siteName");
                            return CodeResult.failedResultByMsgSource("params_error");
                        }
                        if (temp.getSiteId() == null) {
                            temp.setSiteId(Math.abs((temp.getType() + temp.getSiteName()).hashCode()));
                        }
                        if ((siteById = codeResult.getResult()) != null) {
                            return CodeResult.failedResultByMsgSource("site_repeat");
                        }
                        CodeResult<List<Site>> siteByUrl = this.siteQueryService.getSiteByUrl(temp.getUrl());
                        result = siteByUrl.getResult();
                        if (result == null || result.isEmpty()) {
                            SiteRequirements siteRequirements = new SiteRequirements();
                            siteRequirements.setCreateTime(new Date(System.currentTimeMillis()));
                            siteRequirements.setPid(temp.getPid());
                            siteRequirements.setPids(temp.getPids());
                            siteRequirements.setSiteId(temp.getSiteId());
                            siteRequirements.setSiteName(temp.getSiteName());
                            siteRequirements.setUrl(temp.getUrl());
                            siteRequirements.setUserToken(userToken);
                            siteRequirements.setStatus((byte)1);
                            siteRequirements.setType(site.getType().byteValue());
                            this.siteRequirementsService.insert(siteRequirements);
                        } else {
                            temp.setSiteId(result.get(0).getSiteId());
                        }
                    }
                    if ("update".equalsIgnoreCase(actionType)) {
                        CodeResult<SiteRequirements> siteRequirementsBySiteId = this.siteRequirementsService.getSiteRequirementsBySiteId(temp.getSiteId());
                        SiteRequirements siteRequirements = new SiteRequirements();
                        siteRequirements.setCreateTime(new Date(System.currentTimeMillis()));
                        siteRequirements.setPid(temp.getPid());
                        siteRequirements.setPids(temp.getPids());
                        siteRequirements.setSiteId(temp.getSiteId());
                        siteRequirements.setSiteName(temp.getSiteName());
                        siteRequirements.setUrl(temp.getUrl());
                        siteRequirements.setUserToken(userToken);
                        siteRequirements.setStatus((byte)1);
                        siteRequirements.setType(site.getType().byteValue());
                        result = siteRequirementsBySiteId.getResult();
                        if (result != null) {
                            if (((SiteRequirements)((Object)result)).getUrl().contains(siteRequirements.getUrl())) {
                                actionType = "update";
                                if (((SiteRequirements)((Object)result)).getSiteName().contains(siteRequirements.getSiteName())) {
                                    continue;
                                }
                            } else {
                                actionType = "add";
                                this.editSiteData(data, temp, "delete", site.getType());
                                CodeResult<List<Site>> siteByUrl = this.siteQueryService.getSiteByUrl(siteRequirements.getUrl());
                                List<Site> siteList = siteByUrl.getResult();
                                if (siteList == null || siteList.isEmpty()) {
                                    if (StringUtils.isBlank((CharSequence)siteRequirements.getSiteName())) {
                                        siteRequirements.setSiteName(((SiteRequirements)((Object)result)).getSiteName());
                                    }
                                    siteRequirements.setSiteId(Math.abs((siteRequirements.getUrl() + temp.getType()).hashCode()));
                                    this.siteRequirementsService.insert(siteRequirements);
                                } else {
                                    temp.setSiteId(siteList.get(0).getSiteId());
                                }
                            }
                        }
                    }
                    if ((list = JSON.parseArray((String)(data = this.editSiteData(data, temp, actionType, site.getType())), Site.class)).isEmpty() || ((Site)list.get(0)).getPid() != 0) continue;
                    siteHeadNum = ((Site)list.get(0)).getSites().size();
                }
                data = ZipUtils.zip(data);
            }
        } else {
            for (Site siteSite : site.getSites()) {
                CodeResult<Site> siteById = this.siteQueryService.getSiteById(siteSite.getSiteId());
                Site site_db = siteById.getResult();
                if (site_db == null) {
                    log.error("\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01\u4e0d\u80fd\u8ba2\u9605");
                    throw new CustomException("\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01\u4e0d\u80fd\u8ba2\u9605");
                }
                siteSite.setSiteName(site_db.getSiteName());
                siteSite.setPid(site_db.getPid());
                siteSite.setPids(site_db.getPids());
                siteSite.setPagetype(site_db.getPagetype());
                if (StringUtils.isNotBlank((CharSequence)site_db.getSiteAvatar())) {
                    siteSite.setSiteAvatar(site_db.getSiteAvatar());
                }
                if (!StringUtils.isNotBlank((CharSequence)site_db.getSiteDetailsLink())) continue;
                siteSite.setSiteDetailsLink(site_db.getSiteDetailsLink());
            }
            this.siteQueryService.getList(site.getSites());
            site.getSites().forEach(Site::editSite);
            DefaultTreeBuildFactory<Site> factory = new DefaultTreeBuildFactory<Site>();
            factory.setRootParentId("0");
            List<Site> list = factory.doTreeBuild(site.getSites());
            data = ZipUtils.zip(JSON.toJSONString(list));
            if (!list.isEmpty() && list.get(0).getPid() == 0) {
                siteHeadNum = list.get(0).getSites().size();
            }
        }
        this.userSubscriptionSitesMapper.insert(userToken, site.getType(), data, siteHeadNum);
        return new CodeResult(CodeResult.Code.SUCCESS);
    }

    public CodeResult<List<Site>> getUserSubscription(List<Integer> typeList, String userToken) {
        ArrayList sites = new ArrayList(16);
        List<UserSubscriptionSites> userSubscriptionSitesList = this.userSubscriptionSitesMapper.getUserSubscriptionSitesList(userToken, typeList);
        for (UserSubscriptionSites userSubscriptionSites : userSubscriptionSitesList) {
            String siteData;
            String data;
            if (userSubscriptionSites == null || !StringUtils.isNotBlank((CharSequence)(data = ZipUtils.unzip(siteData = userSubscriptionSites.getSiteData())))) continue;
            sites.addAll(JSON.parseArray((String)data, Site.class));
        }
        return new CodeResult<List<Site>>(CodeResult.Code.SUCCESS, sites);
    }

    public Object getUserSubscriptionSiteHeadNum(List<Integer> types, String userToken) {
        ArrayList mapList = new ArrayList(16);
        for (Integer type : types) {
            UserSubscriptionSites userSubscription = this.userSubscriptionSitesMapper.getUserSubscriptionSiteHeadNum(userToken, type);
            if (userSubscription == null) continue;
            HashMap<String, Integer> map = new HashMap<String, Integer>(2);
            Integer siteHeadNum = userSubscription.getSiteHeadNum();
            map.put("type", type);
            map.put("siteHeadNum", siteHeadNum);
            mapList.add(map);
        }
        return new CodeResult(CodeResult.Code.SUCCESS, mapList);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String editSiteData(String siteData, Site site, String actionType, Integer type) {
        DocumentContext document = JsonPath.parse((String)siteData);
        StringBuilder start = new StringBuilder(this.start);
        String ending = "[?(@.siteId == " + site.getSiteId() + ")]";
        final String pids = site.getPids();
        ArrayList<String> strings = new ArrayList<String>(){
            private static final long serialVersionUID = 8583875696595256724L;
            {
                this.addAll(Arrays.asList(pids.replaceAll("]", "").replaceAll("\\[", "").split(",")));
            }
        };
        int length = strings.size();
        if (length > 1) {
            for (int i = 1; i <= length - 1; ++i) {
                start.append("sites[*].");
            }
        }
        if ("subscription".contains(actionType)) {
            CodeResult<Site> siteById = this.siteQueryService.getSiteById(site.getSiteId());
            Site site_db = siteById.getResult();
            if (site_db == null) {
                log.error("\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01\u4e0d\u80fd\u8ba2\u9605");
                throw new CustomException("\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01\u4e0d\u80fd\u8ba2\u9605");
            }
            if (!type.equals(site_db.getType())) {
                log.error("\u64cd\u4f5c\u7ad9\u70b9\u7c7b\u578b\u4e0d\u7b26\u5408\uff01");
                throw new CustomException("\u64cd\u4f5c\u7ad9\u70b9\u7c7b\u578b\u4e0d\u7b26\u5408\uff01");
            }
            site.setSiteName(site_db.getSiteName());
            site.setPid(site_db.getPid());
            site.setPids(site_db.getPids());
            site.setPagetype(site_db.getPagetype());
            if (StringUtils.isNotBlank((CharSequence)site_db.getSiteAvatar())) {
                site.setSiteAvatar(site_db.getSiteAvatar());
            }
            if (StringUtils.isNotBlank((CharSequence)site_db.getSiteDetailsLink())) {
                site.setSiteDetailsLink(site_db.getSiteDetailsLink());
            }
        }
        JSONObject json = new JSONObject();
        json.put("type", (Object)site.getType());
        json.put("siteId", (Object)site.getSiteId());
        json.put("siteName", (Object)site.getSiteName());
        json.put("url", (Object)site.getUrl());
        json.put("pid", (Object)site.getPid());
        json.put("pids", (Object)site.getPids());
        json.put("pagetype", (Object)site.getPagetype());
        if (site.getType() == 2 || site.getType() == 3) {
            json.put("siteAvatar", (Object)site.getSiteAvatar());
        }
        if (site.getType() == 2 || site.getType() == 3) {
            json.put("siteDetailsLink", (Object)site.getSiteDetailsLink());
        }
        json.put("sites", new ArrayList(16));
        JsonPath jsonPath_select = JsonPath.compile((String)(start + ending), (Predicate[])new Predicate[0]);
        List list = (List)document.read(jsonPath_select);
        if (list == null || list.isEmpty()) {
            if (!"add".equalsIgnoreCase(actionType) && !"subscription".equalsIgnoreCase(actionType)) {
                log.error("\u6570\u636e\u4e0d\u5b58\u5728\uff01\u4e0d\u80fd\u5220\u9664\u548c\u66f4\u65b0");
                throw new CustomException("\u6570\u636e\u4e0d\u5b58\u5728\uff01\u4e0d\u80fd\u5220\u9664\u548c\u66f4\u65b0");
            }
            String addEnding = "[?(@.siteId == " + site.getPid() + ")].sites";
            if (site.getPid() == 0) {
                addEnding = "$";
            } else {
                if (!this.editParentSite(document, site.getPid()).booleanValue()) {
                    log.error("\u6dfb\u52a0\u6216\u8005\u8ba2\u9605\u5931\u8d25\uff01");
                    throw new CustomException("\u6dfb\u52a0\u6216\u8005\u8ba2\u9605\u5931\u8d25\uff01");
                }
                start = new StringBuilder(this.start);
                strings.remove(site.getPid().toString());
                int size = strings.size();
                if (size > 1) {
                    for (int i = 1; i <= size - 1; ++i) {
                        start.append("sites[*].");
                    }
                }
                addEnding = start + addEnding;
            }
            JsonPath jsonPath_add = JsonPath.compile((String)addEnding, (Predicate[])new Predicate[0]);
            document.add(jsonPath_add, (Object)json);
            return document.jsonString();
        }
        switch (actionType) {
            case "delete": {
                document.delete(jsonPath_select);
                return document.jsonString();
            }
            case "subscription": {
                log.error("\u8be5\u7ad9\u70b9\u5df2\u7ecf\u8ba2\u9605\uff01");
                throw new CustomException("\u8be5\u7ad9\u70b9\u5df2\u7ecf\u8ba2\u9605\uff01");
            }
            case "add": 
            case "update": {
                JsonPath jsonPath_update;
                if (StringUtils.isNotBlank((CharSequence)site.getSiteName())) {
                    jsonPath_update = JsonPath.compile((String)(start + ending + ".siteName"), (Predicate[])new Predicate[0]);
                    if (site.getVersion() == null || site.getVersion() != 10) {
                        document.set(jsonPath_update, (Object)site.getSiteName());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)site.getUrl())) return document.jsonString();
                jsonPath_update = JsonPath.compile((String)(start + ending + ".url"), (Predicate[])new Predicate[0]);
                if (site.getVersion() != null) {
                    if (site.getVersion() == 10) return document.jsonString();
                }
                document.set(jsonPath_update, (Object)site.getUrl());
                return document.jsonString();
            }
        }
        log.error("\u4e0d\u80fd\u8fdb\u884c\u5176\u4ed6\u64cd\u4f5c\uff01");
        throw new CustomException("\u4e0d\u80fd\u8fdb\u884c\u5176\u4ed6\u64cd\u4f5c\uff01");
    }

    public Boolean editParentSite(DocumentContext document, Integer siteId) {
        String[] split;
        ArrayList<String> strings;
        int length;
        StringBuilder start = new StringBuilder(this.start);
        CodeResult<Site> siteById = this.siteQueryService.getSiteById(siteId);
        Site site = siteById.getResult();
        if (site == null) {
            if (siteId != 0) {
                return false;
            }
            site = new Site();
        }
        if ((length = (strings = new ArrayList<String>(split = site.getPids().replaceAll("]", "").replaceAll("\\[", "").split(",")){
            private static final long serialVersionUID = 174255876228224416L;
            final /* synthetic */ String[] val$split;
            {
                this.val$split = stringArray;
                this.addAll(Arrays.asList(this.val$split));
            }
        }).size()) > 1) {
            for (int i = 1; i <= length - 1; ++i) {
                start.append("sites[*].");
            }
        }
        String ending = "[?(@.siteId == " + siteId + ")]";
        JsonPath parent_select = JsonPath.compile((String)(start + ending), (Predicate[])new Predicate[0]);
        List parent_list = (List)document.read(parent_select);
        if (parent_list == null || parent_list.isEmpty()) {
            JSONObject json = new JSONObject();
            json.put("type", (Object)site.getType());
            json.put("siteId", (Object)site.getSiteId());
            json.put("siteName", (Object)site.getSiteName());
            json.put("url", (Object)site.getUrl());
            json.put("pid", (Object)site.getPid());
            json.put("pids", (Object)site.getPids());
            json.put("pagetype", (Object)site.getPagetype());
            if (site.getType() == 2 || site.getType() == 3) {
                json.put("siteAvatar", (Object)site.getSiteAvatar());
            }
            if (site.getType() == 2 || site.getType() == 3) {
                json.put("siteDetailsLink", (Object)site.getSiteDetailsLink());
            }
            json.put("sites", new ArrayList(16));
            start = new StringBuilder(this.start);
            strings.remove(site.getPid().toString());
            int size = strings.size();
            if (size > 1) {
                for (int i = 1; i <= size - 1; ++i) {
                    start.append("sites[*].");
                }
            }
            String addEnding = "[?(@.siteId == " + site.getPid() + ")].sites";
            String compile = start + addEnding;
            if (site.getPid() == 0) {
                compile = "$";
            } else if (!this.editParentSite(document, site.getPid()).booleanValue()) {
                return false;
            }
            JsonPath jsonPath_add = JsonPath.compile((String)compile, (Predicate[])new Predicate[0]);
            document.add(jsonPath_add, (Object)json);
        }
        return true;
    }

    public static void main(String[] args) {
        String data = ZipUtils.unzip("UEsDBBQACAgIAGucElEAAAAAAAAAAAAAAAABAAAAMIuuVkrOyMxJKUrN8yvNVbIy1FEqyExRsjIA\n08VKVkrRBrE6SjpKxZklqY5liSWJRUCxjJKSAit9/fIKvcKc/PR8veQ8/dzcjNTEFP1A48RSj/Sq\n8ipfs4og04DMJBfnzMSKsErnnOxyw9LMpECTYMf0PIsAcy8vk8xkj0hj49z0oMKAUqNAfQOoLZ5A\n6y2MzC0MjSF8v8TcVKCd5xZdOApVAXRWNJq7DaDuhmlEcnw0RGwAfGFoaWluZmJqZmaG4pNLRw6+\n2r5o0x4k3wAdV1JZAJQ00lEqLcoBKqrMSUsqr1CqRcjUxgIAUEsHCGHcuyzpAAAArQEAAA==\n");
        System.out.println(data);
    }
}

