/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.afterprocessor;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.IAfterProcessor;
import com.chinamcloud.haihe.common.bean.FacetResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RepetitionAfterProcessor
implements IAfterProcessor<List<FacetResult>, CodeResult> {
    private static final long serialVersionUID = 1467274155652565108L;
    private Integer size;
    private String facetField;
    private static final Map<String, String> emotionTendencyMap = new HashMap<String, String>(3);
    private static final Map<String, String> levelMap;
    private static final Map<String, String> sourceMap;

    public RepetitionAfterProcessor() {
    }

    public RepetitionAfterProcessor(Integer size) {
        this.size = size;
    }

    public RepetitionAfterProcessor(String facetField) {
        this.facetField = facetField;
    }

    public RepetitionAfterProcessor(Integer size, String facetField) {
        this.size = size;
        this.facetField = facetField;
    }

    @Override
    public CodeResult process(List<FacetResult> facetResults) {
        if (facetResults != null) {
            int time = this.size == null || this.size <= 0 ? facetResults.size() : this.size.intValue();
            ArrayList mapList = new ArrayList(time);
            for (int i = 0; i < time; ++i) {
                FacetResult facetResult = facetResults.get(i);
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                if (StringUtils.isNotBlank((CharSequence)this.facetField)) {
                    switch (this.facetField) {
                        case "emotion_tendency": {
                            map.put("key", emotionTendencyMap.get(facetResult.getName()));
                            break;
                        }
                        case "source": {
                            map.put("key", sourceMap.get(facetResult.getName()));
                            break;
                        }
                        case "level": {
                            map.put("key", levelMap.get(facetResult.getName()));
                            break;
                        }
                        case "tb_nickname": 
                        case "parentSource": {
                            map.put("key", facetResult.getName());
                            List<FacetResult> facetResults1 = facetResult.getFacetResults();
                            ArrayList mapList1 = new ArrayList(16);
                            if (facetResults1 != null) {
                                for (FacetResult result : facetResults1) {
                                    HashMap<String, String> map1 = new HashMap<String, String>(16);
                                    map1.put("key", result.getName());
                                    map1.put("count", result.getValue() + "");
                                    mapList1.add(map1);
                                }
                            }
                            map.put("logUrl", mapList1);
                            break;
                        }
                        default: {
                            map.put("key", facetResult.getName());
                            break;
                        }
                    }
                } else {
                    map.put("key", facetResult.getName());
                }
                map.put("count", facetResult.getValue() + "");
                mapList.add(map);
            }
            return new CodeResult(CodeResult.Code.Success, mapList);
        }
        return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
    }

    static {
        emotionTendencyMap.put("1", "\u6b63\u9762");
        emotionTendencyMap.put("0", "\u4e2d\u7acb");
        emotionTendencyMap.put("-1", "\u8d1f\u9762");
        levelMap = new HashMap<String, String>(9);
        levelMap.put("0", "\u7f51\u7edc");
        levelMap.put("1", "\u4e2d\u592e");
        levelMap.put("2", "\u7701\u7ea7");
        levelMap.put("3", "\u5e02\u7ea7");
        levelMap.put("4", "\u533a\u53bf");
        levelMap.put("5", "\u653f\u5e9c\u7c7b");
        levelMap.put("6", "\u4f01\u4e1a\u7c7b");
        levelMap.put("7", "\u4e13\u4e1a\u7c7b");
        levelMap.put("8", "\u81ea\u5a92\u4f53\u7c7b");
        sourceMap = new HashMap<String, String>(6);
        sourceMap.put("News", "\u7f51\u7ad9");
        sourceMap.put("WeiXin", "\u5fae\u4fe1");
        sourceMap.put("Weibo", "\u5fae\u535a");
        sourceMap.put("EPAPER", "\u7535\u5b50\u62a5");
        sourceMap.put("App", "App");
        sourceMap.put("ShiPin", "\u89c6\u9891");
    }
}

