/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.afterprocessor;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.common.afterprocessor.IAfterProcessor;
import com.chinamcloud.haihe.common.pojo.TableNews;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class TableArticlesAfterProcessor
implements IAfterProcessor<Map<String, Object>, Boolean> {
    private static final long serialVersionUID = -6599065867923768615L;

    @Override
    public Boolean process(Map<String, Object> paramMap) {
        List tableData = (List)paramMap.get("tableData");
        HttpServletResponse response = (HttpServletResponse)paramMap.get("response");
        try {
            if (tableData == null || tableData.isEmpty()) {
                int n = 1 / 0;
            }
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u8206\u60c5\u6570\u636e", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.PALE_BLUE.getIndex()));
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
            headWriteCellStyle.setWriteFont(headWriteFont);
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            contentWriteCellStyle.setWrapped(Boolean.valueOf(true));
            contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
            EasyExcel.write((OutputStream)response.getOutputStream(), TableNews.class).autoCloseStream(Boolean.FALSE).sheet("\u8206\u60c5\u6570\u636e").registerWriteHandler((WriteHandler)horizontalCellStyleStrategy).doWrite(tableData);
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("code", "4009");
            map.put("msg", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            try {
                response.getWriter().println(JSON.toJSONString(map));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

