/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.cache;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.Cache;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;

public class RedisAutoCacheManager
extends RedisCacheManager {
    private static final String SPLIT_FLAG = "#";
    private static final int CACHE_LENGTH = 2;
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    public RedisAutoCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
    }

    protected Collection<RedisCache> loadCaches() {
        return super.loadCaches();
    }

    protected RedisCache getMissingCache(String name) {
        return super.getMissingCache(name);
    }

    public Map<String, RedisCacheConfiguration> getCacheConfigurations() {
        return super.getCacheConfigurations();
    }

    protected RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        if (StringUtils.isBlank((CharSequence)name) || !name.contains(SPLIT_FLAG)) {
            return super.createRedisCache(name, cacheConfig);
        }
        String[] cacheArray = name.split(SPLIT_FLAG);
        if (cacheArray.length < 2) {
            return super.createRedisCache(name, cacheConfig);
        }
        if (cacheConfig != null) {
            long cacheAge = Long.parseLong(cacheArray[1]);
            switch (cacheAge + "") {
                case "600": {
                    cacheAge = 60 * (RANDOM.nextInt(2) * 5 + 10);
                    break;
                }
                case "3600": {
                    cacheAge = 60 * (RANDOM.nextInt(5) * 10 + 50);
                    break;
                }
            }
            cacheConfig = cacheConfig.entryTtl(Duration.ofSeconds(cacheAge));
        }
        return super.createRedisCache(name, cacheConfig);
    }

    public void setTransactionAware(boolean transactionAware) {
        super.setTransactionAware(transactionAware);
    }

    public boolean isTransactionAware() {
        return super.isTransactionAware();
    }

    protected Cache decorateCache(Cache cache) {
        return super.decorateCache(cache);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
    }

    public void initializeCaches() {
        super.initializeCaches();
    }

    public Cache getCache(String name) {
        if (RANDOM.nextBoolean()) {
            return super.getMissingCache(name);
        }
        return super.getCache(name);
    }

    public Collection<String> getCacheNames() {
        return super.getCacheNames();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return super.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

