/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.interceptor;

import com.chinamcloud.bigdata.tenant.Utils.FrameRequest;
import com.chinamcloud.bigdata.tenant.bean.Exception.CustomException;
import com.chinamcloud.bigdata.tenant.bean.parameter.LoginAuthParameter;
import com.chinamcloud.bigdata.tenant.bean.parameter.UserInfoByTokenParameter;
import com.chinamcloud.bigdata.tenant.bean.result.LoginData;
import com.chinamcloud.bigdata.tenant.config.AbstractAuthProvider;
import com.chinamcloud.bigdata.tenant.config.AuthProvider;
import com.chinamcloud.bigdata.tenant.service.Tenant;
import com.chinamcloud.haihe.backStageManagement.mapper.UserMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.User;
import com.chinamcloud.haihe.common.annotation.PassToken;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.cache.RedisUtil;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginInterceptor
implements HandlerInterceptor {
    private UserMapper userMapper;
    private RedisUtil redisUtil;
    private final Logger logger = LoggerFactory.getLogger(LoginInterceptor.class);

    public LoginInterceptor() {
    }

    public LoginInterceptor(UserMapper userMapper, RedisUtil redisUtil) {
        this.userMapper = userMapper;
        this.redisUtil = redisUtil;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        PassToken passToken;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        request.setAttribute("user_token", null);
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        if (method.isAnnotationPresent(PassToken.class) && (passToken = method.getAnnotation(PassToken.class)).required()) {
            return true;
        }
        String user_token = request.getParameter("user_token");
        String group_id = request.getParameter("access_token");
        if (StringUtils.isBlank((CharSequence)user_token)) {
            user_token = request.getParameter("user_token");
        }
        if (StringUtils.isBlank((CharSequence)group_id)) {
            group_id = request.getParameter("group_id");
        }
        if (StringUtils.isNotBlank((CharSequence)user_token)) {
            if ("default".equalsIgnoreCase(user_token)) {
                request.setAttribute("user_token", (Object)"default");
                this.logger.info("token=default");
                return true;
            }
            User user = this.userMapper.selectByUserToken(user_token);
            if (user == null) {
                LoginData userInfoByToken = this.redisUtil.getObj(user_token + "getUserInfoByToken", LoginData.class);
                if (userInfoByToken == null) {
                    UserInfoByTokenParameter groupInfoParameter = new UserInfoByTokenParameter();
                    groupInfoParameter.setUserToken(user_token);
                    Tenant tenant = new Tenant(FrameRequest.defaultInstance());
                    try {
                        userInfoByToken = tenant.getUserInfoByToken(groupInfoParameter);
                    }
                    catch (Exception e) {
                        response.setCharacterEncoding("utf-8");
                        response.setContentType("application/json;charset=UTF-8");
                        response.getWriter().write(e.getMessage());
                        return false;
                    }
                    if (userInfoByToken == null) {
                        response.getWriter().write("params_error");
                        return false;
                    }
                    this.redisUtil.saveObj(userInfoByToken, 86400, user_token + "getUserInfoByToken");
                }
                try {
                    this.userMapper.insertSelective(new User(userInfoByToken));
                }
                catch (Exception e) {
                    this.logger.error("\u7528\u6237\u6dfb\u52a0\u6570\u636e\u5e93\u5931\u8d25\uff1a " + userInfoByToken.getUser_info().getUser_token());
                }
                request.setAttribute("user_token", (Object)userInfoByToken.getUser_info().getUser_token());
            } else {
                request.setAttribute("user_token", (Object)user.getUserToken());
            }
            this.logger.info("token=" + request.getAttribute("user_token"));
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)group_id)) {
            List<User> users = this.userMapper.selectByGroupId(group_id);
            if (users == null || users.isEmpty()) {
                return false;
            }
            request.setAttribute("groupId", (Object)group_id);
            this.logger.info("groupId=" + group_id);
            return true;
        }
        if (method.isAnnotationPresent(UserLoginToken.class)) {
            String token = "";
            String groupId = "";
            Cookie[] cookies = request.getCookies();
            if (cookies == null) {
                this.logger.error("cookies is empty");
                throw new com.chinamcloud.haihe.common.Exception.CustomException("login_time_out");
            }
            String id = "";
            String tId = "";
            for (Cookie cookie : cookies) {
                if ("login_chinamcloud_id".equals(cookie.getName())) {
                    id = cookie.getValue();
                }
                if ("login_chinamcloud_tid".equals(cookie.getName())) {
                    tId = cookie.getValue();
                }
                if ("login_cmc_id".equals(cookie.getName())) {
                    id = cookie.getValue();
                }
                if (!"login_cmc_tid".equals(cookie.getName())) continue;
                tId = cookie.getValue();
            }
            LoginData loginAuth = this.redisUtil.getObj(id + tId + "getLoginAuth", LoginData.class);
            if (loginAuth == null) {
                LoginAuthParameter loginAuthParameter = new LoginAuthParameter();
                if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)tId)) {
                    this.logger.error("id or tId is empty");
                    throw new com.chinamcloud.haihe.common.Exception.CustomException("login_time_out");
                }
                loginAuthParameter.setLogin_id(id);
                loginAuthParameter.setLogin_tid(tId);
                loginAuthParameter.setAuth_key("");
                Tenant tenant = new Tenant(FrameRequest.defaultInstance());
                try {
                    loginAuth = tenant.getLoginAuth(loginAuthParameter);
                }
                catch (Exception e) {
                    throw new com.chinamcloud.haihe.common.Exception.CustomException(e.getMessage());
                }
                if (null == loginAuth) {
                    this.logger.error("loginAuth is empty");
                    throw new com.chinamcloud.haihe.common.Exception.CustomException("login_time_out");
                }
                this.redisUtil.saveObj(loginAuth, 600, id + tId + "getLoginAuth");
            }
            token = loginAuth.getUser_token();
            groupId = loginAuth.getGroup_info().getGroup_id();
            if (StringUtils.isEmpty((CharSequence)token)) {
                this.logger.error("Token in loginAuth is empty");
                throw new com.chinamcloud.haihe.common.Exception.CustomException("params_error");
            }
            User user = this.userMapper.selectByUserToken(token);
            if (user == null) {
                try {
                    this.userMapper.insertSelective(new User(loginAuth));
                }
                catch (Exception e) {
                    this.logger.error("\u7528\u6237\u6dfb\u52a0\u6570\u636e\u5e93\u5931\u8d25\uff1a " + token);
                }
            }
            request.setAttribute("user_token", (Object)token);
            request.setAttribute("groupId", (Object)groupId);
            this.logger.info("token=" + token);
            return true;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        System.out.println("---postHandle---");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        System.out.println("---afterCompletion---");
    }

    public static void main02() throws CustomException {
        String id = "0d9beb1f2201ed5115014c406e19f81d";
        String tId = "52fb59f9cd36d7c966a9ca5c86800e86";
        LoginData loginAuth = null;
        if (loginAuth == null) {
            LoginAuthParameter loginAuthParameter = new LoginAuthParameter();
            if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)tId)) {
                throw new com.chinamcloud.haihe.common.Exception.CustomException("login_time_out");
            }
            loginAuthParameter.setLogin_id(id);
            loginAuthParameter.setLogin_tid(tId);
            loginAuthParameter.setAuth_key("");
            Tenant tenant = new Tenant(FrameRequest.defaultInstance());
            try {
                loginAuth = tenant.getLoginAuth(loginAuthParameter);
            }
            catch (Exception e) {
                throw new com.chinamcloud.haihe.common.Exception.CustomException(e.getMessage());
            }
            if (null == loginAuth) {
                throw new com.chinamcloud.haihe.common.Exception.CustomException("login_time_out");
            }
        }
        String token = loginAuth.getUser_token();
        String group_code = loginAuth.getGroup_info().getGroup_id();
        System.out.println(token);
        System.out.println(group_code);
    }

    public static void main01() throws CustomException {
        String id = "e94fe0531fa8f07eb03ad510c91c76f5";
        String tId = "7029c3d064db71c799aee75177e2bbd0";
        LoginData loginAuth = null;
        if (loginAuth == null) {
            LoginAuthParameter loginAuthParameter = new LoginAuthParameter();
            if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)tId)) {
                throw new com.chinamcloud.haihe.common.Exception.CustomException("login_time_out");
            }
            loginAuthParameter.setLogin_id(id);
            loginAuthParameter.setLogin_tid(tId);
            loginAuthParameter.setAuth_key("");
            AuthProvider authProvider = new AuthProvider();
            authProvider.setAccessKeyId("KPm67hoIZUdOHlC8");
            authProvider.setAccessKeySecret("WAlpzgydwYvZx2jCOu6qRhbkINMBm4Ge");
            authProvider.setServiceKey("csa");
            authProvider.setHost("https://api.chinamcloud.com/");
            Tenant tenant = new Tenant(FrameRequest.newInstance((AbstractAuthProvider)authProvider));
            try {
                loginAuth = tenant.getLoginAuth(loginAuthParameter);
            }
            catch (Exception e) {
                throw new com.chinamcloud.haihe.common.Exception.CustomException(e.getMessage());
            }
            if (null == loginAuth) {
                throw new com.chinamcloud.haihe.common.Exception.CustomException("login_time_out");
            }
        }
        String token = loginAuth.getUser_token();
        System.out.println(token);
    }

    public static void main(String[] args) throws CustomException {
        LoginInterceptor.main02();
    }
}

