/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.processor;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.backStageManagement.mapper.HaiheConfigMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.CrawlerOperation;
import com.chinamcloud.haihe.backStageManagement.pojo.HaiheConfig;
import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteInc;
import com.chinamcloud.haihe.common.spider.pojo.XiguaArticle;
import com.chinamcloud.haihe.common.spider.pojo.XiguaQueryArticleResult;
import com.chinamcloud.haihe.common.spider.processor.BaseProcessor;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeiXinProcessor
implements BaseProcessor {
    private static final Logger log = LogManager.getLogger(WeiXinProcessor.class);
    private static final String apiUserId = "290903";
    private static final String apiSecretKey = "3f8357eb-0b06-4b91-bceb-80a9d2ae96e6";
    private static final String apiUrl = "http://openapi.xiguaji.com/v3/Article/PullIncrement";
    private static final long serialVersionUID = -6489598562875551691L;
    @Autowired
    private HaiheConfigMapper haiheConfigDao;

    public static String md5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u6ca1\u6709md5\u8fd9\u4e2a\u7b97\u6cd5\uff01");
        }
        StringBuilder md5code = new StringBuilder(new BigInteger(1, secretBytes).toString(16));
        int len = md5code.length();
        for (int i = 0; i < 32 - len; ++i) {
            md5code.insert(0, "0");
        }
        return md5code.toString();
    }

    public static String GenCheckSum(String body, String secretkey) {
        String s = body + secretkey;
        String sign = WeiXinProcessor.md5(s);
        sign = sign.substring(14, 18);
        return sign.toLowerCase();
    }

    @Override
    public List<String> getListUrl(SiteInc siteInc, Site dbSite, String url, String charset, String detailsUrl) {
        return null;
    }

    @Override
    public CrawlerOperation crawlNew(List<String> newsList, SiteInc siteInc) {
        long beginTime = System.currentTimeMillis();
        String bizId = siteInc.getUrl();
        String weiXinName = siteInc.getUrl();
        final HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("url", bizId);
        map.put("msg", "");
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(){
            private static final long serialVersionUID = 4161538819591403957L;
            {
                this.add(map);
            }
        };
        HaiheConfig haiheConfig = this.haiheConfigDao.selectByPrimaryKey("LastSubscriptionID");
        String lastSubscriptionID = haiheConfig.getVal();
        log.info("\u4e0a\u6b21\u8ba2\u9605\u7684ID: {}", (Object)lastSubscriptionID);
        String params = "{\"LastSubscriptionID\":" + lastSubscriptionID + "}";
        String checksum = WeiXinProcessor.GenCheckSum(params, apiSecretKey);
        log.info("\u897f\u74dc\u8bf7\u6c42params: {}", (Object)params);
        log.info("\u897f\u74dc\u8bf7\u6c42checksum: {}", (Object)checksum);
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("userid", apiUserId);
            connection.setRequestProperty("checksum", checksum);
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
            out.append(params);
            out.flush();
            out.close();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            String res = "";
            while ((line = reader.readLine()) != null) {
                res = res + line;
            }
            log.info("\u83b7\u53d6\u897f\u74dc\u8fd4\u56de\u7ed3\u679c: {}", (Object)res);
            reader.close();
            Gson gson = new Gson();
            ArrayList<XiguaArticle> list = new ArrayList<XiguaArticle>(16);
            XiguaQueryArticleResult result = (XiguaQueryArticleResult)gson.fromJson(res, XiguaQueryArticleResult.class);
            result.getList().forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)weiXinName)) {
                    if (x.getWechatId().equalsIgnoreCase(weiXinName)) {
                        list.add((XiguaArticle)x);
                    }
                } else {
                    list.add((XiguaArticle)x);
                }
            });
            if (list.isEmpty()) {
                list.addAll(result.getList());
            }
            if (result.getResultCode() == 1) {
                this.haiheConfigDao.updateByPrimaryKeySelective(new HaiheConfig("LastSubscriptionID", result.getLastSubscriptionID(), null));
                map.put("WeiXin", list);
                return new CrawlerOperation(siteInc.getSiteId(), new Date(beginTime), System.currentTimeMillis() - beginTime, 1, 0, maps, JSON.toJSONString((Object)maps), 4);
            }
            map.put("msg", "\u722c\u53d6\u5931\u8d25");
            return new CrawlerOperation(siteInc.getSiteId(), new Date(beginTime), System.currentTimeMillis() - beginTime, 1, 1, maps, JSON.toJSONString((Object)maps), 4);
        }
        catch (IOException e) {
            e.printStackTrace();
            map.put("msg", "\u722c\u53d6\u5931\u8d25");
            return new CrawlerOperation(siteInc.getSiteId(), new Date(beginTime), System.currentTimeMillis() - beginTime, 1, 1, maps, JSON.toJSONString((Object)maps), 4);
        }
    }
}

