/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import com.chinamcloud.haihe.common.pojo.Tree;
import com.chinamcloud.haihe.common.utils.AbstractTreeBuildFactory;
import java.util.ArrayList;
import java.util.List;

public class DefaultTreeBuildFactory<T extends Tree>
extends AbstractTreeBuildFactory<T> {
    private String rootParentId = "-1";
    private static Long CACHE_TIME = 600000L;

    public String getRootParentId() {
        return this.rootParentId;
    }

    public void setRootParentId(String rootParentId) {
        this.rootParentId = rootParentId;
    }

    public static Long getCacheTime() {
        return CACHE_TIME;
    }

    public static void setCacheTime(Long cacheTime) {
        CACHE_TIME = cacheTime;
    }

    private void buildChildNodes(List<T> totalNodes, T node, List<T> childNodeLists) {
        if (totalNodes == null || node == null) {
            return;
        }
        List<T> nodeSubLists = this.getSubChildsLevelOne(totalNodes, node);
        if (nodeSubLists.size() != 0) {
            for (Tree nodeSubList : nodeSubLists) {
                this.buildChildNodes(totalNodes, nodeSubList, new ArrayList(16));
            }
        }
        childNodeLists.addAll(nodeSubLists);
        ((Tree)node).setChildrenNodes(childNodeLists);
        try {
            int value = new Double(Math.ceil(childNodeLists.stream().mapToDouble(Tree::getChildrenNum).sum())).intValue();
            if (value == 0) {
                value = childNodeLists.size();
            }
            ((Tree)node).setChildrenNum(value);
        }
        catch (Exception e) {
            ((Tree)node).setChildrenNum(childNodeLists.size());
        }
    }

    private List<T> getSubChildsLevelOne(List<T> list, T node) {
        ArrayList<Tree> nodeList = new ArrayList<Tree>(16);
        for (Tree nodeItem : list) {
            if (!nodeItem.getNodeParentId().equals(((Tree)node).getNodeId())) continue;
            nodeList.add(nodeItem);
        }
        return nodeList;
    }

    @Override
    protected List<T> beforeBuild(List<T> nodes) {
        return nodes;
    }

    @Override
    protected List<T> executeBuilding(List<T> nodes) {
        for (Tree treeNode : nodes) {
            if (!this.rootParentId.equals(treeNode.getNodeParentId())) continue;
            this.buildChildNodes(nodes, treeNode, new ArrayList(16));
        }
        return nodes;
    }

    @Override
    protected List<T> afterBuild(List<T> nodes) {
        ArrayList<Tree> results = new ArrayList<Tree>(16);
        for (Tree node : nodes) {
            if (!node.getNodeParentId().equals(this.rootParentId)) continue;
            results.add(node);
        }
        return results;
    }
}

