/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.configService.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.configService.entity.DataConfig;
import com.chinamcloud.haihe.configService.mapper.DataConfigMapper;
import com.chinamcloud.haihe.configService.mapper.GroupDataConfigMapper;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupDataConfigService {
    private static final Logger log = LogManager.getLogger(GroupDataConfigService.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private GroupDataConfigMapper groupDataConfigMapper;
    @Autowired
    private DataConfigMapper dataconfigMapper;

    public Object getDataConfig(String tenantId, String dpCode, String dpId) {
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)dpCode) || StringUtils.isBlank((CharSequence)dpId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        DataConfig dataConfig = this.selectByPrimaryKey(tenantId, dpCode, dpId);
        if (dataConfig == null || StringUtils.isBlank((CharSequence)dataConfig.getData())) {
            dataConfig = this.selectByPrimaryKey(tenantId, "group", dpId);
            if (dataConfig == null || StringUtils.isBlank((CharSequence)dataConfig.getData())) {
                log.error("get_data_failed");
                return CodeResult.failedResultByMsgSource("get_data_failed");
            }
            dataConfig.setData(dataConfig.getData().replaceAll("group", dpCode));
        }
        return new CodeResult<Object>(CodeResult.Code.Success, JSON.parse((String)dataConfig.getData()));
    }

    private DataConfig selectByPrimaryKey(String tenantId, String dpCode, String dpId) {
        DataConfig selectByPrimaryKey = this.groupDataConfigMapper.selectByPrimaryKey(tenantId, dpCode, dpId);
        if (selectByPrimaryKey == null) {
            selectByPrimaryKey = this.dataconfigMapper.selectByPrimaryKey("default", dpCode, "1");
        }
        return selectByPrimaryKey;
    }

    public Object updateConfig(String tenantId, String dpCode, String dpId, String code, String name, String type, String oldCode, String data) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)type)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Long codeInt = Long.parseLong(code);
        Object obj = this.getDataConfig(tenantId, dpCode, dpId);
        CodeResult codeResult = (CodeResult)obj;
        if (CodeResult.Code.Success.getCodeValue() != codeResult.getCode()) {
            return obj;
        }
        String resultMsg = "success";
        try {
            Object result = codeResult.getResult();
            DocumentContext document = JsonPath.parse(result);
            JsonPath jsonPath_List = JsonPath.compile((String)GroupDataConfigService.getCodePath(dpCode, codeInt.toString()), (Predicate[])new Predicate[0]);
            List read = null;
            switch (type) {
                case "delete": {
                    document.delete(jsonPath_List);
                    break;
                }
                case "replace": {
                    if (StringUtils.isNotBlank((CharSequence)oldCode)) {
                        document.delete(JsonPath.compile((String)GroupDataConfigService.getCodePath(dpCode, oldCode), (Predicate[])new Predicate[0]));
                    }
                }
                case "add": {
                    read = (List)document.read(jsonPath_List);
                    if (read == null || read.size() == 0) {
                        JSONObject json = new JSONObject();
                        json.put("code", (Object)codeInt);
                        json.put("name", (Object)name);
                        if (StringUtils.isNotBlank((CharSequence)data)) {
                            json.put("data", (Object)data);
                        }
                        document.add(JsonPath.compile((String)("$." + dpCode), (Predicate[])new Predicate[0]), (Object)json);
                        break;
                    }
                    JsonPath jsonPath_update = JsonPath.compile((String)(GroupDataConfigService.getCodePath(dpCode, codeInt.toString()) + ".name"), (Predicate[])new Predicate[0]);
                    if (StringUtils.isNotBlank((CharSequence)data)) {
                        document.put(GroupDataConfigService.getCodePath(dpCode, codeInt.toString()), "data", (Object)data, new Predicate[0]);
                    }
                    document.set(jsonPath_update, (Object)name);
                    resultMsg = "config is exists , overwrite data !";
                    break;
                }
                default: {
                    read = (List)document.read(jsonPath_List);
                    if (read == null || read.size() == 0) {
                        resultMsg = "config is not exists !";
                        break;
                    }
                    JsonPath jsonPath_update = JsonPath.compile((String)(GroupDataConfigService.getCodePath(dpCode, codeInt.toString()) + ".name"), (Predicate[])new Predicate[0]);
                    document.set(jsonPath_update, (Object)name);
                }
            }
            DataConfig dataConfig = new DataConfig();
            dataConfig.setId(dpId);
            dataConfig.setTenantId(tenantId);
            dataConfig.setCode(dpCode);
            dataConfig.setData(JSON.toJSONString(result));
            DataConfig selectByPrimaryKey = this.groupDataConfigMapper.selectByPrimaryKey(tenantId, dpCode, dpId);
            if (selectByPrimaryKey == null || StringUtils.isBlank((CharSequence)selectByPrimaryKey.getTenantId())) {
                this.groupDataConfigMapper.insert(dataConfig);
            } else {
                this.groupDataConfigMapper.updateConfig(dataConfig);
            }
        }
        catch (Exception e) {
            log.error("update_failedmsg:{}", (Object)e.getMessage());
            return CodeResult.failedResult("update config msg fail, msg :" + e.getMessage());
        }
        return new CodeResult(CodeResult.Code.Success, resultMsg);
    }

    public static String getCodePath(String dpCode, String codeInt) {
        return "$." + dpCode + "[?(@.code == " + codeInt + ")]";
    }

    public static String getNamePath(String dpCode, String name) {
        return "$." + dpCode + "[?(@.name == '" + name + "')]";
    }

    public static void setJsonPointerValue(ObjectNode node, JsonPointer pointer, JsonNode value) {
        JsonPointer parentPointer = pointer.head();
        JsonNode parentNode = node.at(parentPointer);
        String fieldName = pointer.last().toString().substring(1);
        if (parentNode.isMissingNode() || parentNode.isNull()) {
            parentNode = StringUtils.isNumeric((CharSequence)fieldName) ? mapper.createArrayNode() : mapper.createObjectNode();
            GroupDataConfigService.setJsonPointerValue(node, parentPointer, parentNode);
        }
        if (parentNode.isArray()) {
            assert (parentNode instanceof ArrayNode);
            ArrayNode arrayNode = (ArrayNode)parentNode;
            int index = Integer.parseInt(fieldName);
            for (int i = arrayNode.size(); i <= index; ++i) {
                arrayNode.addNull();
            }
            arrayNode.set(index, value);
        } else if (parentNode.isObject()) {
            ((ObjectNode)parentNode).set(fieldName, value);
        } else {
            throw new IllegalArgumentException("`" + fieldName + "` can't be set for parent node `" + parentPointer + "` because parent is not a container but " + parentNode.getNodeType().name());
        }
    }

    public static void main(String[] args) {
        String json = "{\n  \"can delete\": \"this\",\n  \"can't delete\": \"this\"\n}";
        ObjectNode objectNode = mapper.createObjectNode();
        DocumentContext context = JsonPath.parse((String)json);
        context.set("$.['can delete']", null, new Predicate[0]);
        context.set("$.['can\\'t delete']", null, new Predicate[0]);
        context.set(JsonPath.compile((String)"$.['can\\'t delete123']", (Predicate[])new Predicate[0]), (Object)"John");
        System.out.println(context.jsonString());
    }
}

