/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.agg;

import com.chinamcloud.haihe.es.agg.IEsBuildAgg;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;

public class EsFactAggWithEmotionTendency
implements IEsBuildAgg {
    private static final List<String> list = new ArrayList<String>();

    @Override
    public List<AggregationBuilder> buildAgg(EsFeedbackQuery query) {
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>(4);
        String field = query.getFacetField();
        String againFacetField = query.getAgainFacetField();
        Integer facetLimit = query.getFacetLimit();
        Integer facetMincount = query.getFacetMincount();
        TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(field)).size(facetLimit.intValue()).minDocCount((long)facetMincount.intValue());
        if (StringUtils.isNotBlank((CharSequence)againFacetField)) {
            aggs.add((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg1").field(againFacetField)).size(1)));
            return aggs;
        }
        if ("2".equals(query.getIndexName()) || !list.contains(field)) {
            aggs.add((AggregationBuilder)termsAggregationBuilder);
            return aggs;
        }
        String indexRegex = "[\u4e00-\u9fa5]{2,3}";
        aggs.add((AggregationBuilder)termsAggregationBuilder.includeExclude(new IncludeExclude(indexRegex, null)));
        return aggs;
    }

    static {
        list.add("summary_keywords");
    }
}

