/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.agg;

import com.chinamcloud.haihe.es.agg.IEsBuildAgg;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.pojo.EsBuildSort;
import com.chinamcloud.haihe.es.pojo.EsBuilderPos;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class EsHotTopicAgg
implements IEsBuildAgg {
    private SortOrder sortOrder = SortOrder.ASC;
    private List<String> list;

    public EsHotTopicAgg() {
    }

    public EsHotTopicAgg(List<String> list) {
        this.list = list;
    }

    public EsHotTopicAgg(SortOrder sortOrder, List<String> list) {
        this.sortOrder = sortOrder;
        this.list = list;
    }

    @Override
    public List<AggregationBuilder> buildAgg(EsFeedbackQuery query) {
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        String field = query.getFacetField();
        Integer facetLimit = query.getFacetLimit();
        Integer facetMincount = query.getFacetMincount();
        FieldSortBuilder facetSort = EsBuildSort.getFacetSort(query);
        int size = EsBuilderPos.getFacetPos(query);
        TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(field)).size(facetLimit.intValue()).minDocCount((long)facetMincount.intValue());
        if (facetSort.getFieldName().equals("emotionScore")) {
            if (SortOrder.DESC == facetSort.order()) {
                termsAggregationBuilder.order(Terms.Order.aggregation((String)"avg_emotionScore", (boolean)false));
            } else {
                termsAggregationBuilder.order(Terms.Order.aggregation((String)"avg_emotionScore", (boolean)true));
            }
        } else if (facetSort.getFieldName().equals("pubTime")) {
            termsAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"newest_pubime").field("pubTime"));
            if (SortOrder.DESC == facetSort.order()) {
                termsAggregationBuilder.order(Terms.Order.aggregation((String)"newest_pubime", (boolean)false));
            } else {
                termsAggregationBuilder.order(Terms.Order.aggregation((String)"newest_pubime", (boolean)true));
            }
        } else if (facetSort.getFieldName().equals("doc_count")) {
            // empty if block
        }
        termsAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_emotionScore").field("emotionScore"));
        termsAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"agg1").sort("pubTime", this.sortOrder).size(1));
        if (this.list != null && !this.list.isEmpty() && this.list.contains("hot")) {
            termsAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.terms((String)"agg2").field("source"));
        }
        aggs.add((AggregationBuilder)termsAggregationBuilder);
        return aggs;
    }
}

