/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.config;

import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsConfig {
    private static final Logger log = LogManager.getLogger(EsConfig.class);
    private static final String CONF_PATH = "config/es.properties";
    private final String esHost;
    private final int esPort;
    private final String clusterName;
    private final String indexName;
    private final String indexName2;
    private final String typeName;
    private final String typeName2;
    private final String userPwd;

    public EsConfig() {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(Objects.requireNonNull(EsConfig.class.getClassLoader().getResourceAsStream(CONF_PATH)), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
            System.exit(0);
        }
        this.esHost = properties.getProperty("es_host");
        this.esPort = Integer.parseInt(properties.getProperty("es_port"));
        this.clusterName = properties.getProperty("cluster_name");
        this.indexName = properties.getProperty("index_name");
        this.indexName2 = properties.getProperty("index_name2");
        this.typeName = properties.getProperty("type_name");
        this.typeName2 = properties.getProperty("type_name2");
        this.userPwd = properties.getProperty("user_pwd");
    }

    public static EsConfig getConf() {
        return Holder.INSTANCE;
    }

    public String getEsHost() {
        return this.esHost;
    }

    public int getEsPort() {
        return this.esPort;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexName2() {
        return this.indexName2;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeName2() {
        return this.typeName2;
    }

    public String getUserPwd() {
        return this.userPwd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsConfig)) {
            return false;
        }
        EsConfig other = (EsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$esHost = this.getEsHost();
        String other$esHost = other.getEsHost();
        if (this$esHost == null ? other$esHost != null : !this$esHost.equals(other$esHost)) {
            return false;
        }
        if (this.getEsPort() != other.getEsPort()) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$indexName2 = this.getIndexName2();
        String other$indexName2 = other.getIndexName2();
        if (this$indexName2 == null ? other$indexName2 != null : !this$indexName2.equals(other$indexName2)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$typeName2 = this.getTypeName2();
        String other$typeName2 = other.getTypeName2();
        if (this$typeName2 == null ? other$typeName2 != null : !this$typeName2.equals(other$typeName2)) {
            return false;
        }
        String this$userPwd = this.getUserPwd();
        String other$userPwd = other.getUserPwd();
        return !(this$userPwd == null ? other$userPwd != null : !this$userPwd.equals(other$userPwd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $esHost = this.getEsHost();
        result = result * 59 + ($esHost == null ? 43 : $esHost.hashCode());
        result = result * 59 + this.getEsPort();
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $indexName2 = this.getIndexName2();
        result = result * 59 + ($indexName2 == null ? 43 : $indexName2.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $typeName2 = this.getTypeName2();
        result = result * 59 + ($typeName2 == null ? 43 : $typeName2.hashCode());
        String $userPwd = this.getUserPwd();
        result = result * 59 + ($userPwd == null ? 43 : $userPwd.hashCode());
        return result;
    }

    public String toString() {
        return "EsConfig(esHost=" + this.getEsHost() + ", esPort=" + this.getEsPort() + ", clusterName=" + this.getClusterName() + ", indexName=" + this.getIndexName() + ", indexName2=" + this.getIndexName2() + ", typeName=" + this.getTypeName() + ", typeName2=" + this.getTypeName2() + ", userPwd=" + this.getUserPwd() + ")";
    }

    private static class Holder {
        static EsConfig INSTANCE = new EsConfig();

        private Holder() {
        }
    }
}

