/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.factory;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.cache.RedisUtil;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.es.factory.EsNewsCache;
import com.google.gson.Gson;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class EsNewsCacheDecoratorPattern {
    private static final Logger log = LogManager.getLogger(EsNewsCacheDecoratorPattern.class);
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static final Gson gson = new Gson();
    private final RedisUtil redisUtil;

    @Autowired
    public EsNewsCacheDecoratorPattern(ThreadPoolTaskExecutor threadPoolTaskExecutor, RedisUtil redisUtil) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.redisUtil = redisUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeResult execute(String method, HotParams params, EsNewsCache esNewsCache) {
        Date fromDt = params.getFromDt();
        Date toDt = params.getToDt();
        Date fromCrawlerDt = params.getFromCrawlerDt();
        Date toCrawlerDt = params.getToCrawlerDt();
        params.setFromDt(DateUtils.getYMD(fromDt));
        params.setToDt(DateUtils.getYMD(toDt));
        params.setFromCrawlerDt(DateUtils.getYMD(fromCrawlerDt));
        params.setToCrawlerDt(DateUtils.getYMD(toCrawlerDt));
        String key = method + gson.toJson((Object)params).replaceAll(":", "|@|");
        log.info(key);
        CodeResult obj = this.redisUtil.getObj(key, CodeResult.class);
        if (obj != null) {
            EsNewsCacheDecoratorPattern esNewsCacheDecoratorPattern = this;
            synchronized (esNewsCacheDecoratorPattern) {
                CodeResult obj_temp = this.redisUtil.getObj(key + "temp", CodeResult.class);
                if (obj_temp == null) {
                    this.threadPoolTaskExecutor.execute(() -> {
                        CodeResult func = esNewsCache.func();
                        if (func != null && func.getCode() != 1) {
                            Object result = func.getResult();
                            if (result == null) {
                                return;
                            }
                            if (result instanceof List && ((List)result).isEmpty()) {
                                return;
                            }
                            this.redisUtil.saveObj(func, 86400, key);
                        }
                    });
                    this.redisUtil.saveObj(new CodeResult(), 600, key + "temp");
                }
                return obj;
            }
        }
        CodeResult func = esNewsCache.func();
        if (func != null && func.getCode() != 1) {
            Object result = func.getResult();
            if (result == null) {
                return func;
            }
            if (result instanceof List && ((List)result).isEmpty()) {
                return func;
            }
            this.redisUtil.saveObj(func, 86400, key);
        }
        return func;
    }
}

