/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.parser;

import com.chinamcloud.haihe.common.bean.Trend;
import com.chinamcloud.haihe.es.bean.EventStatisticResult;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.parser.BaseParser;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import java.util.List;
import java.util.Map;

public class TotalScaleParser
implements BaseParser<EventStatisticResult, EsFacetResult<HotEventStatistic>> {
    @Override
    public EventStatisticResult parseRecords(EsFacetResult<HotEventStatistic> esResult) {
        EventStatisticResult eventStatisticResult = new EventStatisticResult();
        HotEventStatistic result = (HotEventStatistic)esResult.getResult();
        List<Trend<Long>> topic_count = result.getTopic_count();
        List<Trend<Long>> media_cover = result.getMedia_cover();
        List<Trend<Double>> emotion_value = result.getEmotion_value();
        List<Trend<Long>> doc_count = result.getDoc_count();
        List<Trend<Map<String, Long>>> source_value = result.getSource_value();
        if (topic_count != null && !topic_count.isEmpty()) {
            eventStatisticResult.setTopicTotal(topic_count.get(0).getValue());
        }
        if (media_cover != null && !media_cover.isEmpty()) {
            eventStatisticResult.setMediaCoverTotal(media_cover.get(0).getValue());
        }
        if (emotion_value != null && !emotion_value.isEmpty()) {
            eventStatisticResult.setEmotionAvg(emotion_value.get(0).getValue());
        }
        if (doc_count != null && !doc_count.isEmpty()) {
            eventStatisticResult.setDocTotal(doc_count.get(0).getValue());
            eventStatisticResult.setTodayDoc(doc_count.get(0).getValue());
        }
        if (source_value == null || !source_value.isEmpty()) {
            // empty if block
        }
        return eventStatisticResult;
    }
}

