/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.processor;

import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.processor.IEsFeedbackQueryProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class ParamsEsFeedBackQueryProcessor
implements IEsFeedbackQueryProcessor {
    private static final Map<String, String> sortFieldsMaping = new HashMap<String, String>(4);
    private static final Map<String, String> facetFieldMapping;
    private static final Map<String, String> sourceMapping;
    private static final Map<String, String> fieldMapping;
    private EsFeedbackQuery feedbackQuery;
    private final HotParams params;

    public ParamsEsFeedBackQueryProcessor(HotParams params) {
        this.params = params;
    }

    protected void setParams() {
        this.setDt().setCrawlerDt().setPageIndex().setPageSize().setSortFields().setFacetFields().setEmotionTendency().setSummaryKeyWords().setClusterId().setDescription().setNoDescription().setSourceIds().setCluster().setDocId().setTbNickName().setFacetLimit().setFacetMincount().setSource().setSubject().setNoSubject().setEmotionUpper().setEmotionLower().setEmptyField().setRefererUrl().setNonEmptyField().setIndexName().setEntityList().setLayoutIndex().setCity().setLevel().setClassify().setPIdS().setWordsNum().setIsOriginal().setAgainFacetField().setProvince().setMunicipality().setPrefecture().setOrganizationEntity().setPersonEntity().setRegionEntity().setSummaryPhrase().setTitleEntity();
    }

    protected ParamsEsFeedBackQueryProcessor setDt() {
        String day;
        Date fromDt = this.params.getFromDt();
        Date toDt = this.params.getToDt();
        if (fromDt == null && toDt == null && !StringUtils.isEmpty((CharSequence)(day = this.params.getDay()))) {
            Date[] dates = null;
            try {
                dates = DateUtils.computeDatesBackward(Integer.parseInt(day), false);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
            fromDt = dates[0];
            toDt = dates[1];
        }
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        if (!DateUtils.isDateAfter(fromDt, toDt)) {
            throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
        }
        if (fromDt != null) {
            this.feedbackQuery.setPubTimeBegin(fastDateFormat.format(fromDt));
        }
        if (toDt != null) {
            this.feedbackQuery.setPubTimeEnd(fastDateFormat.format(toDt));
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setCrawlerDt() {
        Date fromDt = this.params.getFromCrawlerDt();
        Date toDt = this.params.getToCrawlerDt();
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        if (fromDt != null && toDt != null) {
            if (!DateUtils.isDateAfter(fromDt, toDt)) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
            this.feedbackQuery.setCreatedAtBegin(fastDateFormat.format(fromDt));
            this.feedbackQuery.setCreatedAtEnd(fastDateFormat.format(toDt));
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setPageIndex() {
        this.feedbackQuery.setPageIndex(this.params.getPage());
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEmptyField() {
        String emptyField = this.params.getEmptyField();
        if (StringUtils.isNotBlank((CharSequence)emptyField)) {
            List<String> strings = Arrays.asList(emptyField.split(","));
            ArrayList<String> fields = new ArrayList<String>(strings.size());
            for (String field : strings) {
                String value = fieldMapping.get(field);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                fields.add(value);
            }
            this.feedbackQuery.setEmptyField(fields);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setNonEmptyField() {
        String nonEmptyField = this.params.getNonEmptyField();
        if (StringUtils.isNotBlank((CharSequence)nonEmptyField)) {
            List<String> strings = Arrays.asList(nonEmptyField.split(","));
            ArrayList<String> fields = new ArrayList<String>(strings.size());
            for (String field : strings) {
                String value = fieldMapping.get(field);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                fields.add(value);
            }
            this.feedbackQuery.setNonEmptyField(fields);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setRefererUrl() {
        List<String> refererUrl = this.params.getRefererUrl();
        if (refererUrl != null && !refererUrl.isEmpty()) {
            this.feedbackQuery.setRefererUrl(refererUrl);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setPageSize() {
        int size = Math.min(500, this.params.getSize());
        if (size > 0) {
            this.feedbackQuery.setPageSize(size);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSortFields() {
        List<String> sortFields = this.params.getSortFields();
        ArrayList<String> sortMethod = new ArrayList<String>(16);
        if (sortFields != null && sortFields.size() > 0) {
            for (String field : sortFields) {
                String[] splitFields = field.split(" ");
                String fieldName = "";
                String sortType = "";
                if (splitFields.length > 0 && (fieldName = sortFieldsMaping.get(splitFields[0].trim())) == null) {
                    throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
                }
                if (splitFields.length > 1 && !"desc".equals(sortType = splitFields[1].trim().toLowerCase()) && !"asc".equals(sortType)) {
                    throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
                }
                if (sortType.length() > 0) {
                    sortMethod.add(fieldName + " " + sortType);
                    continue;
                }
                sortMethod.add(fieldName);
            }
        } else {
            sortMethod.add("pubTime desc");
        }
        this.feedbackQuery.setSortingMethods(sortMethod);
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEmotionTendency() {
        String emotionTendency = this.params.getEmotionTendency();
        if (!StringUtils.isEmpty((CharSequence)emotionTendency)) {
            this.feedbackQuery.setEmotionTendency(Integer.valueOf(emotionTendency));
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSummaryKeyWords() {
        List<String> summaryKeyWords = this.params.getSummaryKeywordList();
        if (summaryKeyWords != null && !summaryKeyWords.isEmpty()) {
            this.feedbackQuery.setSummaryKeywords(summaryKeyWords);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setOrganizationEntity() {
        List<String> organizationEntity = this.params.getOrganizationEntity();
        if (organizationEntity != null && !organizationEntity.isEmpty()) {
            this.feedbackQuery.setOrganizationEntity(organizationEntity);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setPersonEntity() {
        List<String> personEntity = this.params.getPersonEntity();
        if (personEntity != null && !personEntity.isEmpty()) {
            this.feedbackQuery.setPersonEntity(personEntity);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setRegionEntity() {
        List<String> regionEntity = this.params.getRegionEntity();
        if (regionEntity != null && !regionEntity.isEmpty()) {
            this.feedbackQuery.setRegionEntity(regionEntity);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSummaryPhrase() {
        List<String> summaryPhrase = this.params.getSummaryPhrase();
        if (summaryPhrase != null && !summaryPhrase.isEmpty()) {
            this.feedbackQuery.setSummaryPhrase(summaryPhrase);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setTitleEntity() {
        List<String> titleEntity = this.params.getTitleEntity();
        if (titleEntity != null && !titleEntity.isEmpty()) {
            this.feedbackQuery.setTitleEntity(titleEntity);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setClusterId() {
        List<Long> clusterIds = this.params.getClusterId();
        if (clusterIds != null && clusterIds.size() > 0) {
            try {
                this.feedbackQuery.setClusterId(clusterIds);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setDescription() {
        String description = this.params.getDescription();
        if (!StringUtils.isEmpty((CharSequence)description)) {
            this.feedbackQuery.setDescription(description);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setNoDescription() {
        String noDescription = this.params.getNoDescription();
        if (StringUtils.isNotBlank((CharSequence)noDescription)) {
            this.feedbackQuery.setNoDescription(noDescription);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSubject() {
        String subject = this.params.getSubject();
        if (subject != null) {
            this.feedbackQuery.setSubject(subject);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setNoSubject() {
        String noSubject = this.params.getNoSubject();
        if (StringUtils.isNotBlank((CharSequence)noSubject)) {
            this.feedbackQuery.setNoSubject(noSubject);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setCluster() {
        if (StringUtils.isNotBlank((CharSequence)this.params.getCluster())) {
            this.feedbackQuery.setCluster(this.params.getCluster());
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setClusteFlag() {
        Integer clusterFlag = this.params.getClusterFlag();
        if (clusterFlag != null) {
            this.feedbackQuery.setClusterFlag(clusterFlag);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setFacetFields() {
        if (!StringUtils.isEmpty((CharSequence)this.params.getFacetField())) {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(facetFieldMapping.get(this.params.getFacetField()));
            this.feedbackQuery.setFacetField(facetFieldMapping.get(this.params.getFacetField()));
            this.feedbackQuery.setFacetFields(fields);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSourceIds() {
        List<String> sourceIds = this.params.getSourceIds();
        if (sourceIds != null) {
            try {
                this.feedbackQuery.setSourceIds(sourceIds.stream().map(Integer::valueOf).collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setDocId() {
        Set<String> ids;
        String docId = this.params.getDocId();
        if (docId != null) {
            this.feedbackQuery.setId(docId);
        }
        if ((ids = this.params.getDocIds()) != null) {
            this.feedbackQuery.setIds(ids);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setTbNickName() {
        List<String> tbNicknames = this.params.getTbNickNames();
        if (tbNicknames != null && tbNicknames.size() > 0) {
            this.feedbackQuery.setTbNicknames(tbNicknames);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setFacetLimit() {
        Integer facetLimit = this.params.getFacetLimit();
        if (facetLimit != null) {
            this.feedbackQuery.setFacetLimit(facetLimit);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setFacetMincount() {
        Integer facetMincount = this.params.getFacetMincount();
        if (facetMincount != null) {
            this.feedbackQuery.setFacetMincount(facetMincount);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setSource() {
        List<String> newsType;
        final HashSet<String> sources = new HashSet<String>();
        String catId = this.params.getCatId();
        if (StringUtils.isNotBlank((CharSequence)catId) && sourceMapping.get(catId) != null) {
            sources.add(sourceMapping.get(catId));
        }
        if ((newsType = this.params.getNewsType()) != null) {
            for (String type : newsType) {
                if (sourceMapping.get(type) == null) continue;
                sources.add(sourceMapping.get(type));
            }
        }
        if (!sources.isEmpty()) {
            this.feedbackQuery.setSources((List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = -3818013033628829625L;
                {
                    this.addAll(sources);
                }
            });
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEmotionUpper() {
        Integer upper = this.params.getEmotionUpper();
        if (upper != null) {
            this.feedbackQuery.setEmotionScoreUpper(upper);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEmotionLower() {
        Integer lower = this.params.getEmotionLower();
        if (lower != null) {
            this.feedbackQuery.setEmotionScoreLower(lower);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setIndexName() {
        String index = this.params.getIndex();
        if (StringUtils.isNotBlank((CharSequence)index)) {
            this.feedbackQuery.setIndexName(index);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setEntityList() {
        List<String> entityList = this.params.getEntityList();
        if (entityList != null && entityList.size() > 0) {
            this.feedbackQuery.setEntityList(entityList);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setLayoutIndex() {
        final List<Integer> layoutIndex = this.params.getLayoutIndex();
        if (layoutIndex != null && !layoutIndex.isEmpty() && layoutIndex.get(0) != null) {
            this.feedbackQuery.setLayoutIndex((List<Integer>)new ArrayList<Integer>(){
                private static final long serialVersionUID = 7038742812374290389L;
                {
                    this.add(layoutIndex.get(0));
                }
            });
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setCity() {
        String city = this.params.getCity();
        if (StringUtils.isNotBlank((CharSequence)city)) {
            this.feedbackQuery.setCity(city);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setLevel() {
        List<String> level = this.params.getLevel();
        if (level != null && !level.isEmpty()) {
            this.feedbackQuery.setLevel(level);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setClassify() {
        List<String> classify = this.params.getClassify();
        if (classify != null && !classify.isEmpty()) {
            this.feedbackQuery.setClassify(classify);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setPIdS() {
        List<String> pids = this.params.getPids();
        if (pids != null && !pids.isEmpty()) {
            this.feedbackQuery.setPids(pids);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setWordsNum() {
        Integer fromWordsNum = this.params.getFromWordsNum();
        Integer toWordNum = this.params.getToWordNum();
        if (fromWordsNum != null && toWordNum != null) {
            this.feedbackQuery.setFromWordsNum(fromWordsNum);
            this.feedbackQuery.setToWordNum(toWordNum);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setIsOriginal() {
        String isOriginal = this.params.getIsOriginal();
        if (StringUtils.isNotBlank((CharSequence)isOriginal)) {
            try {
                int integer = Integer.parseInt(isOriginal);
                if (integer < 0) {
                    isOriginal = "0";
                }
            }
            catch (Exception e) {
                throw new NumberFormatException(MessageSource.getMsg("params_error"));
            }
            this.feedbackQuery.setIsOriginal(isOriginal);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setAgainFacetField() {
        String againFacetField = this.params.getAgainFacetField();
        if (StringUtils.isNotBlank((CharSequence)againFacetField)) {
            this.feedbackQuery.setAgainFacetField(againFacetField);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setProvince() {
        List<String> province = this.params.getProvince();
        if (province != null && !province.isEmpty()) {
            this.feedbackQuery.setProvince(province);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setMunicipality() {
        List<String> municipality = this.params.getMunicipality();
        if (municipality != null && !municipality.isEmpty()) {
            this.feedbackQuery.setMunicipality(municipality);
        }
        return this;
    }

    protected ParamsEsFeedBackQueryProcessor setPrefecture() {
        List<String> prefecture = this.params.getPrefecture();
        if (prefecture != null && !prefecture.isEmpty()) {
            this.feedbackQuery.setPrefecture(prefecture);
        }
        return this;
    }

    @Override
    public void process(EsFeedbackQuery query) throws Exception {
        this.feedbackQuery = query;
        this.setParams();
    }

    static {
        sortFieldsMaping.put("pubTime", "pubTime");
        sortFieldsMaping.put("pointsCount", "pointsCount");
        sortFieldsMaping.put("emotionScore", "emotionScore");
        sortFieldsMaping.put("createdAt", "createdAt");
        sortFieldsMaping.put("doc_count", "doc_count");
        facetFieldMapping = new HashMap<String, String>(15);
        facetFieldMapping.put("monitor_topic_id", "monitorTopicId");
        facetFieldMapping.put("crawler_keywords", "crawlerKeywords");
        facetFieldMapping.put("emotion_tendency", "emotionTendency");
        facetFieldMapping.put("parent_source", "parentSource");
        facetFieldMapping.put("tb_nickname", "tbNickname.keyword");
        facetFieldMapping.put("source_id", "sourceId");
        facetFieldMapping.put("summary_keywords", "summaryKeywordList");
        facetFieldMapping.put("summary_phrase", "summaryPhrase");
        facetFieldMapping.put("spider_topicId", "spiderTopicId");
        facetFieldMapping.put("source", "source");
        facetFieldMapping.put("parentSource", "parentSource");
        facetFieldMapping.put("level", "level");
        facetFieldMapping.put("layout_index", "layoutIndex");
        facetFieldMapping.put("province", "province");
        facetFieldMapping.put("cluster_id", "clusterId");
        facetFieldMapping.put("cluster", "cluster.keyword");
        sourceMapping = new HashMap<String, String>(6);
        sourceMapping.put("1", "News");
        sourceMapping.put("2", "WeiXin");
        sourceMapping.put("3", "Weibo");
        sourceMapping.put("4", "EPAPER");
        sourceMapping.put("5", "App");
        sourceMapping.put("6", "ShiPin");
        fieldMapping = new HashMap<String, String>(12);
        fieldMapping.put("title", "subject.keyword");
        fieldMapping.put("url", "refererUrl");
        fieldMapping.put("reprint", "reprint");
        fieldMapping.put("description", "description");
        fieldMapping.put("subject", "subject.keyword");
        fieldMapping.put("htmlDescription", "htmlDescription");
        fieldMapping.put("summaryKeywordList", "summaryKeywordList");
        fieldMapping.put("parentSource", "parentSource");
        fieldMapping.put("siteName", "siteName");
        fieldMapping.put("picture", "pics");
        fieldMapping.put("video", "videos");
        fieldMapping.put("city", "city");
        fieldMapping.put("province", "province");
        fieldMapping.put("area", "area");
    }

    public static class ConfigMappingNoDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ConfigMappingNoDataException(String message) {
            super(message);
        }
    }
}

