/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.common.bean.NewsInfo;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import com.chinamcloud.haihe.es.utils.ProcessorUtils;
import com.chinamcloud.haihe.es.utils.ToolUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.springframework.util.ObjectUtils;

public class EsHotTopicResultProcessor
implements EsResultProcessor<EsPagedResult<EsSearchResult>> {
    private static final Logger log = LogManager.getLogger(EsHotTopicResultProcessor.class);
    private Integer page;
    private Integer size;

    public EsHotTopicResultProcessor(Integer page, Integer size) {
        this.page = page;
        this.size = size;
    }

    @Override
    public EsPagedResult<EsSearchResult> processResult(EsFeedbackQuery query, SearchResponse response) {
        EsPagedResult<EsSearchResult> facetResult = null;
        ArrayList<NewsInfo> records = new ArrayList<NewsInfo>(16);
        ArrayList<NewsInfo> recordsTemp = new ArrayList<NewsInfo>(16);
        final HashMap<Double, ArrayList<NewsInfo>> listMap = new HashMap<Double, ArrayList<NewsInfo>>(16);
        EsSearchResult esSearchResult = new EsSearchResult();
        try {
            MultiBucketsAggregation agg = (MultiBucketsAggregation)response.getAggregations().get("agg");
            List buckets = agg.getBuckets();
            for (MultiBucketsAggregation.Bucket entry : buckets) {
                Aggregation agg1;
                Aggregations aggregations;
                Object key = entry.getKey();
                if (ObjectUtils.isEmpty((Object)key) || (aggregations = entry.getAggregations()) == null) continue;
                Double hot = null;
                NewsInfo newsInfoTemp = null;
                Aggregation agg2 = aggregations.get("agg2");
                if (agg2 != null) {
                    try {
                        Map<String, Long> stringLongMap = ProcessorUtils.StringTerms(agg2);
                        hot = ToolUtils.HeatCalculation(stringLongMap, (Integer)60);
                    }
                    catch (Exception stringLongMap) {
                        // empty catch block
                    }
                }
                if ((agg1 = aggregations.get("agg1")) != null) {
                    try {
                        SearchHit[] hits;
                        for (SearchHit searchHit : hits = ((InternalTopHits)agg1).getHits().getHits()) {
                            Map source = searchHit.getSource();
                            if (source.isEmpty()) continue;
                            Object o = source.get("keywords");
                            String keywords = null;
                            if (o != null) {
                                keywords = o.toString();
                            }
                            if ("[]".equals(keywords)) {
                                source.put("keywords", "");
                            }
                            try {
                                newsInfoTemp = (NewsInfo)JSON.parseObject((String)JSON.toJSONString((Object)source), NewsInfo.class);
                            }
                            catch (Exception e) {
                                log.error((Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Aggregation avg_emotionScore = aggregations.get("avg_emotionScore");
                if (agg1 != null) {
                    try {
                        Double avg = ProcessorUtils.getAvg(avg_emotionScore);
                        if (newsInfoTemp != null) {
                            newsInfoTemp.setEmotionScore(avg.intValue());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (hot != null && newsInfoTemp != null) {
                    ArrayList<NewsInfo> newsInfos = (ArrayList<NewsInfo>)listMap.get(hot);
                    if (newsInfos == null) {
                        newsInfos = new ArrayList<NewsInfo>(16);
                        listMap.put(hot, newsInfos);
                    }
                    newsInfos.add(newsInfoTemp);
                    continue;
                }
                recordsTemp.add(newsInfoTemp);
            }
            ArrayList<Double> list = new ArrayList<Double>(){
                private static final long serialVersionUID = -5688145064304468737L;
                {
                    this.addAll(listMap.keySet());
                }
            };
            list.sort(Comparator.reverseOrder());
            for (Double aDouble : list) {
                List newsInfos = (List)listMap.get(aDouble);
                if (newsInfos == null) continue;
                for (NewsInfo newsInfo : newsInfos) {
                    newsInfo.setHot(aDouble);
                    records.add(newsInfo);
                }
            }
            if (records.isEmpty()) {
                records = recordsTemp;
            }
            esSearchResult.setRecords(records);
            facetResult = new EsPagedResult<EsSearchResult>(esSearchResult, records.size(), 0, (Integer)0);
        }
        catch (Exception e) {
            facetResult = new EsPagedResult<EsSearchResult>();
        }
        return facetResult;
    }

    @Override
    public EsPagedResult<EsSearchResult> processResultByAgg(EsFeedbackQuery query, SearchResponse response) {
        return null;
    }
}

