/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.chinamcloud.haihe.es.result.EsResult;

public class EsPagedResult<T>
extends EsResult<T> {
    private Integer pageSize = 10;
    private Integer toPage = 1;
    private Integer totalCount = 0;
    private Integer totalPages = 0;

    public EsPagedResult() {
    }

    public EsPagedResult(T t, Integer totalResults, Integer pageNo, Integer pageSize) {
        this.setResult(t);
        this.toPage = pageNo;
        this.pageSize = pageSize;
        this.totalCount = totalResults;
        this.totalPages = this.getTotalPages();
    }

    public EsPagedResult(T t, Integer totalResults, Integer pageNo, Integer pageSize, Boolean success, String msg, Integer code) {
        this(t, totalResults, pageNo, pageSize);
        this.setSuccess(success);
        this.setErrorCode(code);
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getToPage() {
        return this.toPage;
    }

    public void setToPage(Integer toPage) {
        this.toPage = toPage;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getTotalPages() {
        if (this.totalCount == null) {
            return 0;
        }
        this.totalPages = (int)Math.ceil((float)this.totalCount.intValue() / (float)this.pageSize.intValue());
        return this.totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }
}

