/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.chinamcloud.haihe.common.bean.Trend;
import com.chinamcloud.haihe.es.bean.EsApsSearchField;
import com.chinamcloud.haihe.es.bean.HotTopicStatistic;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import com.chinamcloud.haihe.es.utils.ToolUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.springframework.util.ObjectUtils;

public class EsTopicStatisticResultProcessor
implements EsResultProcessor<EsFacetResult<List<HotTopicStatistic>>> {
    private static final long serialVersionUID = -1578105817108018484L;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Integer size;

    public EsTopicStatisticResultProcessor(Integer size) {
        this.size = size;
    }

    @Override
    public EsFacetResult<List<HotTopicStatistic>> processResult(EsFeedbackQuery query, SearchResponse response) {
        Terms agg = (Terms)response.getAggregations().get("agg");
        ArrayList<HotTopicStatistic> records = new ArrayList<HotTopicStatistic>();
        EsFacetResult facetResult = null;
        for (Terms.Bucket entry : agg.getBuckets()) {
            SearchHit[] searchHits;
            HotTopicStatistic bean = new HotTopicStatistic();
            Object cluster = entry.getKey();
            long doc_count = entry.getDocCount();
            if (ObjectUtils.isEmpty((Object)cluster)) continue;
            bean.setCluster(String.valueOf(cluster));
            bean.setDoc_count(doc_count);
            ArrayList<EsApsSearchField> news = new ArrayList<EsApsSearchField>();
            TopHits topHits = (TopHits)entry.getAggregations().get("top");
            for (SearchHit searchHit : searchHits = topHits.getHits().getHits()) {
                Map source = searchHit.getSource();
                EsApsSearchField apsFeedback = new EsApsSearchField();
                Object cluter = source.get("cluster");
                apsFeedback.setCluster(cluter == null ? null : String.valueOf(cluter));
                Object clusterId = source.get("clusterId");
                apsFeedback.setClusterId(clusterId == null ? null : Long.valueOf(clusterId.toString()));
                Object description = source.get("description");
                apsFeedback.setDescription(description == null ? null : String.valueOf(description));
                Object htmlDescription = source.get("htmlDescription");
                apsFeedback.setHtmlDescription(htmlDescription == null ? null : String.valueOf(htmlDescription));
                Object emotionScore = source.get("emotionScore");
                apsFeedback.setEmotionScore(emotionScore == null ? null : Integer.valueOf(emotionScore.toString()));
                Object id = source.get("id");
                apsFeedback.setId(id == null ? null : String.valueOf(id.toString()));
                Object pubTime = source.get("pubTime");
                apsFeedback.setPubTime(pubTime == null ? null : Long.valueOf(pubTime.toString()));
                Object refererUrl = source.get("refererUrl");
                apsFeedback.setRefererUrl(refererUrl == null ? null : String.valueOf(refererUrl));
                Object subject = source.get("subject");
                apsFeedback.setSubject(subject == null ? null : String.valueOf(subject));
                Object summaryKeywordList = source.get("summaryKeywordList");
                apsFeedback.setSummaryKeywordList(summaryKeywordList instanceof ArrayList ? (List)summaryKeywordList : null);
                Object tbNickname = source.get("tbNickname");
                apsFeedback.setTbNickname(tbNickname == null ? null : String.valueOf(tbNickname));
                Object pics = source.get("pics");
                apsFeedback.setPics(pics instanceof ArrayList ? (List)pics : null);
                news.add(apsFeedback);
            }
            Histogram histogram = (Histogram)entry.getAggregations().get("histogram");
            ArrayList<Trend> media_cover = new ArrayList<Trend>();
            ArrayList<Trend> emotion_value = new ArrayList<Trend>();
            ArrayList<Trend> hot_value = new ArrayList<Trend>();
            ArrayList<Trend> doc_value = new ArrayList<Trend>();
            for (Histogram.Bucket bucket : histogram.getBuckets()) {
                String keyAsString = bucket.getKeyAsString();
                long count = bucket.getDocCount();
                long time = 0L;
                try {
                    time = dateFormat.parse(keyAsString).getTime();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (count == 0L) {
                    emotion_value.add(new Trend<Integer>(time, 0));
                    media_cover.add(new Trend<Integer>(time, 0));
                    hot_value.add(new Trend<Integer>(time, 0));
                    doc_value.add(new Trend<Integer>(time, 0));
                    continue;
                }
                doc_value.add(new Trend<Long>(time, count));
                Sum sum_emo = (Sum)bucket.getAggregations().get("emotionscore");
                double avg_emo = sum_emo.getValue();
                emotion_value.add(new Trend<Long>(time, (long)avg_emo / count));
                Cardinality media = (Cardinality)bucket.getAggregations().get("tbnickname");
                long meidaValue = media.getValue();
                media_cover.add(new Trend<Long>(time, meidaValue));
                Terms terms = (Terms)bucket.getAggregations().get("source");
                HashMap<String, Long> map = new HashMap<String, Long>();
                for (Terms.Bucket term : terms.getBuckets()) {
                    Object media_type = term.getKey();
                    long media_count = term.getDocCount();
                    map.put(media_type.toString(), media_count);
                }
                Double hotVal = ToolUtils.HeatCalculation(map, (Integer)50);
                hot_value.add(new Trend<Double>(time, hotVal));
            }
            bean.setNews(news);
            bean.setEmotion_value(emotion_value);
            bean.setMedia_cover(media_cover);
            bean.setHot_value(hot_value);
            bean.setDoc_value(doc_value);
            records.add(bean);
        }
        if (!records.isEmpty()) {
            records.subList(0, this.size);
            facetResult = new EsFacetResult(records, (Boolean)true);
        }
        return facetResult;
    }

    @Override
    public EsFacetResult<List<HotTopicStatistic>> processResultByAgg(EsFeedbackQuery query, SearchResponse response) {
        return null;
    }
}

