/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.result;

import com.chinamcloud.haihe.common.bean.Trend;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import com.chinamcloud.haihe.es.utils.Complement;
import com.chinamcloud.haihe.es.utils.Interval;
import com.chinamcloud.haihe.es.utils.ProcessorUtils;
import com.chinamcloud.haihe.es.utils.TimeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;

public class EsTotalScaleProcessor
implements EsResultProcessor<EsFacetResult<HotEventStatistic>> {
    private static List<String> aggNames = new ArrayList<String>(6);
    private Map<String, String> map;
    private String timeFormat;
    private Interval interval;
    private String facetField;

    public EsTotalScaleProcessor() {
    }

    public EsTotalScaleProcessor(TimeEnum timeEnum) {
        this.timeFormat = timeEnum.getTimeFormat();
        this.interval = timeEnum.getInterval();
    }

    public EsTotalScaleProcessor(TimeEnum timeEnum, String facetField) {
        this.timeFormat = timeEnum.getTimeFormat();
        this.interval = timeEnum.getInterval();
        this.facetField = facetField;
    }

    public EsTotalScaleProcessor(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public EsFacetResult<HotEventStatistic> processResult(EsFeedbackQuery query, SearchResponse response) {
        EsFacetResult<HotEventStatistic> facetResult = null;
        try {
            String begin = query.getPubTimeBegin();
            String end = query.getPubTimeEnd();
            if (StringUtils.isBlank((CharSequence)begin) || StringUtils.isBlank((CharSequence)end)) {
                begin = query.getCreatedAtBegin();
                end = query.getCreatedAtEnd();
            }
            ArrayList list = new ArrayList(16);
            HotEventStatistic statistic = new HotEventStatistic();
            ArrayList<Trend<Long>> doc_count = new ArrayList<Trend<Long>>(16);
            ArrayList<Trend<Double>> emotion_value = new ArrayList<Trend<Double>>(16);
            ArrayList<Trend<Long>> media_cover = new ArrayList<Trend<Long>>(16);
            ArrayList<Trend<Double>> heat_value = new ArrayList<Trend<Double>>(16);
            ArrayList<Trend<Long>> topic_count = new ArrayList<Trend<Long>>(16);
            ArrayList<Trend<Map<String, Long>>> source_value = new ArrayList<Trend<Map<String, Long>>>(16);
            ArrayList<Trend<Map<String, Long>>> emotion_tendency = new ArrayList<Trend<Map<String, Long>>>(16);
            for (String key : aggNames) {
                Aggregation aggregation = response.getAggregations().get(key);
                if (aggregation == null) continue;
                long nowTime = System.currentTimeMillis();
                switch (key) {
                    case "emotion_score": {
                        Double avg = ProcessorUtils.getAvg(aggregation);
                        emotion_value.add(new Trend<Double>(nowTime, avg));
                        statistic.setEmotion_value(emotion_value);
                        break;
                    }
                    case "emotion_tendency": {
                        Map<String, Long> emotionLongMap = ProcessorUtils.LongTerms(aggregation);
                        emotion_tendency.add(new Trend<Map<String, Long>>(nowTime, emotionLongMap));
                        statistic.setEmotion_tendency_value(emotion_tendency);
                        break;
                    }
                    case "cluster_id": {
                        Long clusterId = ProcessorUtils.InternalCardinality(aggregation);
                        topic_count.add(new Trend<Long>(nowTime, clusterId));
                        statistic.setTopic_count(topic_count);
                        break;
                    }
                    case "tb_nickname": {
                        Long tbNickname = ProcessorUtils.InternalCardinality(aggregation);
                        media_cover.add(new Trend<Long>(nowTime, tbNickname));
                        statistic.setMedia_cover(media_cover);
                        break;
                    }
                    case "url_MD5": {
                        Long urlMD5 = ProcessorUtils.InternalCardinality(aggregation);
                        doc_count.add(new Trend<Long>(nowTime, urlMD5));
                        statistic.setDoc_count(doc_count);
                        break;
                    }
                    case "source": {
                        Map<String, Long> stringLongMap = ProcessorUtils.StringTerms(aggregation);
                        source_value.add(new Trend<Map<String, Long>>(nowTime, stringLongMap));
                        statistic.setSource_value(source_value);
                        break;
                    }
                }
            }
            statistic.setHeat_value(heat_value);
            try {
                try {
                    FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
                    if (StringUtils.isNotBlank((CharSequence)this.facetField)) {
                        switch (this.facetField) {
                            case "emotion_score": {
                                if (statistic.getEmotion_value() == null) {
                                    statistic.setEmotion_value(emotion_value);
                                }
                                List<Trend<Double>> value_emotion_score = new Complement<Double>().edit(fastDateFormat.parse(begin), fastDateFormat.parse(end), statistic.getEmotion_value(), this.timeFormat, this.interval, 0.0);
                                statistic.setEmotion_value(value_emotion_score);
                                break;
                            }
                            case "cluster_id": {
                                if (statistic.getTopic_count() == null) {
                                    statistic.setTopic_count(topic_count);
                                }
                                List<Trend<Long>> value_cluster_id = new Complement<Long>().edit(fastDateFormat.parse(begin), fastDateFormat.parse(end), statistic.getTopic_count(), this.timeFormat, this.interval, 0L);
                                statistic.setTopic_count(value_cluster_id);
                                break;
                            }
                            case "tb_nickname": 
                            case "parent_source": {
                                if (statistic.getMedia_cover() == null) {
                                    statistic.setMedia_cover(media_cover);
                                }
                                List<Trend<Long>> value_media_cover = new Complement<Long>().edit(fastDateFormat.parse(begin), fastDateFormat.parse(end), statistic.getMedia_cover(), this.timeFormat, this.interval, 0L);
                                statistic.setMedia_cover(value_media_cover);
                                break;
                            }
                            case "url_MD5": {
                                if (statistic.getDoc_count() == null) {
                                    statistic.setDoc_count(doc_count);
                                }
                                List<Trend<Long>> value_url_MD5 = new Complement<Long>().edit(fastDateFormat.parse(begin), fastDateFormat.parse(end), statistic.getDoc_count(), this.timeFormat, this.interval, 0L);
                                statistic.setDoc_count(value_url_MD5);
                                break;
                            }
                            case "source": {
                                if (statistic.getSource_value() == null) {
                                    statistic.setSource_value(source_value);
                                }
                                List<Trend<Map<String, Long>>> value_source = new Complement<1>().edit(fastDateFormat.parse(begin), fastDateFormat.parse(end), statistic.getSource_value(), this.timeFormat, this.interval, new HashMap<String, Long>(){
                                    private static final long serialVersionUID = 4507686857737154662L;
                                    {
                                        this.put("App", 0L);
                                        this.put("EPAPER", 0L);
                                        this.put("News", 0L);
                                        this.put("WeiXin", 0L);
                                        this.put("Weibo", 0L);
                                    }
                                });
                                statistic.setSource_value(value_source);
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            facetResult = new EsFacetResult<HotEventStatistic>(statistic, (Boolean)true);
        }
        catch (Exception e) {
            facetResult = new EsFacetResult<HotEventStatistic>(e.getMessage(), (Boolean)false);
        }
        return facetResult;
    }

    @Override
    public EsFacetResult<HotEventStatistic> processResultByAgg(EsFeedbackQuery query, SearchResponse response) {
        return null;
    }

    static {
        aggNames.add("emotion_score");
        aggNames.add("emotion_tendency");
        aggNames.add("cluster_id");
        aggNames.add("tb_nickname");
        aggNames.add("url_MD5");
        aggNames.add("source");
    }
}

