/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.common.bean.FacetResult;
import com.chinamcloud.haihe.common.bean.Page;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import com.chinamcloud.haihe.common.pojo.TableNews;
import com.chinamcloud.haihe.es.agg.IEsBuildAgg;
import com.chinamcloud.haihe.es.bean.EsApsFacetField;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.bean.HotTopicStatistic;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.config.EsFeedbackQueryBuilderManager;
import com.chinamcloud.haihe.es.dao.EsBaseDao;
import com.chinamcloud.haihe.es.parser.BaseParser;
import com.chinamcloud.haihe.es.pojo.EsBuildQuery;
import com.chinamcloud.haihe.es.pojo.EsBuildSort;
import com.chinamcloud.haihe.es.pojo.EsBuilderPos;
import com.chinamcloud.haihe.es.pojo.EsQueryParams;
import com.chinamcloud.haihe.es.processor.ParamsEsFeedBackQueryProcessor;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsResultProcessor;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EsNewsDataService {
    private static final Logger log = LogManager.getLogger(EsNewsDataService.class);
    @Autowired
    private EsBaseDao dao;

    public Page<SimpleNews> queryHotEvent(HotParams hotParams) throws Exception {
        String assignment;
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        log.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams(hotParams.getIndex());
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setPos(EsBuilderPos.getSearchPos(query));
        params.setSort(EsBuildSort.getSearchSort(query));
        SearchResponse response = this.dao.searcher(params);
        EsResultProcessor processor = hotParams.getEsResultProcessor();
        EsPagedResult esResult = (EsPagedResult)processor.processResult(query, response);
        BaseParser parser = hotParams.getParser();
        Page result = (Page)parser.parseRecords(esResult);
        List records = result.getRecords();
        if (records != null && !records.isEmpty() && "parentSource->reprint".equals(assignment = hotParams.getAssignment())) {
            for (SimpleNews record : records) {
                String reprint = record.getReprint();
                if (!StringUtils.isBlank((CharSequence)reprint)) continue;
                record.setReprint(record.getParentSource());
            }
        }
        return result;
    }

    public List<FacetResult> cluster(HotParams<List<FacetResult>, EsFacetResult<List<EsApsFacetField>>> hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        log.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams(hotParams.getIndex());
        params.setQuery(EsBuildQuery.getQuery(query));
        IEsBuildAgg iEsBuildAgg = hotParams.getIEsBuildAgg();
        if (iEsBuildAgg == null) {
            return null;
        }
        params.setAggs(iEsBuildAgg.buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsResultProcessor<EsFacetResult<List<EsApsFacetField>>> processor = hotParams.getEsResultProcessor();
        EsFacetResult<List<EsApsFacetField>> esResult = processor.processResult(query, response);
        BaseParser<List<FacetResult>, EsFacetResult<List<EsApsFacetField>>> parser = hotParams.getParser();
        List<FacetResult> result = parser.parseRecords(esResult);
        return result;
    }

    public Page<SimpleNews> clusterAndArticle(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        log.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams(hotParams.getIndex());
        params.setQuery(EsBuildQuery.getQuery(query));
        IEsBuildAgg iEsBuildAgg = hotParams.getIEsBuildAgg();
        if (iEsBuildAgg == null) {
            return null;
        }
        params.setAggs(iEsBuildAgg.buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsResultProcessor processor = hotParams.getEsResultProcessor();
        EsPagedResult esResult = (EsPagedResult)processor.processResultByAgg(query, response);
        BaseParser parser = hotParams.getParser();
        Page result = (Page)parser.parseRecords(esResult);
        result.setTotalPages(result.getTotalCount() / hotParams.getPage());
        result.setPageSize(hotParams.getSize());
        return result;
    }

    public List<TableNews> exportNews(HotParams<List<TableNews>, EsPagedResult<EsSearchResult>> hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        log.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams(hotParams.getIndex());
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setPos(EsBuilderPos.getSearchPos(query));
        params.setSort(EsBuildSort.getSearchSort(query));
        SearchResponse response = this.dao.searcher(params);
        EsResultProcessor<EsPagedResult<EsSearchResult>> processor = hotParams.getEsResultProcessor();
        EsPagedResult<EsSearchResult> esResult = processor.processResult(query, response);
        BaseParser<List<TableNews>, EsPagedResult<EsSearchResult>> parser = hotParams.getParser();
        List<TableNews> tableNews = parser.parseRecords(esResult);
        return tableNews;
    }

    public HotEventStatistic totalScale(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        log.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams(hotParams.getIndex());
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAggs(hotParams.getIEsBuildAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsResultProcessor processor = hotParams.getEsResultProcessor();
        EsFacetResult esResult = (EsFacetResult)processor.processResult(query, response);
        return (HotEventStatistic)esResult.getResult();
    }

    public Integer statisticNews(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        log.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams(hotParams.getIndex());
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setPos(EsBuilderPos.getSearchPos(query));
        params.setSort(EsBuildSort.getSearchSort(query));
        SearchResponse response = this.dao.searcher(params);
        EsResultProcessor processor = hotParams.getEsResultProcessor();
        EsPagedResult esResult = (EsPagedResult)processor.processResult(query, response);
        Integer totalCount = esResult.getTotalCount();
        return totalCount;
    }

    public List<HotTopicStatistic> topic(HotParams hotParams) throws Exception {
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams));
        log.info("query=" + JSON.toJSONString((Object)query));
        EsQueryParams params = new EsQueryParams(hotParams.getIndex());
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAggs(hotParams.getIEsBuildAgg().buildAgg(query));
        SearchResponse response = this.dao.faceter(params);
        EsResultProcessor processor = hotParams.getEsResultProcessor();
        EsFacetResult esResult = (EsFacetResult)processor.processResult(query, response);
        return (List)esResult.getResult();
    }
}

