/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.cardinality.InternalCardinality;

public class ProcessorUtils {
    public static Double getAvg(Aggregation aggregation) {
        InternalAvg avg = (InternalAvg)aggregation;
        if (Double.isNaN(avg.getValue())) {
            return 0.0;
        }
        return avg.getValue();
    }

    public static Map<String, Long> StringTerms(Aggregation aggregation) {
        StringTerms stringTerms = (StringTerms)aggregation;
        List buckets = stringTerms.getBuckets();
        HashMap<String, Long> map = new HashMap<String, Long>(buckets.size());
        map.put("App", 0L);
        map.put("EPAPER", 0L);
        map.put("News", 0L);
        map.put("WeiXin", 0L);
        map.put("Weibo", 0L);
        for (Terms.Bucket bucket : buckets) {
            Object key = bucket.getKey();
            long docCount = bucket.getDocCount();
            if (key == null) continue;
            map.put(key.toString(), docCount);
        }
        return map;
    }

    public static Map<String, Long> LongTerms(Aggregation aggregation) {
        LongTerms stringTerms = (LongTerms)aggregation;
        List buckets = stringTerms.getBuckets();
        HashMap<String, Long> map = new HashMap<String, Long>(buckets.size());
        for (Terms.Bucket bucket : buckets) {
            Object key = bucket.getKey();
            long docCount = bucket.getDocCount();
            if (key == null) continue;
            map.put(key.toString(), docCount);
        }
        return map;
    }

    public static Long InternalCardinality(Aggregation aggregation) {
        InternalCardinality internalCardinality = (InternalCardinality)aggregation;
        return internalCardinality.getValue();
    }
}

