/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.service;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmInfoBean;
import com.chinamcloud.haihe.newservice.analysis.mapper.AlarmInfoMapper;
import com.chinamcloud.haihe.newservice.analysis.mapper.AlarmReceiveMapper;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmInfoService {
    private static final Logger log = LogManager.getLogger(AlarmInfoService.class);
    @Autowired
    private AlarmInfoMapper alarmInfoMapper;
    @Autowired
    private AlarmReceiveMapper alarmReceiveMapper;

    public Object getAlarmInfoBeanList(String userToken, Long planId, Long alarmId) {
        if (StringUtils.isBlank((CharSequence)userToken) || alarmId == null && planId == null) {
            log.error("Failed to get the alarmId or userToken or planId");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<AlarmInfoBean> alarmInfoList = this.alarmInfoMapper.getAlarmInfoList(userToken, planId, alarmId);
        return new CodeResult<List<AlarmInfoBean>>(CodeResult.Code.SUCCESS, alarmInfoList);
    }

    public Object add(AlarmInfoBean alarmInfoBean) {
        if (StringUtils.isBlank((CharSequence)alarmInfoBean.getKeywords()) || StringUtils.isBlank((CharSequence)alarmInfoBean.getLocation()) || StringUtils.isBlank((CharSequence)alarmInfoBean.getUserToken())) {
            log.error("Failed to get the keywords or userToken or location");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Integer docNum = alarmInfoBean.getDocNum();
        docNum = docNum == null ? 0 : docNum;
        Integer emotionUpper = alarmInfoBean.getEmotionUpper();
        Integer emotionLower = alarmInfoBean.getEmotionLower();
        emotionUpper = emotionUpper == null ? 0 : emotionUpper;
        emotionLower = emotionLower == null ? 0 : emotionLower;
        Integer mediaNum = alarmInfoBean.getMediaNum();
        mediaNum = mediaNum == null ? 0 : mediaNum;
        if (docNum < 0 || emotionUpper > 100 || emotionUpper < -100 || emotionLower > 100 || emotionLower < -100 || mediaNum < 0 || emotionUpper > emotionLower) {
            log.error("docNum or emotionNum or mediaNum exception");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Date date = alarmInfoBean.getCreationTime();
        if (date == null) {
            alarmInfoBean.setCreationTime(new Date(System.currentTimeMillis()));
        }
        this.alarmInfoMapper.insert(alarmInfoBean);
        return CodeResult.SUCCESSRESULT("success");
    }

    public Object update(AlarmInfoBean alarmInfoBean) {
        if (StringUtils.isBlank((CharSequence)alarmInfoBean.getUserToken()) || alarmInfoBean.getAlarmId() == null) {
            log.error("Failed to get the alarmId or userToken");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<AlarmInfoBean> alarmInfoList = this.alarmInfoMapper.getAlarmInfoList(alarmInfoBean.getUserToken(), alarmInfoBean.getPlanId(), alarmInfoBean.getAlarmId());
        if (alarmInfoList != null || !alarmInfoList.isEmpty()) {
            AlarmInfoBean infoBean = alarmInfoList.get(0);
            if (!(!StringUtils.isNotBlank((CharSequence)alarmInfoBean.getKeywords()) && !StringUtils.isNotBlank((CharSequence)alarmInfoBean.getNoKeywords()) || StringUtils.equalsIgnoreCase((CharSequence)infoBean.getKeywords(), (CharSequence)alarmInfoBean.getKeywords()) && StringUtils.equalsIgnoreCase((CharSequence)infoBean.getNoKeywords(), (CharSequence)alarmInfoBean.getNoKeywords()))) {
                Date aDayEarlier = DateUtils.computeTimePoint(new Date(System.currentTimeMillis()), -1, "day");
                Date sendTime = infoBean.getSendTime();
                if (sendTime != null && aDayEarlier.before(sendTime)) {
                    alarmInfoBean.setSendTime(aDayEarlier);
                }
                alarmInfoBean.setStatus(0);
            }
        }
        if (alarmInfoBean.getSendMessage() != null && alarmInfoBean.getSendMessage() == 0) {
            alarmInfoBean.setStatus(0);
        }
        Integer docNum = alarmInfoBean.getDocNum();
        Integer emotionUpper = alarmInfoBean.getEmotionUpper();
        Integer emotionLower = alarmInfoBean.getEmotionLower();
        Integer mediaNum = alarmInfoBean.getMediaNum();
        if (docNum != null && docNum < 0 || emotionUpper != null && (emotionUpper > 100 || emotionUpper < -100) || emotionLower != null && (emotionLower > 100 || emotionLower < -100) || mediaNum != null && mediaNum < 0 || emotionUpper != null && emotionLower != null && emotionUpper > emotionLower) {
            log.error("docNum or emotionNum or mediaNum exception");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        this.alarmInfoMapper.update(alarmInfoBean);
        return CodeResult.SUCCESSRESULT("success");
    }

    public Object delete(String userToken, Long alarmId) {
        AlarmInfoBean alarmInfoBean;
        if (StringUtils.isBlank((CharSequence)userToken) || alarmId == null) {
            log.error("Failed to get the alarmId or userToken");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<AlarmInfoBean> alarmInfoList = this.alarmInfoMapper.getAlarmInfoList(userToken, null, alarmId);
        if (alarmInfoList != null && !alarmInfoList.isEmpty() && (alarmInfoBean = alarmInfoList.get(0)).getAlarmId().equals(alarmId)) {
            this.alarmInfoMapper.delete(userToken, alarmId);
        }
        if ((alarmInfoList = this.alarmInfoMapper.getAlarmInfoList(userToken, null, alarmId)) == null || alarmInfoList.isEmpty()) {
            this.alarmReceiveMapper.deleteByAlarmId(userToken, alarmId);
        }
        return CodeResult.SUCCESSRESULT("success");
    }
}

