/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.service;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmReceiveBean;
import com.chinamcloud.haihe.newservice.analysis.mapper.AlarmReceiveMapper;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmReceiveService {
    private static final Logger log = LogManager.getLogger(AlarmReceiveService.class);
    @Autowired
    private AlarmReceiveMapper alarmReceiveMapper;

    public Object getAlarmReceiveBeanList(String user_token, Long alarmId) {
        if (StringUtils.isBlank((CharSequence)user_token) || alarmId == null) {
            log.error("Failed to get the alarmId or userToken");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<AlarmReceiveBean> alarmReceiveBeanList = this.alarmReceiveMapper.getAlarmReceiveBeanList(user_token, alarmId);
        return new CodeResult<List<AlarmReceiveBean>>(CodeResult.Code.SUCCESS, alarmReceiveBeanList);
    }

    public Object add(AlarmReceiveBean alarmReceiveBean) {
        String telephone = alarmReceiveBean.getTelephone();
        String email = alarmReceiveBean.getEmail();
        String weChatId = alarmReceiveBean.getWeChatId();
        String receiveName = alarmReceiveBean.getReceiveName();
        if (StringUtils.isBlank((CharSequence)alarmReceiveBean.getUserToken()) || StringUtils.isBlank((CharSequence)receiveName) || alarmReceiveBean.getAlarmId() == null || StringUtils.isBlank((CharSequence)telephone) && StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)weChatId)) {
            log.error("Failed to get the alarmId or userToken or receiveName or (telephone or email or weChatId)");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        AlarmReceiveBean receiveBean = new AlarmReceiveBean(alarmReceiveBean);
        List<AlarmReceiveBean> alarmReceiveBeanList = this.alarmReceiveMapper.getAlarmReceiveBeanListByAlarmReceiveBean(receiveBean);
        if (alarmReceiveBeanList == null || alarmReceiveBeanList.isEmpty()) {
            String regex;
            String reg;
            Pattern p;
            Matcher matcher;
            boolean matches;
            Date date = alarmReceiveBean.getCreationTime();
            if (date == null) {
                alarmReceiveBean.setCreationTime(new Date(System.currentTimeMillis()));
            }
            if (StringUtils.isNotBlank((CharSequence)receiveName) && (matches = (matcher = (p = Pattern.compile(reg = "(.*?)[`~!@#$%^&*()_\\-+=<>?:\"{}|,.\\/;'\\[\\]\u00b7~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014\\-+={}|\u300a\u300b\uff1f\uff1a\u201c\u201d\u3010\u3011\u3001\uff1b\u2018\u2019\uff0c\u3002\u3001](.*?)")).matcher(receiveName)).matches())) {
                log.error("Added the username to not contain featured characters\uff01");
                return CodeResult.failedResultByMsgSource("receive_name_error");
            }
            if (StringUtils.isNotBlank((CharSequence)telephone)) {
                regex = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[013678])|(18[0,5-9]))\\d{8}$";
                if (telephone.length() != 11) {
                    log.error("Added phone number is not 11 bits!");
                    return CodeResult.failedResultByMsgSource("phone_error");
                }
                p = Pattern.compile(regex);
                matcher = p.matcher(telephone);
                matches = matcher.matches();
                if (!matches) {
                    log.error("Added phone number format error!");
                    return CodeResult.failedResultByMsgSource("phone_error");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)email) && !(matches = (matcher = (p = Pattern.compile(regex = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$")).matcher(email)).matches())) {
                log.error("Added email format error!");
                return CodeResult.failedResultByMsgSource("email_error");
            }
            this.alarmReceiveMapper.insert(alarmReceiveBean);
            return CodeResult.SUCCESSRESULT("success");
        }
        return CodeResult.SUCCESSRESULT("data_repetition");
    }

    public Object update(AlarmReceiveBean alarmReceiveBean) {
        String regex;
        String reg;
        Pattern p;
        Matcher matcher;
        boolean matches;
        String telephone = alarmReceiveBean.getTelephone();
        String email = alarmReceiveBean.getEmail();
        String weChatId = alarmReceiveBean.getWeChatId();
        String receiveName = alarmReceiveBean.getReceiveName();
        if (alarmReceiveBean.getId() == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (StringUtils.isNotBlank((CharSequence)receiveName) && (matches = (matcher = (p = Pattern.compile(reg = "(.*?)[`~!@#$%^&*()_\\-+=<>?:\"{}|,.\\/;'\\[\\]\u00b7~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014\\-+={}|\u300a\u300b\uff1f\uff1a\u201c\u201d\u3010\u3011\u3001\uff1b\u2018\u2019\uff0c\u3002\u3001](.*?)")).matcher(receiveName)).matches())) {
            log.error("Modify the username to contain featured characters\uff01");
            return CodeResult.failedResultByMsgSource("receive_name_error");
        }
        if (StringUtils.isNotBlank((CharSequence)telephone)) {
            regex = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[013678])|(18[0,5-9]))\\d{8}$";
            if (telephone.length() != 11) {
                log.error("Modify phone number is not 11 bits!");
                return CodeResult.failedResultByMsgSource("phone_error");
            }
            p = Pattern.compile(regex);
            matcher = p.matcher(telephone);
            matches = matcher.matches();
            if (!matches) {
                log.error("Modify phone number format error!");
                return CodeResult.failedResultByMsgSource("phone_error");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)email) && !(matches = (matcher = (p = Pattern.compile(regex = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$")).matcher(email)).matches())) {
            log.error("Modify email format error!");
            return CodeResult.failedResultByMsgSource("email_error");
        }
        this.alarmReceiveMapper.update(alarmReceiveBean);
        return CodeResult.SUCCESSRESULT("success");
    }

    public Object delete(String userToken, Integer id) {
        if (StringUtils.isBlank((CharSequence)userToken) || id == null) {
            log.error("Failed to get the id or userToken");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<AlarmReceiveBean> alarmReceiveBeans = this.alarmReceiveMapper.getAlarmReceiveBeans(userToken, id);
        if (alarmReceiveBeans != null && !alarmReceiveBeans.isEmpty()) {
            this.alarmReceiveMapper.delete(userToken, id);
            return CodeResult.SUCCESSRESULT("success");
        }
        return CodeResult.SUCCESSRESULT("failed");
    }
}

