/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.RepetitionAfterProcessor;
import com.chinamcloud.haihe.common.bean.FacetResult;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.HttpUtils;
import com.chinamcloud.haihe.configService.entity.DataConfig;
import com.chinamcloud.haihe.configService.mapper.DataConfigMapper;
import com.chinamcloud.haihe.es.agg.EsFactAggWithEmotionTendency;
import com.chinamcloud.haihe.es.bean.EsApsFacetField;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import com.chinamcloud.haihe.es.service.EsNewsDataService;
import com.chinamcloud.haihe.newservice.analysis.bean.PlanInfoBean;
import com.chinamcloud.haihe.newservice.analysis.mapper.EventInfoMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:config/spider.properties"})
public class EventInfoService {
    private static final Logger log = LogManager.getLogger(EventInfoService.class);
    @Autowired
    private EventInfoMapper eventInfoMapper;
    @Autowired
    private DataConfigMapper dataconfigMapper;
    @Autowired
    private EsNewsDataService esNewsDataService;
    @Value(value="${spider.url}")
    private String spider_url;
    @Value(value="${spider.min.hour.weixin}")
    private Integer weixin_hours;
    @Value(value="${spider.min.hour.weibo}")
    private Integer weibo_hours;

    public Object planList(String user_token) {
        DataConfig dataConfig;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("user_token", user_token);
        List<PlanInfoBean> planInfoList = this.eventInfoMapper.planInfoList(param);
        if (planInfoList.size() == 0) {
            param.put("user_token", "default");
            planInfoList = this.eventInfoMapper.planInfoList(param);
        }
        if ((dataConfig = this.dataconfigMapper.selectByPrimaryKey(user_token, "event_info_classify", "1")) == null || dataConfig.getData() == null) {
            dataConfig = this.dataconfigMapper.selectByPrimaryKey("default", "event_info_classify", "1");
        }
        DocumentContext document = JsonPath.parse((Object)JSON.parseObject((String)dataConfig.getData()));
        for (PlanInfoBean planInfo : planInfoList) {
            String classify = planInfo.getClassify();
            List classify_name = (List)document.read("$.*[?(@.code == " + classify + ")].name", new Predicate[0]);
            if (classify_name == null || classify_name.size() == 0) {
                planInfo.setClassify("\u5176\u4ed6");
                continue;
            }
            planInfo.setClassify(classify_name.get(0).toString());
        }
        return new CodeResult<List<PlanInfoBean>>(CodeResult.Code.SUCCESS, planInfoList);
    }

    public Object addPlan(PlanInfoBean planInfo) {
        Date weibo_crawler_time = planInfo.getWeibo_crawler_time();
        Date weixin_crawler_time = planInfo.getWeixin_crawler_time();
        planInfo.setWeibo_crawler_time(null);
        planInfo.setWeixin_crawler_time(null);
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("user_token", planInfo.getUser_token());
            param.put("name", planInfo.getName());
            List<PlanInfoBean> list = this.eventInfoMapper.planInfoList(param);
            if (list != null && list.size() > 0) {
                return CodeResult.failedResult("create plan fail , name is exists !");
            }
            param.clear();
            param.put("user_token", planInfo.getUser_token());
            param.put("status", 0);
            list = this.eventInfoMapper.planInfoList(param);
            planInfo.setStatus(0);
            if (list != null && list.size() > 0) {
                planInfo.setStatus(-1);
            }
            this.eventInfoMapper.insertPlanInfo(planInfo);
        }
        catch (Exception e) {
            log.error("create plan fail, msg : {}", (Object)e.getMessage());
            return CodeResult.failedResult("create plan fail, msg :" + e.getMessage());
        }
        Boolean crawler = this.crawler(planInfo);
        if (crawler.booleanValue()) {
            planInfo.setWeixin_crawler_time(weixin_crawler_time);
            planInfo.setWeibo_crawler_time(weibo_crawler_time);
            this.updatePlan(planInfo);
        }
        return new CodeResult(CodeResult.Code.SUCCESS, "create plan success !");
    }

    public Boolean crawler(PlanInfoBean planInfo) {
        try {
            JSONObject spiderParam = new JSONObject();
            spiderParam.put("planId", (Object)planInfo.getPlanId());
            spiderParam.put("keyWords", (Object)planInfo.getKeyWords());
            HttpUtils.HttpRequestResult requestWeiXin = HttpUtils.executePost(StringUtils.join((Object[])new String[]{this.spider_url, "/executeSpider/weixin"}), spiderParam.toJSONString());
            if (!requestWeiXin.getStatus().equals((Object)HttpUtils.Status.SUCCESS)) {
                log.error("create plan fail, msg : {}", (Object)requestWeiXin.getMsg());
                return false;
            }
            String[] split = planInfo.getKeyWords().split(",");
            spiderParam.put("keyWords", (Object)split);
            HttpUtils.HttpRequestResult requestWeiBo = HttpUtils.executePost(StringUtils.join((Object[])new String[]{this.spider_url, "/executeSpider/weibo"}), spiderParam.toJSONString());
            if (!requestWeiBo.getStatus().equals((Object)HttpUtils.Status.SUCCESS)) {
                log.error("create plan fail, msg : {}", (Object)requestWeiBo.getMsg());
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Object updatePlan(PlanInfoBean planInfo) {
        try {
            this.eventInfoMapper.updatePlan(planInfo);
        }
        catch (Exception e) {
            log.error("create plan fail, msg : {}", (Object)e.getMessage());
            return CodeResult.failedResult("create plan fail, msg :" + e.getMessage());
        }
        return new CodeResult(CodeResult.Code.SUCCESS, "create plan success !");
    }

    public Object switchPlan(PlanInfoBean planInfo) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("user_token", planInfo.getUser_token());
            param.put("name", planInfo.getName());
            List<PlanInfoBean> list = this.eventInfoMapper.planInfoList(param);
            if (list == null || list.size() == 0) {
                log.error("switch plan fail , name is not exists !");
                return CodeResult.failedResult("switch plan fail , name is not exists !");
            }
            planInfo.setStatus(-1);
            this.eventInfoMapper.switchPlan(planInfo);
            Integer planId = Math.abs(StringUtils.join((Object[])new String[]{planInfo.getUser_token(), planInfo.getName()}).hashCode());
            planInfo.setPlanId(planId);
            planInfo.setStatus(0);
            this.eventInfoMapper.switchPlan(planInfo);
        }
        catch (Exception e) {
            log.error("switch plan fail, msg : {}", (Object)e.getMessage());
            return CodeResult.failedResult("switch plan fail msg :" + e.getMessage());
        }
        return new CodeResult(CodeResult.Code.SUCCESS, "switch plan success !");
    }

    public Object deletePlan(PlanInfoBean planInfo) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("user_token", planInfo.getUser_token());
            param.put("name", planInfo.getName());
            List<PlanInfoBean> list = this.eventInfoMapper.planInfoList(param);
            if (list == null || list.size() == 0) {
                return CodeResult.failedResult("delete plan fail , name is not exists !");
            }
            Integer planId = Math.abs(StringUtils.join((Object[])new String[]{planInfo.getUser_token(), planInfo.getName()}).hashCode());
            planInfo.setPlanId(planId);
            this.eventInfoMapper.deletePlan(planInfo);
        }
        catch (Exception e) {
            log.error("delete plan fail, msg : {}", (Object)e.getMessage());
            return CodeResult.failedResult("delete plan fail msg :" + e.getMessage());
        }
        return new CodeResult(CodeResult.Code.SUCCESS, "delete plan success !");
    }

    public Object refreshPlan(PlanInfoBean planParam) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        try {
            PlanInfoBean infoBean;
            param.put("user_token", planParam.getUser_token());
            param.put("name", planParam.getName());
            List<PlanInfoBean> list = this.eventInfoMapper.planInfoList(param);
            if (list == null || list.size() == 0) {
                param.put("user_token", "default");
                list = this.eventInfoMapper.planInfoList(param);
                if (list == null || list.size() == 0) {
                    return CodeResult.failedResult("refresh plan fail , plan name is not exists !");
                }
            }
            if ((infoBean = list.get(0)).getWeixin_diff_hours() >= (long)this.weixin_hours.intValue()) {
                JSONObject spiderParam = new JSONObject();
                spiderParam.put("planId", (Object)infoBean.getPlanId());
                spiderParam.put("keyWords", (Object)infoBean.getKeyWords());
                HttpUtils.HttpRequestResult requestWeiXin = HttpUtils.executePost(StringUtils.join((Object[])new String[]{this.spider_url, "/executeSpider/weixin"}), spiderParam.toJSONString());
                if (!requestWeiXin.getStatus().equals((Object)HttpUtils.Status.SUCCESS)) {
                    log.error("create plan fail, msg : {}", (Object)requestWeiXin.getMsg());
                    return CodeResult.failedResult("create plan fail, msg :" + requestWeiXin.getMsg());
                }
            }
            if (infoBean.getWeibo_diff_hours() >= (long)this.weibo_hours.intValue()) {
                String[] split = infoBean.getKeyWords().split(",");
                JSONObject spiderParam = new JSONObject();
                spiderParam.put("planId", (Object)infoBean.getPlanId());
                spiderParam.put("keyWords", (Object)split);
                HttpUtils.HttpRequestResult requestWeiBo = HttpUtils.executePost(StringUtils.join((Object[])new String[]{this.spider_url, "/executeSpider/weibo"}), spiderParam.toJSONString());
                if (!requestWeiBo.getStatus().equals((Object)HttpUtils.Status.SUCCESS)) {
                    log.error("create plan fail, msg : {}", (Object)requestWeiBo.getMsg());
                    return CodeResult.failedResult("create plan fail, msg :" + requestWeiBo.getMsg());
                }
            }
        }
        catch (Exception e) {
            log.error("refresh plan fail, msg : {}", (Object)e.getMessage());
            return CodeResult.failedResult("refresh plan fail msg :" + e.getMessage());
        }
        return new CodeResult(CodeResult.Code.SUCCESS, "refresh plan success !");
    }

    public Object getPlanListByPlanId(PlanInfoBean planInfoBean) {
        if (planInfoBean == null) {
            log.error("Failed to get the planId msg : {planId error}");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<PlanInfoBean> planInfoBeanList = this.eventInfoMapper.selectPlanListByPlanId(planInfoBean);
        return new CodeResult<List<PlanInfoBean>>(CodeResult.Code.SUCCESS, planInfoBeanList);
    }

    @Async
    @Cacheable(value={"redis#604800"}, key="#root.methodName", unless="#result == null")
    public Object addDefaultData() {
        PlanInfoBean planInfoBean;
        CodeResult planListByPlanId;
        List planInfoBeanList;
        HotParams<List<FacetResult>, EsFacetResult<List<EsApsFacetField>>> hotParams = new HotParams<List<FacetResult>, EsFacetResult<List<EsApsFacetField>>>();
        hotParams.setDay("7");
        hotParams.setFacetField("summary_keywords");
        hotParams.setIEsBuildAgg(new EsFactAggWithEmotionTendency());
        hotParams.setEsResultProcessor(new EsFacetResultProcessor());
        hotParams.setParser(new FacetDataParser());
        List<FacetResult> cluster = null;
        List result = null;
        try {
            cluster = this.esNewsDataService.cluster(hotParams);
            CodeResult process = new RepetitionAfterProcessor().process(cluster);
            result = (List)process.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String keyword = "";
        if (result != null && !result.isEmpty()) {
            int size = Math.min(2, result.size());
            for (int i = 0; i < size; ++i) {
                keyword = keyword + ((Map)result.get(i)).get("key") + ",";
            }
        }
        if (keyword.endsWith(",")) {
            keyword = keyword.substring(0, keyword.lastIndexOf(","));
        }
        if (StringUtils.isBlank((CharSequence)keyword)) {
            keyword = "\u4e2d\u56fd";
        }
        if ((planInfoBeanList = (List)(planListByPlanId = (CodeResult)this.getPlanListByPlanId(planInfoBean = new PlanInfoBean("default", 123, "\u6700\u65b0\u8206\u60c5", "4", keyword, 0))).getResult()) == null || planInfoBeanList.isEmpty()) {
            try {
                this.addPlan(planInfoBean);
            }
            catch (Exception exception) {}
        } else {
            this.updatePlan(planInfoBean);
            this.crawler(planInfoBean);
        }
        return new CodeResult(CodeResult.Code.SUCCESS);
    }
}

