/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Const;
import com.chinamcloud.haihe.common.afterprocessor.HotTopicAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.RepetitionAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.TrendProcessor;
import com.chinamcloud.haihe.common.bean.FacetResult;
import com.chinamcloud.haihe.common.bean.Page;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.ClusterParams;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.es.agg.EsBuildEventStatisticAgg;
import com.chinamcloud.haihe.es.agg.EsBuildTopicStatisticAgg;
import com.chinamcloud.haihe.es.agg.EsFactAggWithEmotionTendency;
import com.chinamcloud.haihe.es.agg.EsHotTopicAgg;
import com.chinamcloud.haihe.es.bean.EsApsFacetField;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.controller.EsExclusiveController;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.chinamcloud.haihe.es.processor.TopicStatisticAfterProcessor;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import com.chinamcloud.haihe.es.result.EsTopicStatisticResultProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleByTimeProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleProcessor;
import com.chinamcloud.haihe.es.utils.TimeEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cluster-service"})
@CrossOrigin
public class ClusterServiceController {
    @Autowired
    private EsNewsDataController esNewsDataController;
    @Autowired
    private EsExclusiveController esExclusiveController;

    @PostMapping(value={"/getRepeatedNum"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getRepeatedNum(@RequestBody @Validated ClusterParams<List<FacetResult>, EsFacetResult<List<EsApsFacetField>>> params) {
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsFacetResultProcessor());
        params.setParser(new FacetDataParser());
        params.setIEsBuildAgg(new EsFactAggWithEmotionTendency());
        params.setAfterProcessor(new RepetitionAfterProcessor(params.getPageSize()));
        return this.esNewsDataController.cluster(params);
    }

    @PostMapping(value={"/getHotTopic"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getHotTopic(@RequestBody @Validated ClusterParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> hotParams, @RequestParam(value="dataType", required=false, defaultValue="list") String dataType) {
        hotParams.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        if (hotParams.getDay() == null && (hotParams.getFromDt() == null || hotParams.getToDt() == null)) {
            hotParams.setDay("30");
        }
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetField("cluster");
        hotParams.setSortFields((List<String>)new ArrayList<String>(){
            private static final long serialVersionUID = 7583144793288838144L;
            {
                this.add("doc_count desc");
            }
        });
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.TOPIC));
        hotParams.setIEsBuildAgg(new EsHotTopicAgg((List<String>)new ArrayList<String>(){
            private static final long serialVersionUID = 8229470827989700054L;
            {
                this.add("hot");
            }
        }));
        hotParams.setAfterProcessor(new HotTopicAfterProcessor(dataType, hotParams.getPage(), hotParams.getSize()));
        return this.esNewsDataController.hotTopic(hotParams);
    }

    @PostMapping(value={"/getTotalScale"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getTotalScale(final @RequestBody @Validated HotParams<HotEventStatistic, EsFacetResult<HotEventStatistic>> hotParams) {
        hotParams.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        hotParams.setEsResultProcessor(new EsTotalScaleProcessor());
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("emotion_score", "avg");
                this.put("cluster_id", "cardinality");
                this.put("tb_nickname", "cardinality");
                this.put("url_MD5", "cardinality");
                if (hotParams.getMap() != null) {
                    this.putAll(hotParams.getMap());
                }
            }
        }));
        return this.esExclusiveController.totalScale(hotParams);
    }

    @PostMapping(value={"/getPublishingTrend"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getPublishingTrend(@RequestBody @Validated ClusterParams<HotEventStatistic, EsFacetResult<HotEventStatistic>> hotParams) {
        String facetField;
        String value;
        hotParams.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        TimeEnum timeEnum = TimeEnum.getTimeEnum("hour");
        if (StringUtils.isNotBlank((CharSequence)hotParams.getTimeType())) {
            timeEnum = TimeEnum.getTimeEnum(hotParams.getTimeType());
        }
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        if (hotParams.getDay() == null && (hotParams.getFromDt() == null || hotParams.getToDt() == null)) {
            List<Date> dateList = DateUtils.GetTime(-2, true, "week");
            hotParams.setFromDt(dateList.get(0));
            hotParams.setToDt(dateList.get(1));
        }
        if (hotParams.getDay() != null) {
            Date[] dates = null;
            try {
                dates = DateUtils.computeDatesBackward(Integer.parseInt(hotParams.getDay()), true);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
            hotParams.setFromDt((Date)DateUtils.getTime(dates[0], "date"));
            hotParams.setToDt((Date)DateUtils.getTime(dates[1], "date"));
            hotParams.setDay("");
        }
        if (StringUtils.isBlank((CharSequence)(value = Const.TrendMap.get(facetField = hotParams.getFacetField() == null ? "source" : hotParams.getFacetField())))) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(facetField, value);
            }
        }, timeEnum));
        hotParams.setEsResultProcessor(new EsTotalScaleByTimeProcessor(timeEnum, hotParams.getFacetField()));
        hotParams.setAfterProcessor(new TrendProcessor((List<String>)new ArrayList<String>(){
            {
                this.add(facetField);
            }
        }));
        return this.esNewsDataController.trend(hotParams);
    }

    @PostMapping(value={"/getEventStatistics"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getEventStatistics(final @RequestBody @Validated ClusterParams<HotEventStatistic, EsFacetResult<HotEventStatistic>> params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        HotParamsUtils.setKeyWord(params);
        params.setFacetMincount(1);
        params.setEsResultProcessor(new EsTotalScaleProcessor());
        HashMap<String, String> map = params.getMap();
        if (map == null) {
            map = new HashMap<String, String>(){
                private static final long serialVersionUID = 2086343820663726602L;
                {
                    this.put("emotion_score", "avg");
                    this.put("cluster_id", "cardinality");
                    this.put("tb_nickname", "cardinality");
                    this.put("url_MD5", "cardinality");
                    if (params.getMap() != null) {
                        this.putAll(params.getMap());
                    }
                }
            };
        }
        params.setIEsBuildAgg(new EsBuildEventStatisticAgg(map));
        return this.esNewsDataController.totalScale(params);
    }

    @PostMapping(value={"/getTopic"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getTopic(@RequestBody @Validated ClusterParams hotParams, @RequestParam(value="dataType", required=false, defaultValue="list") String dataType) {
        hotParams.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        if (hotParams.getDay() == null && (hotParams.getFromDt() == null || hotParams.getToDt() == null)) {
            hotParams.setDay("7");
        }
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetField("cluster_id");
        hotParams.setEsResultProcessor(new EsTopicStatisticResultProcessor(hotParams.getSize()));
        hotParams.setIEsBuildAgg(new EsBuildTopicStatisticAgg());
        hotParams.setAfterProcessor(new TopicStatisticAfterProcessor());
        return this.esExclusiveController.hotTopic(hotParams);
    }
}

