/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.backStageManagement.service.RegionService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.ArealDistributionProcessor;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.es.agg.EsTermBucketAgg;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.pojo.TermAggBucket;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import com.chinamcloud.haihe.newservice.basic.bean.RegionalParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/regional-service"})
@CrossOrigin
public class RegionalNewsController {
    @Autowired
    private RegionService regionService;
    @Autowired
    private EsNewsDataController esNewsDataController;

    @PostMapping(value={"/getArealDistribution"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getArealDistribution(@RequestBody RegionalParam regionalParam) {
        regionalParam.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        regionalParam.setFacetMincount(1);
        List<String> regionNames = regionalParam.getRegionNames();
        if (regionNames == null) {
            regionNames = new ArrayList<String>(16);
        }
        Map<String, Set<String>> mapList = null;
        mapList = this.regionService.getAllAddr(regionNames, regionalParam.getRegionCode() == null ? "" : regionalParam.getRegionCode().toString(), regionalParam.getRegionType() == null ? "" : regionalParam.getRegionType());
        regionNames.addAll(mapList.keySet());
        if (regionNames.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        LinkedList<TermAggBucket> termAggBuckets = new LinkedList<TermAggBucket>();
        for (Map.Entry<String, Set<String>> entry : mapList.entrySet()) {
            termAggBuckets.add(new TermAggBucket(new ArrayList<String>((Collection)entry.getValue()), "description", entry.getKey()));
        }
        HotParamsUtils.setKeyWord(regionalParam);
        regionalParam.setFacetField("description");
        regionalParam.setEsResultProcessor(new EsFacetResultProcessor());
        regionalParam.setParser(new FacetDataParser());
        regionalParam.setIEsBuildAgg(new EsTermBucketAgg(termAggBuckets));
        regionalParam.setAfterProcessor(new ArealDistributionProcessor(regionNames));
        return this.esNewsDataController.cluster(regionalParam);
    }
}

