/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.backStageManagement.pojo.SiteInc;
import com.chinamcloud.haihe.backStageManagement.service.RegionService;
import com.chinamcloud.haihe.backStageManagement.service.SiteQueryService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.NewDetailAfterProcessor;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.TopicKeywordUtils;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/station-service"})
@CrossOrigin
@PropertySource(value={"classpath:/config/level.properties"}, encoding="UTF-8")
public class StationController {
    private static final Logger log = LogManager.getLogger(StationController.class);
    @Autowired
    private SiteQueryService siteQueryService;
    @Autowired
    private RegionService regionService;
    @Value(value="${childList}")
    private String order;
    private static ObjectMapper mapper = new ObjectMapper();

    @PostMapping(value={"/getType"}, consumes={"application/json;charset=utf-8"})
    public Object getType(@RequestParam String useChildrenNum) {
        return this.siteQueryService.getType(useChildrenNum);
    }

    @PostMapping(value={"/getAddr/{provinceCode}"}, consumes={"application/json;charset=utf-8"})
    public Object getAddr(@PathVariable String provinceCode) {
        return this.regionService.getAddrTree(provinceCode, new Boolean[0]);
    }

    @PostMapping(value={"/getProvinces"}, consumes={"application/json;charset=utf-8"})
    public Object getProvinces() {
        return this.regionService.getProvinces(new Boolean[0]);
    }

    @PostMapping(value={"/getSiteLevel"}, consumes={"application/json;charset=utf-8"})
    public Object getSiteLevel() {
        try {
            List readValue = (List)mapper.readValue(this.order, List.class);
            return new CodeResult<List>(CodeResult.Code.SUCCESS, readValue);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new CodeResult<List>(CodeResult.Code.SUCCESS, Collections.EMPTY_LIST);
        }
    }

    @PostMapping(value={"/getClassify"}, consumes={"application/json;charset=utf-8"})
    public Object getClassify(@RequestBody SiteInc site) {
        return this.siteQueryService.getClassify(site.getType(), site.isUseChildrenNum());
    }

    @PostMapping(value={"/getSite"}, consumes={"application/json;charset=utf-8"})
    public Object getSite(@RequestBody SiteInc site) {
        return this.siteQueryService.getSiteTree(site);
    }

    @PostMapping(value={"/getSiteHead"}, consumes={"application/json;charset=utf-8"})
    public Object getSiteHead(@RequestBody SiteInc site) {
        return this.siteQueryService.getSiteHead(site);
    }

    @PostMapping(value={"/getDetailsPageSite"}, consumes={"application/json;charset=utf-8"})
    public Object getDetailsPageSite(@RequestBody SiteInc siteInc) {
        return this.siteQueryService.getDetailsPageSite(siteInc);
    }

    @PostMapping(value={"/newslistAndSite/{dataType}"}, consumes={"application/json;charset=utf-8"})
    public Object newslistAndSite(@RequestBody HotParams params, @PathVariable String dataType) {
        List<String> keyWords = params.getKeyWords();
        if (keyWords != null && !keyWords.isEmpty()) {
            log.info("Keyword is empty");
            String keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(keyWords);
            params.setDescription(keyWord);
        }
        ModelAndView view = new ModelAndView("/es/news-service/newslist");
        view.addObject("params", (Object)params);
        params.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.SITE));
        params.setAfterProcessor(new NewDetailAfterProcessor(dataType, params.getPage(), params.getSize()));
        return view;
    }
}

