/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/statistic-service"})
@CrossOrigin
public class StatisticController {
    @Autowired
    private EsNewsDataController esNewsDataController;

    @PostMapping(value={"/getEventStatistics"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getEventStatistics(@RequestBody HotParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        return this.esNewsDataController.statisticNews(params);
    }
}

