/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.common.http.utils;

import com.chinamcloud.bigdata.common.http.utils.HttpRequestSetter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static ResponseHandler<String> defaultHandler = new ResponseHandler<String>(){

        @Override
        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (response != null && response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity());
            }
            return null;
        }
    };
    private static final CloseableHttpClient httpclient;

    static {
        PoolingHttpClientConnectionManager poolManager = new PoolingHttpClientConnectionManager();
        poolManager.setDefaultMaxPerRoute(10);
        httpclient = HttpClients.custom().setConnectionManager(poolManager).build();
    }

    private static <T> T executeRequest(HttpUriRequest request, ResponseHandler<T> responseHandler) {
        HttpClientContext context = HttpClientContext.create();
        try {
            return httpclient.execute(request, responseHandler, (HttpContext)context);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String buildUrl(String host, Map<String, String> params) throws URISyntaxException {
        if (StringUtils.isBlank(host)) {
            throw new IllegalArgumentException("host can't be null or empty");
        }
        URIBuilder builder = new URIBuilder(host);
        if (params != null && params.size() > 0) {
            params.forEach((x, y) -> builder.addParameter((String)x, (String)y));
        }
        return builder.toString();
    }

    public static String executePost(String url, String content, HttpRequestSetter ... sets) {
        HttpPost post = new HttpPost(url);
        if (!StringUtils.isBlank(content)) {
            StringEntity entity = null;
            try {
                entity = new StringEntity(content);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (entity != null) {
                post.setEntity(entity);
            }
            HttpRequestSetter[] httpRequestSetterArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                HttpRequestSetter set = httpRequestSetterArray[n2];
                set.process(post);
                ++n2;
            }
        }
        return HttpUtils.executeRequest(post, defaultHandler);
    }

    public static <T> T executePost(String url, String content, ResponseHandler<T> responseHandler, HttpRequestSetter ... sets) {
        HttpPost post = new HttpPost(url);
        if (!StringUtils.isBlank(content)) {
            StringEntity entity = null;
            try {
                entity = new StringEntity(content);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (entity != null) {
                post.setEntity(entity);
            }
            HttpRequestSetter[] httpRequestSetterArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                HttpRequestSetter set = httpRequestSetterArray[n2];
                set.process(post);
                ++n2;
            }
        }
        return HttpUtils.executeRequest(post, responseHandler);
    }

    public static <T> T executeGet(String host, Map<String, String> params, ResponseHandler<T> responseHandler, HttpRequestSetter ... sets) {
        String url = null;
        try {
            url = HttpUtils.buildUrl(host, params);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (url != null) {
            HttpGet get = new HttpGet(url);
            HttpRequestSetter[] httpRequestSetterArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                HttpRequestSetter set = httpRequestSetterArray[n2];
                set.process(get);
                ++n2;
            }
            return HttpUtils.executeRequest(get, responseHandler);
        }
        return null;
    }

    public static String executeGet(String host, Map<String, String> params, HttpRequestSetter ... sets) {
        String url = null;
        try {
            url = HttpUtils.buildUrl(host, params);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (url != null) {
            HttpGet get = new HttpGet(url);
            HttpRequestSetter[] httpRequestSetterArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                HttpRequestSetter set = httpRequestSetterArray[n2];
                set.process(get);
                ++n2;
            }
            return HttpUtils.executeRequest(get, defaultHandler);
        }
        return null;
    }
}

