/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.common.web.utils;

import com.chinamcloud.bigdata.common.web.bean.Page;
import java.util.Iterator;
import java.util.List;

public class PageDataIterator<T>
implements Iterator<T> {
    private int currentIndex = 0;
    private int currentPage = 1;
    private int totalPage = 0;
    private Page<T> page;
    private IPageDataGenerator<T> function;

    public int getCurrentPage() {
        return this.currentPage;
    }

    public PageDataIterator(IPageDataGenerator<T> function) {
        this.function = function;
    }

    @Override
    public boolean hasNext() {
        if (this.page == null || this.page.getRecords().size() <= this.currentIndex && ++this.currentPage < this.totalPage) {
            List<T> records;
            this.currentIndex = 0;
            this.page = null;
            Page<T> tmpPage = this.function.generate(this.currentPage);
            if (tmpPage != null && (records = tmpPage.getRecords()) != null && !records.isEmpty()) {
                this.page = tmpPage;
                if (this.totalPage == 0) {
                    this.totalPage = this.page.getTotalPages();
                }
            }
        }
        return this.page != null && this.currentIndex < this.page.getRecords().size();
    }

    @Override
    public T next() {
        List<T> records = this.page.getRecords();
        T t = records.get(this.currentIndex);
        ++this.currentIndex;
        return t;
    }

    public static interface IPageDataGenerator<T> {
        public Page<T> generate(int var1);
    }
}

