/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.common.web.utils;

import com.chinamcloud.bigdata.common.utils.DateUtils;
import com.chinamcloud.bigdata.common.web.bean.TimeTrendStat;
import com.chinamcloud.bigdata.common.web.core.Interval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TimeTrendStatUtils {
    public static <R, T extends TimeTrendStat<R>> List<T> fillTimeTrendStats(List<T> timeTrendStat, Interval interval, int step, Sort sort, Date fromDate, Date toDate, String pattern, InitFunction<T> initFunction, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        LinkedHashMap<String, TimeTrendStat> maps = new LinkedHashMap<String, TimeTrendStat>(timeTrendStat.size());
        fromDate = interval.truncate(fromDate);
        toDate = interval.truncate(toDate);
        while (!fromDate.after(toDate)) {
            TimeTrendStat clazzObject = (TimeTrendStat)clazz.newInstance();
            clazzObject.setTs(fromDate);
            clazzObject.setDateStr(DateUtils.format((String)pattern, (Date)fromDate));
            if (initFunction != null) {
                initFunction.init(clazzObject);
            }
            maps.put(clazzObject.getDateStr(), clazzObject);
            fromDate = interval.inc(fromDate, step);
        }
        for (TimeTrendStat trendStat : timeTrendStat) {
            String key;
            TimeTrendStat old;
            if (trendStat == null || (old = (TimeTrendStat)maps.get(key = StringUtils.isNotBlank(trendStat.getDateStr()) ? trendStat.getDateStr() : DateUtils.format((String)pattern, (Date)trendStat.getTs()))) == null) continue;
            old.mergeValue(trendStat.getValue());
        }
        ArrayList values = new ArrayList(maps.values());
        if (Sort.DESC == sort) {
            Collections.reverse(values);
        }
        return values;
    }

    public static <R, T extends TimeTrendStat<R>> List<T> fillTimeTrendStats(List<T> timeTrendStat, Interval interval, int step, Sort sort, Long fromDt, Long toDt, String pattern, InitFunction<T> initFunction, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        LinkedHashMap<String, TimeTrendStat> maps = new LinkedHashMap<String, TimeTrendStat>(timeTrendStat.size());
        Date fromDate = interval.truncate(new Date(fromDt * 1000L));
        Date toDate = interval.truncate(new Date(toDt * 1000L));
        while (!fromDate.after(toDate)) {
            TimeTrendStat clazzObject = (TimeTrendStat)clazz.newInstance();
            clazzObject.setTs(fromDate);
            clazzObject.setDateStr(DateUtils.format((String)pattern, (Date)fromDate));
            if (initFunction != null) {
                initFunction.init(clazzObject);
            }
            maps.put(clazzObject.getDateStr(), clazzObject);
            fromDate = interval.inc(fromDate, step);
        }
        for (TimeTrendStat trendStat : timeTrendStat) {
            String key = StringUtils.isNotBlank(trendStat.getDateStr()) ? trendStat.getDateStr() : DateUtils.format((String)pattern, (Date)trendStat.getTs());
            TimeTrendStat old = (TimeTrendStat)maps.get(key);
            if (old == null) continue;
            old.mergeValue(trendStat.getValue());
        }
        ArrayList values = new ArrayList(maps.values());
        if (Sort.DESC == sort) {
            Collections.reverse(values);
        }
        return values;
    }

    @SafeVarargs
    public static <R, T extends TimeTrendStat<R>> List<T> fillTimeTrendStats(Interval interval, int step, Sort sort, Long fromDt, Long toDt, String pattern, Class<T> clazz, InitFunction<T> initFunction, List<T> ... timeTrendStat) throws InstantiationException, IllegalAccessException {
        if (timeTrendStat == null || timeTrendStat.length == 0) {
            throw new IllegalArgumentException("timeTrendStat can not be null or empty");
        }
        LinkedHashMap<String, TimeTrendStat> maps = new LinkedHashMap<String, TimeTrendStat>(timeTrendStat.length);
        Date fromDate = interval.truncate(new Date(fromDt * 1000L));
        Date toDate = interval.truncate(new Date(toDt * 1000L));
        while (!fromDate.after(toDate)) {
            TimeTrendStat clazzObject = (TimeTrendStat)clazz.newInstance();
            clazzObject.setTs(fromDate);
            clazzObject.setDateStr(DateUtils.format((String)pattern, (Date)fromDate));
            if (initFunction != null) {
                initFunction.init(clazzObject);
            }
            maps.put(clazzObject.getDateStr(), clazzObject);
            fromDate = interval.inc(fromDate, step);
        }
        List<T>[] listArray = timeTrendStat;
        int n = timeTrendStat.length;
        int n2 = 0;
        while (n2 < n) {
            List<T> trendStat = listArray[n2];
            for (TimeTrendStat stat : trendStat) {
                String key = StringUtils.isNotBlank(stat.getDateStr()) ? stat.getDateStr() : DateUtils.format((String)pattern, (Date)stat.getTs());
                TimeTrendStat old = (TimeTrendStat)maps.get(key);
                if (old == null) continue;
                old.mergeValue(stat.getValue());
            }
            ++n2;
        }
        ArrayList values = new ArrayList(maps.values());
        if (Sort.DESC == sort) {
            Collections.reverse(values);
        }
        return values;
    }

    @FunctionalInterface
    public static interface InitFunction<T> {
        public void init(T var1);
    }

    public static enum Sort {
        DESC,
        ASC;

    }
}

