/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConsumerGroupCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsumerGroupCommand$
implements Logging {
    public static ConsumerGroupCommand$ MODULE$;
    private final String MISSING_COLUMN_VALUE;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConsumerGroupCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConsumerGroupCommand$ consumerGroupCommand$ = this;
        synchronized (consumerGroupCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        block10: {
            ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to list all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
            OptionSet optionSet = opts.options();
            int actions = ((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.listOpt(), opts.describeOpt(), opts.deleteOpt(), opts.resetOffsetsOpt()}))).count((Function1<OptionSpec, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(optionSet.has(x$1)));
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete, --reset-offsets");
            }
            opts.checkArgs();
            try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts);){
                try {
                    if (opts.options().has(opts.listOpt())) {
                        consumerGroupService.listGroups().foreach((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> {
                            Predef$.MODULE$.println(x$1);
                            return BoxedUnit.UNIT;
                        });
                        break block10;
                    }
                    if (opts.options().has(opts.describeOpt())) {
                        consumerGroupService.describeGroups();
                        break block10;
                    }
                    if (opts.options().has(opts.deleteOpt())) {
                        consumerGroupService.deleteGroups();
                        break block10;
                    }
                    if (!opts.options().has(opts.resetOffsetsOpt())) break block10;
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                    if (opts.options().has(opts.exportOpt())) {
                        String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                        Predef$.MODULE$.println(exported);
                        break block10;
                    }
                    this.printOffsetsToReset(offsetsToReset);
                }
                catch (Throwable e) {
                    this.printError(new StringBuilder(47).append("Executing consumer group command failed due to ").append(e.getMessage()).toString(), new Some<Throwable>(e));
                }
            }
        }
    }

    public String MISSING_COLUMN_VALUE() {
        return this.MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        Predef$.MODULE$.println(new StringBuilder(8).append("\nError: ").append(msg).toString());
        e.foreach((Function1<Throwable, Object> & Serializable & scala.Serializable)x$2 -> {
            x$2.printStackTrace();
            return BoxedUnit.UNIT;
        });
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public Long convertTimestamp(String timeString) {
        Date date;
        String string = timeString;
        String string2 = string.split("T")[1].contains("+") || string.split("T")[1].contains("-") || string.split("T")[1].contains("Z") ? string.toString() : new StringBuilder(1).append(string).append("Z").toString();
        String datetime = string2;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(datetime);
        }
        catch (ParseException parseException) {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse(datetime);
        }
        Date date2 = date;
        return Predef$.MODULE$.long2Long(date2.getTime());
    }

    public void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        if (groupAssignmentsToReset.nonEmpty()) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("\n%-30s %-30s %-10s %-15s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{"GROUP", "TOPIC", "PARTITION", "NEW-OFFSET"})));
        }
        groupAssignmentsToReset.withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ConsumerGroupCommand$.$anonfun$printOffsetsToReset$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$4 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$2(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$4(String groupId$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition consumerAssignment = (TopicPartition)tuple2._1();
        OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%-30s %-30s %-10s %-15s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{groupId$1, consumerAssignment.topic(), BoxesRunTime.boxToInteger(consumerAssignment.partition()), BoxesRunTime.boxToLong(offsetAndMetadata.offset())})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$2(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String groupId = (String)tuple2._1();
        Map assignment = (Map)tuple2._2();
        assignment.withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(ConsumerGroupCommand$.$anonfun$printOffsetsToReset$3(check$ifrefutable$2))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$3 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$4(groupId, x$3);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ConsumerGroupCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.MISSING_COLUMN_VALUE = "-";
    }
}

