/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeleteRecordsCommand$ {
    public static DeleteRecordsCommand$ MODULE$;
    private final int EarliestVersion;

    static {
        new DeleteRecordsCommand$();
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JsonValue jsonValue = (JsonValue)some2.value();
                n = BoxesRunTime.unboxToInt(jsonValue.to(DecodeJson$DecodeInt$.MODULE$));
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            int version = n;
            return this.parseJsonData(version, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<Tuple2<TopicPartition, Object>> parseJsonData(int version, JsonValue js) {
        Buffer<Tuple2<TopicPartition, Object>> buffer;
        int n = version;
        switch (n) {
            case 1: {
                Option<JsonValue> option = js.asJsonObject().get("partitions");
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JsonValue partitions = (JsonValue)some.value();
                    buffer = partitions.asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1<JsonObject, Tuple2> & Serializable & scala.Serializable)partitionJs -> {
                        String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition = BoxesRunTime.unboxToInt(partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        long offset = BoxesRunTime.unboxToLong(partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(topic, partition)), BoxesRunTime.boxToLong(offset));
                    }).toBuffer();
                    break;
                }
                throw new AdminOperationException("Missing partitions field");
            }
            default: {
                throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
            }
        }
        return buffer;
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String offsetJsonFile = opts.options().valueOf(opts.offsetJsonFileOpt());
        String offsetJsonString = Utils.readFileAsString(offsetJsonFile);
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(offsetSeq.map((Function1<Tuple2, TopicPartition> & Serializable & scala.Serializable)x0$1 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatePartitions.mkString(",")})));
        }
        Map<TopicPartition, RecordsToDelete> recordsToDelete = JavaConverters$.MODULE$.mapAsJavaMapConverter(((TraversableOnce)offsetSeq.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            Tuple2<TopicPartition, RecordsToDelete> tuple22 = new Tuple2<TopicPartition, RecordsToDelete>(topicPartition, RecordsToDelete.beforeOffset(offset));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        out.println("Executing records delete operation");
        DeleteRecordsResult deleteRecordsResult = adminClient.deleteRecords(recordsToDelete);
        out.println("Records delete operation completed:");
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(deleteRecordsResult.lowWatermarks()).asScala()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
            DeleteRecordsCommand$.$anonfun$execute$3(out, x0$3);
            return BoxedUnit.UNIT;
        });
        adminClient.close();
    }

    private AdminClient createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps(opts.options().valueOf(opts.commandConfigOpt())) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient.create(props);
    }

    public static final /* synthetic */ void $anonfun$execute$3(PrintStream out$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            KafkaFuture partitionResult = (KafkaFuture)tuple2._2();
            try {
                out$1.println(new StringBuilder(27).append("partition: ").append(tp).append("\tlow_watermark: ").append(((DeletedRecords)partitionResult.get()).lowWatermark()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                out$1.println(new StringBuilder(19).append("partition: ").append(tp).append("\terror: ").append(e.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private DeleteRecordsCommand$() {
        MODULE$ = this;
        this.EarliestVersion = 1;
    }
}

