/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.LogDirsCommand;
import kafka.utils.Json$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LogDirsCommand$ {
    public static LogDirsCommand$ MODULE$;

    static {
        new LogDirsCommand$();
    }

    public void main(String[] args) {
        this.describe(args, System.out);
    }

    public void describe(String[] args, PrintStream out) {
        int[] nArray;
        LogDirsCommand.LogDirsCommandOptions opts = new LogDirsCommand.LogDirsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String[] topicList = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])opts.options().valueOf(opts.topicListOpt()).split(","))).filter((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(LogDirsCommand$.$anonfun$describe$1(x$1)));
        Option<String> option = Option$.MODULE$.apply(opts.options().valueOf(opts.brokerListOpt()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String brokerListStr = (String)some.value();
            nArray = (int[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(brokerListStr)).split(','))).filter((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(LogDirsCommand$.$anonfun$describe$2(x$2))))).map((Function1<String, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger(LogDirsCommand$.$anonfun$describe$3(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (None$.MODULE$.equals(option)) {
            nArray = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).map((Function1<Node, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4.id()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        } else {
            throw new MatchError(option);
        }
        int[] brokerList = nArray;
        out.println("Querying brokers for log directories information");
        DescribeLogDirsResult describeLogDirsResult = adminClient.describeLogDirs(JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toSeq()).asJava());
        Map<Integer, Map<String, DescribeLogDirsResponse.LogDirInfo>> logDirInfosByBroker = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(describeLogDirsResult.all().get()).asScala()).mapValues((Function1<java.util.Map, scala.collection.mutable.Map> & Serializable & scala.Serializable)x$5 -> JavaConverters$.MODULE$.mapAsScalaMapConverter(x$5).asScala());
        out.println(new StringBuilder(48).append("Received log directory information from brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).mkString(",")).toString());
        out.println(this.formatAsJson(logDirInfosByBroker, (Set<String>)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])topicList)).toSet()));
        adminClient.close();
    }

    private String formatAsJson(Map<Integer, Map<String, DescribeLogDirsResponse.LogDirInfo>> logDirInfosByBroker, Set<String> topicSet) {
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("brokers"), JavaConverters$.MODULE$.asJavaIterableConverter(logDirInfosByBroker.map((Function1<Tuple2, java.util.Map> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Integer broker = (Integer)tuple2._1();
            Map logDirInfos = (Map)tuple2._2();
            java.util.Map map = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker"), broker), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("logDirs"), JavaConverters$.MODULE$.asJavaIterableConverter(logDirInfos.map((Function1<Tuple2, java.util.Map> & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String logDir = (String)tuple2._1();
                DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                java.util.Map map = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("logDir"), logDir), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("error"), logDirInfo.error.exceptionName()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partitions"), JavaConverters$.MODULE$.asJavaIterableConverter(((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean(LogDirsCommand$.$anonfun$formatAsJson$3(topicSet, x0$3)))).map((Function1<Tuple2, java.util.Map> & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    DescribeLogDirsResponse.ReplicaInfo replicaInfo = (DescribeLogDirsResponse.ReplicaInfo)tuple2._2();
                    java.util.Map map = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partition"), topicPartition.toString()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("size"), BoxesRunTime.boxToLong(replicaInfo.size)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("offsetLag"), BoxesRunTime.boxToLong(replicaInfo.offsetLag)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("isFuture"), BoxesRunTime.boxToBoolean(replicaInfo.isFuture))}))).asJava();
                    return map;
                }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava();
                return map;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava();
            return map;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    private AdminClient createAdminClient(LogDirsCommand.LogDirsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps(opts.options().valueOf(opts.commandConfigOpt())) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        props.putIfAbsent("client.id", "log-dirs-tool");
        return AdminClient.create(props);
    }

    public static final /* synthetic */ boolean $anonfun$describe$1(String x$1) {
        return !x$1.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describe$2(String x$2) {
        return !x$2.isEmpty();
    }

    public static final /* synthetic */ int $anonfun$describe$3(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$formatAsJson$3(Set topicSet$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = topicSet$1.isEmpty() || topicSet$1.contains(topicPartition.topic());
        return bl;
    }

    private LogDirsCommand$() {
        MODULE$ = this;
    }
}

