/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;

public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static PreferredReplicaLeaderElectionCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        int timeout = 30000;
        this.run(args, timeout);
    }

    public void run(String[] args, int timeout) {
        PreferredReplicaLeaderElectionCommand.Command command;
        Option partitionsForPreferredReplicaElection;
        PreferredReplicaLeaderElectionCommand.PreferredReplicaLeaderElectionCommandOptions commandOpts = new PreferredReplicaLeaderElectionCommand.PreferredReplicaLeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOpts, "This tool helps to causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        CommandLineUtils$.MODULE$.checkRequiredArgs(commandOpts.parser(), commandOpts.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[0]));
        if (commandOpts.options().has(commandOpts.bootstrapServerOpt()) == commandOpts.options().has(commandOpts.zkConnectOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(commandOpts.parser(), new StringBuilder(40).append("Exactly one of '").append(commandOpts.bootstrapServerOpt()).append("' or '").append(commandOpts.zkConnectOpt()).append("' must be provided").toString());
        }
        Option option = partitionsForPreferredReplicaElection = commandOpts.options().has(commandOpts.jsonFileOpt()) ? new Some<scala.collection.immutable.Set<TopicPartition>>(this.parsePreferredReplicaElectionData(Utils.readFileAsString(commandOpts.options().valueOf(commandOpts.jsonFileOpt())))) : None$.MODULE$;
        if (commandOpts.options().has(commandOpts.zkConnectOpt())) {
            Predef$.MODULE$.println("Warning: --zookeeper is deprecated and will be removed in a future version of Kafka.");
            Predef$.MODULE$.println("Use --bootstrap-server instead to specify a broker to connect to.");
            command = new PreferredReplicaLeaderElectionCommand.ZkCommand(commandOpts.options().valueOf(commandOpts.zkConnectOpt()), JaasUtils.isZkSecurityEnabled(), timeout);
        } else {
            Properties adminProps = commandOpts.options().has(commandOpts.adminClientConfigOpt()) ? Utils.loadProps(commandOpts.options().valueOf(commandOpts.adminClientConfigOpt())) : new Properties();
            adminProps.setProperty("bootstrap.servers", commandOpts.options().valueOf(commandOpts.bootstrapServerOpt()));
            adminProps.setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger(timeout)).toString());
            command = new PreferredReplicaLeaderElectionCommand.AdminClientCommand(adminProps);
        }
        try (PreferredReplicaLeaderElectionCommand.ZkCommand preferredReplicaElectionCommand = command;){
            preferredReplicaElectionCommand.electPreferredLeaders(partitionsForPreferredReplicaElection);
        }
    }

    public int run$default$2() {
        return 30000;
    }

    public scala.collection.immutable.Set<TopicPartition> parsePreferredReplicaElectionData(String jsonString) {
        scala.collection.immutable.Set<TopicPartition> set;
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Buffer partitions;
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            Option<JsonValue> option2 = js.asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JsonValue partitionsList = (JsonValue)some2.value();
                Iterator partitionsRaw = partitionsList.asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject());
                partitions = partitionsRaw.map((Function1<JsonObject, TopicPartition> & Serializable & scala.Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt(p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Preferred replica election data contains duplicate partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatePartitions.mkString(",")})));
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new AdminOperationException("Preferred replica election data is empty");
                }
                throw new MatchError(option2);
            }
            set = partitions.toSet();
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError(option);
        }
        scala.collection.immutable.Set<TopicPartition> set2 = set;
        return set2;
    }

    public void writePreferredReplicaElectionData(KafkaZkClient zkClient, Set<TopicPartition> partitionsUndergoingPreferredReplicaElection) {
        try {
            zkClient.createPreferredReplicaElection(partitionsUndergoingPreferredReplicaElection.toSet());
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionsUndergoingPreferredReplicaElection.mkString(",")})));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new AdminOperationException(new StringBuilder(60).append("Preferred replica leader election currently in progress for ").append(new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format(Predef$.MODULE$.genericWrapArray(new Object[]{zkClient.getPreferredReplicaElection().mkString(",")}))).toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

