/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$AdminClientTopicService$;
import kafka.admin.TopicCommand$ZookeeperTopicService$;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Whitelist;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.io.StdIn$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class TopicCommand$
implements Logging {
    public static TopicCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TopicCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicCommand$ topicCommand$ = this;
        synchronized (topicCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        opts.checkArgs();
        TopicCommand.ZookeeperTopicService topicService = opts.zkConnect().isDefined() ? TopicCommand$ZookeeperTopicService$.MODULE$.apply(opts.zkConnect()) : TopicCommand$AdminClientTopicService$.MODULE$.apply(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            try {
                if (opts.hasCreateOption()) {
                    topicService.createTopic(opts);
                }
                if (opts.hasAlterOption()) {
                    topicService.alterTopic(opts);
                }
                if (opts.hasListOption()) {
                    topicService.listTopics(opts);
                }
                if (opts.hasDescribeOption()) {
                    topicService.describeTopic(opts);
                }
                if (opts.hasDeleteOption()) {
                    topicService.deleteTopic(opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println(new StringBuilder(38).append("Error while executing topic command : ").append(e.getMessage()).toString());
                this.error((Function0<String> & Serializable & scala.Serializable)() -> Utils.stackTrace(e));
                exitCode = 1;
            }
        }
        finally {
            topicService.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
    }

    public void kafka$admin$TopicCommand$$ensureTopicExists(Seq<String> topics, boolean topicOptWithExists) {
        if (topics.isEmpty() && !topicOptWithExists) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Topics in [").append(topics.mkString(",")).append("] does not exist").toString());
        }
    }

    public boolean kafka$admin$TopicCommand$$ensureTopicExists$default$2() {
        return false;
    }

    public void kafka$admin$TopicCommand$$printPartition(TopicCommand.PartitionDescription tp) {
        String markedForDeletionString = tp.markedForDeletion() && !tp.describeConfigs() ? "\tMarkedForDeletion: true" : "";
        Predef$.MODULE$.print(new StringBuilder(8).append("\tTopic: ").append(tp.topic()).toString());
        Predef$.MODULE$.print(new StringBuilder(12).append("\tPartition: ").append(tp.partition()).toString());
        Predef$.MODULE$.print(new StringBuilder(9).append("\tLeader: ").append(tp.leader().isDefined() ? tp.leader().get() : "none").toString());
        Predef$.MODULE$.print(new StringBuilder(11).append("\tReplicas: ").append(tp.assignedReplicas().mkString(",")).toString());
        Predef$.MODULE$.print(new StringBuilder(6).append("\tIsr: ").append(tp.isr().mkString(",")).toString());
        Predef$.MODULE$.print(markedForDeletionString);
        Predef$.MODULE$.println();
    }

    public Seq<String> kafka$admin$TopicCommand$$doGetTopics(Seq<String> allTopics, Option<String> topicWhitelist, boolean excludeInternalTopics) {
        Seq seq;
        if (topicWhitelist.isDefined()) {
            Whitelist topicsFilter = new Whitelist(topicWhitelist.get());
            seq = (Seq)allTopics.filter((Function1<String, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean(topicsFilter.isTopicAllowed(x$13, excludeInternalTopics)));
        } else {
            seq = (Seq)allTopics.filterNot((Function1<String, Object> & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean(TopicCommand$.$anonfun$doGetTopics$2(excludeInternalTopics, x$14)));
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        block0: {
            Buffer configsToBeAdded = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)opts.topicConfig().getOrElse((Function0<java.util.List> & Serializable & scala.Serializable)() -> Collections.emptyList())).asScala()).map((Function1<String, String[]> & Serializable & scala.Serializable)x$15 -> x$15.split("\\s*=\\s*"), Buffer$.MODULE$.canBuildFrom());
            Predef$.MODULE$.require(configsToBeAdded.forall((Function1<String[], Object> & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean(TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Invalid topic config: all configs to be added must be in the format \"key=val\".");
            Properties props = new Properties();
            configsToBeAdded.foreach((Function1<String[], Object> & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
            LogConfig$.MODULE$.validate(props);
            if (!props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) break block0;
            Predef$.MODULE$.println(new StringBuilder(165).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        void var2_2;
        Buffer configsToBeDeleted = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)opts.configsToDelete().getOrElse((Function0<java.util.List> & Serializable & scala.Serializable)() -> Collections.emptyList())).asScala()).map((Function1<String, String> & Serializable & scala.Serializable)x$16 -> x$16.trim(), Buffer$.MODULE$.canBuildFrom());
        Properties propsToBeDeleted = new Properties();
        configsToBeDeleted.foreach((Function1<String, Object> & Serializable & scala.Serializable)x$17 -> propsToBeDeleted.setProperty((String)x$17, ""));
        LogConfig$.MODULE$.validateNames(propsToBeDeleted);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        void var3_3;
        String[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap ret = new LinkedHashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])partitionList)).size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            int[] brokerList = (int[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])partitionList[i].split(":"))).map((Function1<String, Object> & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger(TopicCommand$.$anonfun$parseReplicaAssignment$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Iterable<Object> duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
            if (duplicateBrokers.nonEmpty()) {
                throw new AdminCommandFailedException(new StringBuilder(59).append("Partition replica lists may not contain duplicate entries: ").append(duplicateBrokers.mkString(",")).toString());
            }
            ret.put(BoxesRunTime.boxToInteger(i), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).toList());
            if (((SeqLike)ret.apply(BoxesRunTime.boxToInteger(i))).size() != ((SeqLike)ret.apply(BoxesRunTime.boxToInteger(0))).size()) {
                throw new AdminOperationException(new StringBuilder(45).append("Partition ").append(i).append(" has different replication factor: ").append(brokerList).toString());
            }
        });
        return var3_3;
    }

    public java.util.Map<Integer, java.util.List<Integer>> asJavaReplicaReassignment(Map<Object, List<Object>> original) {
        return JavaConverters$.MODULE$.mapAsJavaMapConverter(original.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)f -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._1$mcI$sp()), JavaConverters$.MODULE$.seqAsJavaListConverter(((List)f._2()).map((Function1<Object, Integer> & Serializable & scala.Serializable)e -> BoxesRunTime.unboxToInt(e), List$.MODULE$.canBuildFrom())).asJava()), Map$.MODULE$.canBuildFrom())).asJava();
    }

    public void askToProceed() {
        Predef$.MODULE$.println("Are you sure you want to continue? [y/n]");
        if (!StdIn$.MODULE$.readLine().equalsIgnoreCase("y")) {
            Predef$.MODULE$.println("Ending your session");
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
    }

    public static final /* synthetic */ boolean $anonfun$doGetTopics$2(boolean excludeInternalTopics$1, String x$14) {
        return Topic.isInternal(x$14) && excludeInternalTopics$1;
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ int $anonfun$parseReplicaAssignment$2(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
    }

    private TopicCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

