/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.NotificationHandler;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.common.ZkNodeChangeNotificationListener$ChangeNotificationHandler$;
import kafka.common.ZkNodeChangeNotificationListener$ZkStateChangeHandler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$String$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001\u0002\u001c8\u0001qB\u0001\"\u0013\u0001\u0003\u0006\u0004%IA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013%1\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003U\u0011!\u0001\u0007A!b\u0001\n\u0013\u0019\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011\t\u0004!Q1A\u0005\n\rD\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tS\u0002\u0011)\u0019!C\u0005U\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0003q\u0011!a\bA!A!\u0002\u0013\t\b\"B?\u0001\t\u0003q\b\u0002CA\u0007\u0001\u0001\u0007I\u0011\u00026\t\u0013\u0005=\u0001\u00011A\u0005\n\u0005E\u0001bBA\u000f\u0001\u0001\u0006Ka\u001b\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CA\u0001\"!\u0012\u0001A\u0003%\u00111\u0005\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"!\u0019\u0001A\u0003%\u00111\n\u0005\n\u0003G\u0002!\u0019!C\u0005\u0003KB\u0001\"a\u001d\u0001A\u0003%\u0011q\r\u0005\b\u0003k\u0002A\u0011AA\"\u0011\u001d\t9\b\u0001C\u0001\u0003\u0007Bq!!\u001f\u0001\t\u0013\t\u0019\u0005C\u0004\u0002|\u0001!I!! \t\u000f\u0005\r\u0005\u0001\"\u0003\u0002D\u00191\u00111\b\u0001\u0001\u0003{Aa! \u000f\u0005\u0002\u0005}\u0002bBA!9\u0011\u0005\u00111\t\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003K3a!!\u0014\u0001\u0001\u0005=\u0003bCA,C\t\u0005\t\u0015!\u0003U\u00033Ba!`\u0011\u0005\u0002\u0005m\u0003bBA0C\u0011\u0005\u00131I\u0004\b\u0003S\u0003\u0001\u0012AAV\r\u001d\ti\u000b\u0001E\u0001\u0003_Ca! \u0014\u0005\u0002\u0005u\u0006\u0002CA`M\t\u0007I\u0011I*\t\u000f\u0005\u0005g\u0005)A\u0005)\"9\u00111\u0019\u0014\u0005B\u0005\rsaBAc\u0001!\u0005\u0011q\u0019\u0004\b\u0003\u0013\u0004\u0001\u0012AAf\u0011\u0019iH\u0006\"\u0001\u0002T\"A\u0011q\u000b\u0017C\u0002\u0013\u00053\u000bC\u0004\u0002V2\u0002\u000b\u0011\u0002+\t\u000f\u0005]G\u0006\"\u0011\u0002D\u001dI\u0011\u0011\\\u001c\u0002\u0002#\u0005\u00111\u001c\u0004\tm]\n\t\u0011#\u0001\u0002^\"1QP\rC\u0001\u0003?D\u0011\"!93#\u0003%\t!a9\t\u0013\u0005e('%A\u0005\u0002\u0005m(\u0001\t.l\u001d>$Wm\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]2K7\u000f^3oKJT!\u0001O\u001d\u0002\r\r|W.\\8o\u0015\u0005Q\u0014!B6bM.\f7\u0001A\n\u0004\u0001u\u001a\u0005C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g\r\u0005\u0002E\u000f6\tQI\u0003\u0002Gs\u0005)Q\u000f^5mg&\u0011\u0001*\u0012\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$X#A&\u0011\u00051{U\"A'\u000b\u00059K\u0014A\u0001>l\u0013\t\u0001VJA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\n1b]3r\u001d>$WMU8piV\tA\u000b\u0005\u0002V9:\u0011aK\u0017\t\u0003/~j\u0011\u0001\u0017\u0006\u00033n\na\u0001\u0010:p_Rt\u0014BA.@\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m{\u0014\u0001D:fc:{G-\u001a*p_R\u0004\u0013!D:fc:{G-\u001a)sK\u001aL\u00070\u0001\btKFtu\u000eZ3Qe\u00164\u0017\u000e\u001f\u0011\u0002'9|G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0016\u0003\u0011\u0004\"!\u001a4\u000e\u0003]J!aZ\u001c\u0003'9{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0002)9|G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:!\u0003I\u0019\u0007.\u00198hK\u0016C\b/\u001b:bi&|g.T:\u0016\u0003-\u0004\"A\u00107\n\u00055|$\u0001\u0002'p]\u001e\f1c\u00195b]\u001e,W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0002\nA\u0001^5nKV\t\u0011\u000f\u0005\u0002su6\t1O\u0003\u0002Gi*\u0011\u0001(\u001e\u0006\u0003uYT!a\u001e=\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0018aA8sO&\u00111p\u001d\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000e\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0011\u0005\u0015\u0004\u0001\"B%\u000e\u0001\u0004Y\u0005\"\u0002*\u000e\u0001\u0004!\u0006\"\u00021\u000e\u0001\u0004!\u0006\"\u00022\u000e\u0001\u0004!\u0007bB5\u000e!\u0003\u0005\ra\u001b\u0005\b_6\u0001\n\u00111\u0001r\u0003Ia\u0017m\u001d;Fq\u0016\u001cW\u000f^3e\u0007\"\fgnZ3\u0002-1\f7\u000f^#yK\u000e,H/\u001a3DQ\u0006tw-Z0%KF$B!a\u0005\u0002\u001aA\u0019a(!\u0006\n\u0007\u0005]qH\u0001\u0003V]&$\b\u0002CA\u000e\u001f\u0005\u0005\t\u0019A6\u0002\u0007a$\u0013'A\nmCN$X\t_3dkR,Gm\u00115b]\u001e,\u0007%A\u0003rk\u0016,X-\u0006\u0002\u0002$A1\u0011QEA\u001a\u0003oi!!a\n\u000b\t\u0005%\u00121F\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0017\u0003_\tA!\u001e;jY*\u0011\u0011\u0011G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0005\u001d\"a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007cAA\u001d95\t\u0001A\u0001\nDQ\u0006tw-\u001a(pi&4\u0017nY1uS>t7C\u0001\u000f>)\t\t9$A\u0004qe>\u001cWm]:\u0015\u0005\u0005M\u0011AB9vKV,\u0007%\u0001\u0004uQJ,\u0017\rZ\u000b\u0003\u0003\u0017\u00022!!\u000f\"\u0005a\u0019\u0005.\u00198hK\u00163XM\u001c;Qe>\u001cWm]:UQJ,\u0017\rZ\n\u0004C\u0005E\u0003c\u0001#\u0002T%\u0019\u0011QK#\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\rZ\u0001\u0005]\u0006lW-\u0003\u0003\u0002X\u0005MC\u0003BA&\u0003;Ba!a\u0016$\u0001\u0004!\u0016A\u00023p/>\u00148.A\u0004uQJ,\u0017\r\u001a\u0011\u0002\u0011%\u001c8\t\\8tK\u0012,\"!a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WRA!!\u001c\u0002(\u00051\u0011\r^8nS\u000eLA!!\u001d\u0002l\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011\"[:DY>\u001cX\r\u001a\u0011\u0002\t%t\u0017\u000e^\u0001\u0006G2|7/Z\u0001\u0015aJ|7-Z:t\u001d>$\u0018NZ5dCRLwN\\:\u0002'A\u0014xnY3tg:{G/\u001b4jG\u0006$\u0018n\u001c8\u0015\t\u0005M\u0011q\u0010\u0005\u0007\u0003\u0003S\u0002\u0019\u0001+\u0002\u00199|G/\u001b4jG\u0006$\u0018n\u001c8\u0002+\u0005$Gm\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]\u0006Q\u0002/\u001e:hK>\u00137o\u001c7fi\u0016tu\u000e^5gS\u000e\fG/[8ogR1\u00111CAE\u0003\u001bCa!a# \u0001\u0004Y\u0017a\u00018po\"9\u0011qR\u0010A\u0002\u0005E\u0015!\u00048pi&4\u0017nY1uS>t7\u000fE\u0003\u0002\u0014\u0006uEK\u0004\u0003\u0002\u0016\u0006eebA,\u0002\u0018&\t\u0001)C\u0002\u0002\u001c~\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0006\u0005&aA*fc*\u0019\u00111T \u0002\u0019\rD\u0017M\\4f\u001dVl'-\u001a:\u0015\u0007-\f9\u000b\u0003\u0004\u0002X\u0001\u0002\r\u0001V\u0001\u001a\u0007\"\fgnZ3O_RLg-[2bi&|g\u000eS1oI2,'\u000fE\u0002\u0002:\u0019\u0012\u0011d\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feN!a%PAY!\u0011\t\u0019,!/\u000e\u0005\u0005U&bAA\\s\u0005I!p\\8lK\u0016\u0004XM]\u0005\u0005\u0003w\u000b)LA\f[\u001d>$Wm\u00115jY\u0012\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feR\u0011\u00111V\u0001\u0005a\u0006$\b.A\u0003qCRD\u0007%A\tiC:$G.Z\"iS2$7\t[1oO\u0016\fACW6Ti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\bcAA\u001dY\t!\"l[*uCR,7\t[1oO\u0016D\u0015M\u001c3mKJ\u001cB\u0001L\u001f\u0002NB!\u00111WAh\u0013\u0011\t\t.!.\u0003%M#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u000b\u0003\u0003\u000f\fQA\\1nK\u0002\n\u0001$\u00194uKJLe.\u001b;jC2L'0\u001b8h'\u0016\u001c8/[8o\u0003\u0001R6NT8eK\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c'jgR,g.\u001a:\u0011\u0005\u0015\u00144C\u0001\u001a>)\t\tY.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003KT3a[AtW\t\tI\u000f\u0005\u0003\u0002l\u0006UXBAAw\u0015\u0011\ty/!=\u0002\u0013Ut7\r[3dW\u0016$'bAAz\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0018Q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002~*\u001a\u0011/a:")
public class ZkNodeChangeNotificationListener
implements Logging {
    private volatile ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler$module;
    private volatile ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler$module;
    private final KafkaZkClient zkClient;
    private final String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    private final String seqNodePrefix;
    private final NotificationHandler notificationHandler;
    private final long changeExpirationMs;
    private final Time time;
    private long lastExecutedChange;
    private final LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue;
    private final ChangeEventProcessThread thread;
    private final AtomicBoolean isClosed;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$6() {
        return ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6();
    }

    public static long $lessinit$greater$default$5() {
        return ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler() {
        if (this.ChangeNotificationHandler$module == null) {
            this.ChangeNotificationHandler$lzycompute$1();
        }
        return this.ChangeNotificationHandler$module;
    }

    public ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler() {
        if (this.ZkStateChangeHandler$module == null) {
            this.ZkStateChangeHandler$lzycompute$1();
        }
        return this.ZkStateChangeHandler$module;
    }

    private Logger logger$lzycompute() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    }

    private String seqNodePrefix() {
        return this.seqNodePrefix;
    }

    private NotificationHandler notificationHandler() {
        return this.notificationHandler;
    }

    private long changeExpirationMs() {
        return this.changeExpirationMs;
    }

    private Time time() {
        return this.time;
    }

    private long lastExecutedChange() {
        return this.lastExecutedChange;
    }

    private void lastExecutedChange_$eq(long x$1) {
        this.lastExecutedChange = x$1;
    }

    public LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$queue;
    }

    private ChangeEventProcessThread thread() {
        return this.thread;
    }

    private AtomicBoolean isClosed() {
        return this.isClosed;
    }

    public void init() {
        this.zkClient().registerStateChangeHandler(this.ZkStateChangeHandler());
        this.zkClient().registerZNodeChildChangeHandler(this.ChangeNotificationHandler());
        this.kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification();
        this.thread().start();
    }

    public void close() {
        this.isClosed().set(true);
        this.zkClient().unregisterStateChangeHandler(this.ZkStateChangeHandler().name());
        this.zkClient().unregisterZNodeChildChangeHandler(this.ChangeNotificationHandler().path());
        this.kafka$common$ZkNodeChangeNotificationListener$$queue().clear();
        this.thread().shutdown();
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$processNotifications() {
        try {
            Seq notifications = (Seq)this.zkClient().getChildren(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).sorted(Ordering$String$.MODULE$);
            if (notifications.nonEmpty()) {
                this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Processing notification(s) to ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString());
                long now = this.time().milliseconds();
                notifications.foreach((Function1<String, Object> & Serializable & scala.Serializable)notification -> {
                    ZkNodeChangeNotificationListener.$anonfun$processNotifications$2(this, notification);
                    return BoxedUnit.UNIT;
                });
                this.purgeObsoleteNotifications(now, notifications);
            }
        }
        catch (InterruptedException e) {
            if (!this.isClosed().get()) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Error while processing notification change for path = ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString(), (Function0<Throwable>)(Function0<InterruptedException> & Serializable & scala.Serializable)() -> e);
            }
        }
        catch (Exception e) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Error while processing notification change for path = ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString(), (Function0<Throwable>)(Function0<Exception> & Serializable & scala.Serializable)() -> e);
        }
    }

    private void processNotification(String notification) {
        Option<byte[]> data;
        Option<byte[]> data2;
        String changeZnode = new StringBuilder(1).append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).append("/").append(notification).toString();
        Tuple2<Option<byte[]>, Stat> tuple2 = this.zkClient().getDataAndStat(changeZnode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option<byte[]> option = data2 = tuple2._1();
        Option<byte[]> option2 = data = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            byte[] d = (byte[])some.value();
            Try try_ = Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> this.notificationHandler().processNotification(d));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(43).append("error processing change notification ").append(new String(d, StandardCharsets.UTF_8)).append(" from ").append(changeZnode).toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(20).append("read null data from ").append(changeZnode).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification() {
        block0: {
            if (this.isClosed().get() || this.kafka$common$ZkNodeChangeNotificationListener$$queue().peek() != null) break block0;
            this.kafka$common$ZkNodeChangeNotificationListener$$queue().put(new ChangeNotification());
        }
    }

    private void purgeObsoleteNotifications(long now, Seq<String> notifications) {
        ((IterableLike)notifications.sorted(Ordering$String$.MODULE$)).foreach((Function1<String, Object> & Serializable & scala.Serializable)notification -> {
            ZkNodeChangeNotificationListener.$anonfun$purgeObsoleteNotifications$1(this, now, notification);
            return BoxedUnit.UNIT;
        });
    }

    private long changeNumber(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(name.substring(this.seqNodePrefix().length()))).toLong();
    }

    private final void ChangeNotificationHandler$lzycompute$1() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (this.ChangeNotificationHandler$module == null) {
                this.ChangeNotificationHandler$module = new ZkNodeChangeNotificationListener$ChangeNotificationHandler$(this);
            }
        }
    }

    private final void ZkStateChangeHandler$lzycompute$1() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (this.ZkStateChangeHandler$module == null) {
                this.ZkStateChangeHandler$module = new ZkNodeChangeNotificationListener$ZkStateChangeHandler$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processNotifications$2(ZkNodeChangeNotificationListener $this, String notification) {
        block0: {
            long changeId = $this.changeNumber(notification);
            if (changeId <= $this.lastExecutedChange()) break block0;
            $this.processNotification(notification);
            $this.lastExecutedChange_$eq(changeId);
        }
    }

    public static final /* synthetic */ void $anonfun$purgeObsoleteNotifications$1(ZkNodeChangeNotificationListener $this, long now$1, String notification) {
        block1: {
            String notificationNode = new StringBuilder(1).append($this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).append("/").append(notification).toString();
            Tuple2<Option<byte[]>, Stat> tuple2 = $this.zkClient().getDataAndStat(notificationNode);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option<byte[]> data = tuple2._1();
            Stat stat = tuple2._2();
            Tuple2<Option<byte[]>, Stat> tuple22 = new Tuple2<Option<byte[]>, Stat>(data, stat);
            Tuple2<Option<byte[]>, Stat> tuple23 = tuple22;
            Option<byte[]> data2 = tuple23._1();
            Stat stat2 = tuple23._2();
            if (!data2.isDefined() || now$1 - stat2.getCtime() <= $this.changeExpirationMs()) break block1;
            $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Purging change notification ").append(notificationNode).toString());
            $this.zkClient().deletePath(notificationNode, $this.zkClient().deletePath$default$2(), $this.zkClient().deletePath$default$3());
        }
    }

    public ZkNodeChangeNotificationListener(KafkaZkClient zkClient, String seqNodeRoot, String seqNodePrefix, NotificationHandler notificationHandler, long changeExpirationMs, Time time) {
        this.zkClient = zkClient;
        this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot = seqNodeRoot;
        this.seqNodePrefix = seqNodePrefix;
        this.notificationHandler = notificationHandler;
        this.changeExpirationMs = changeExpirationMs;
        this.time = time;
        Logging.$init$(this);
        this.lastExecutedChange = -1L;
        this.kafka$common$ZkNodeChangeNotificationListener$$queue = new LinkedBlockingQueue();
        this.thread = new ChangeEventProcessThread(new StringBuilder(21).append(seqNodeRoot).append("-event-process-thread").toString());
        this.isClosed = new AtomicBoolean(false);
    }

    public class ChangeEventProcessThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer().kafka$common$ZkNodeChangeNotificationListener$$queue().take().process();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeEventProcessThread(String name) {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
            super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public class ChangeNotification {
        public void process() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer().kafka$common$ZkNodeChangeNotificationListener$$processNotifications();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeNotification() {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
        }
    }
}

