/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.ControllerContext;
import kafka.controller.ElectionResult;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import kafka.controller.ReassignedPartitionsContext;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcZI$sp;

public final class Election$ {
    public static Election$ MODULE$;

    static {
        new Election$();
    }

    private ElectionResult leaderForOffline(TopicPartition partition, Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt, boolean uncleanLeaderElectionEnabled, ControllerContext controllerContext) {
        ElectionResult electionResult;
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((JFunction1$mcZI$sp & scala.Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        Option<LeaderIsrAndControllerEpoch> option = leaderIsrAndControllerEpochOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas.toSet(), uncleanLeaderElectionEnabled, controllerContext);
            Option<LeaderAndIsr> newLeaderAndIsrOpt = leaderOpt.map((Function1<Object, LeaderAndIsr> & Serializable & scala.Serializable)leader -> Election$.$anonfun$leaderForOffline$2(isr, controllerContext, partition, leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt(leader)));
            electionResult = new ElectionResult(partition, newLeaderAndIsrOpt, liveReplicas);
        } else if (None$.MODULE$.equals(option)) {
            electionResult = new ElectionResult(partition, None$.MODULE$, liveReplicas);
        } else {
            throw new MatchError(option);
        }
        return electionResult;
    }

    public Seq<ElectionResult> leaderForOffline(ControllerContext controllerContext, Seq<Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object>> partitionsWithUncleanLeaderElectionState) {
        return partitionsWithUncleanLeaderElectionState.map((Function1<Tuple3, ElectionResult> & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            Option leaderIsrAndControllerEpochOpt = (Option)tuple3._2();
            boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean(tuple3._3());
            ElectionResult electionResult = MODULE$.leaderForOffline(partition, leaderIsrAndControllerEpochOpt, uncleanLeaderElectionEnabled, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ElectionResult leaderForReassign(TopicPartition partition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ControllerContext controllerContext) {
        Seq<Object> reassignment = ((ReassignedPartitionsContext)controllerContext.partitionsBeingReassigned().apply(partition)).newReplicas();
        Seq liveReplicas = (Seq)reassignment.filter((JFunction1$mcZI$sp & scala.Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas.toSet());
        Option<LeaderAndIsr> newLeaderAndIsrOpt = leaderOpt.map((Function1<Object, LeaderAndIsr> & Serializable & scala.Serializable)leader -> Election$.$anonfun$leaderForReassign$2(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt(leader)));
        return new ElectionResult(partition, newLeaderAndIsrOpt, reassignment);
    }

    public Seq<ElectionResult> leaderForReassign(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return leaderIsrAndControllerEpochs.map((Function1<Tuple2, ElectionResult> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            ElectionResult electionResult = MODULE$.leaderForReassign(partition, leaderIsrAndControllerEpoch, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ElectionResult leaderForPreferredReplica(TopicPartition partition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ControllerContext controllerContext) {
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((JFunction1$mcZI$sp & scala.Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas.toSet());
        Option<LeaderAndIsr> newLeaderAndIsrOpt = leaderOpt.map((Function1<Object, LeaderAndIsr> & Serializable & scala.Serializable)leader -> Election$.$anonfun$leaderForPreferredReplica$2(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt(leader)));
        return new ElectionResult(partition, newLeaderAndIsrOpt, assignment);
    }

    public Seq<ElectionResult> leaderForPreferredReplica(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return leaderIsrAndControllerEpochs.map((Function1<Tuple2, ElectionResult> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            ElectionResult electionResult = MODULE$.leaderForPreferredReplica(partition, leaderIsrAndControllerEpoch, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ElectionResult leaderForControlledShutdown(TopicPartition partition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, Set<Object> shuttingDownBrokerIds, ControllerContext controllerContext) {
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveOrShuttingDownReplicas = (Seq)assignment.filter((JFunction1$mcZI$sp & scala.Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, true));
        List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveOrShuttingDownReplicas.toSet(), shuttingDownBrokerIds);
        List newIsr = (List)isr.filter((JFunction1$mcZI$sp & scala.Serializable)replica -> !shuttingDownBrokerIds.contains(BoxesRunTime.boxToInteger(replica)));
        Option<LeaderAndIsr> newLeaderAndIsrOpt = leaderOpt.map((Function1<Object, LeaderAndIsr> & Serializable & scala.Serializable)leader -> Election$.$anonfun$leaderForControlledShutdown$3(leaderIsrAndControllerEpoch, newIsr, BoxesRunTime.unboxToInt(leader)));
        return new ElectionResult(partition, newLeaderAndIsrOpt, liveOrShuttingDownReplicas);
    }

    public Seq<ElectionResult> leaderForControlledShutdown(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        Set shuttingDownBrokerIds = controllerContext.shuttingDownBrokerIds().toSet();
        return leaderIsrAndControllerEpochs.map((Function1<Tuple2, ElectionResult> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            ElectionResult electionResult = MODULE$.leaderForControlledShutdown(partition, leaderIsrAndControllerEpoch, shuttingDownBrokerIds, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$2(List isr$1, ControllerContext controllerContext$1, TopicPartition partition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, int leader) {
        List newIsr = isr$1.contains(BoxesRunTime.boxToInteger(leader)) ? (List)isr$1.filter((JFunction1$mcZI$sp & scala.Serializable)replica -> controllerContext$1.isReplicaOnline(replica, partition$1, controllerContext$1.isReplicaOnline$default$3())) : List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{leader}));
        return leaderIsrAndControllerEpoch$1.leaderAndIsr().newLeaderAndIsr(leader, newIsr);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForReassign$2(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$2, int leader) {
        return leaderIsrAndControllerEpoch$2.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForPreferredReplica$2(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$3, int leader) {
        return leaderIsrAndControllerEpoch$3.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForControlledShutdown$3(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$4, List newIsr$1, int leader) {
        return leaderIsrAndControllerEpoch$4.leaderAndIsr().newLeaderAndIsr(leader, newIsr$1);
    }

    private Election$() {
        MODULE$ = this;
    }
}

