/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcZI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\t\u0013\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!A\u0004A!A!\u0002\u0013I\u0004\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002#\u0001\u0005\u0004%I!\u0012\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002$\t\u000b5\u0003A\u0011\t(\t\u000b!\u0004A\u0011B5\t\u000b9\u0004A\u0011B8\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA!\u0001\u0011%\u00111\t\u0005\b\u0003#\u0002A\u0011BA*\u0011\u001d\tY\u0006\u0001C\u0005\u0003;\u0012QCW6SKBd\u0017nY1Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0014)\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012!B;uS2\u001c\u0018BA\u0011\u001f\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0015\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001&\n\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\"!G\u0016\n\u00051\u0012\"!E*uCR,7\t[1oO\u0016dunZ4fe\u0006\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005ey\u0013B\u0001\u0019\u0013\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\tu.\u001cE.[3oiB\u00111GN\u0007\u0002i)\u0011Q\u0007F\u0001\u0003u.L!a\u000e\u001b\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003q\u0019wN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\"!\u0007\u001e\n\u0005m\u0012\"\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u0001\u0007y%t\u0017\u000e\u001e \u0015\ryz\u0004)\u0011\"D!\tI\u0002\u0001C\u0003#\r\u0001\u00071\u0005C\u0003*\r\u0001\u0007!\u0006C\u0003.\r\u0001\u0007a\u0006C\u00032\r\u0001\u0007!\u0007C\u00039\r\u0001\u0007\u0011(\u0001\u0007d_:$(o\u001c7mKJLE-F\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\rIe\u000e^\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0004\u001fJ\u001b\u0007CA$Q\u0013\t\t\u0006J\u0001\u0003V]&$\b\"B*\n\u0001\u0004!\u0016\u0001\u0003:fa2L7-Y:\u0011\u0007Uk\u0006M\u0004\u0002W7:\u0011qKW\u0007\u00021*\u0011\u0011LF\u0001\u0007yI|w\u000e\u001e \n\u0003%K!\u0001\u0018%\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\u0004'\u0016\f(B\u0001/I!\tI\u0012-\u0003\u0002c%\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\")A-\u0003a\u0001K\u0006YA/\u0019:hKR\u001cF/\u0019;f!\tIb-\u0003\u0002h%\ta!+\u001a9mS\u000e\f7\u000b^1uK\u0006!Bm\u001c%b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$Ba\u00146m[\")1N\u0003a\u0001\r\u0006I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\u0006'*\u0001\r\u0001\u0016\u0005\u0006I*\u0001\r!Z\u0001\u0016e\u0016lwN^3SKBd\u0017nY1t\rJ|W.S:s)\u0015\u0001\u0018QBA\b!\u0015\tX\u000f_A\u0004\u001d\t\u00118\u000f\u0005\u0002X\u0011&\u0011A\u000fS\u0001\u0007!J,G-\u001a4\n\u0005Y<(aA'ba*\u0011A\u000f\u0013\t\u0004s\u0006\rQ\"\u0001>\u000b\u0005md\u0018AB2p[6|gN\u0003\u0002\u0016{*\u0011ap`\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0011aA8sO&\u0019\u0011Q\u0001>\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019\u0011$!\u0003\n\u0007\u0005-!CA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\u0006W.\u0001\rA\u0012\u0005\b\u0003#Y\u0001\u0019AA\n\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004+vC\u0018a\u00063p%\u0016lwN^3SKBd\u0017nY1t\rJ|W.S:s)\u0019\tI\"a\n\u0002*AAq)a\u0007q\u0003'\ty\"C\u0002\u0002\u001e!\u0013a\u0001V;qY\u0016\u001c\u0004#B9vq\u0006\u0005\u0002cA+\u0002$%\u0019\u0011QE0\u0003\u0013\u0015C8-\u001a9uS>t\u0007\"B6\r\u0001\u00041\u0005bBA\t\u0019\u0001\u0007\u00111C\u0001\u001eO\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000b^1uKN4%o\\7[WR!\u0011qFA !%9\u00151DA\u0019\u0003'\ty\u0002E\u0003rkb\f\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004F\u0001\u0004CBL\u0017\u0002BA\u001f\u0003o\u0011A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJDq!!\u0005\u000e\u0001\u0004\t\u0019\"A\fm_\u001e\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]RIq*!\u0012\u0002H\u0005-\u0013q\n\u0005\u0006W:\u0001\rA\u0012\u0005\u0007\u0003\u0013r\u0001\u0019\u0001=\u0002\u0013A\f'\u000f^5uS>t\u0007BBA'\u001d\u0001\u0007Q-A\u0005dkJ\u00148\u000b^1uK\")AM\u0004a\u0001K\u0006!Bn\\4J]Z\fG.\u001b3Ue\u0006t7/\u001b;j_:$RaTA+\u00033Ba!a\u0016\u0010\u0001\u0004\u0001\u0017a\u0002:fa2L7-\u0019\u0005\u0006I>\u0001\r!Z\u0001\u0015Y><g)Y5mK\u0012\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\u0013=\u000by&!\u0019\u0002d\u0005\u0015\u0004BBA,!\u0001\u0007\u0001\r\u0003\u0004\u0002NA\u0001\r!\u001a\u0005\u0006IB\u0001\r!\u001a\u0005\b\u0003O\u0002\u0002\u0019AA5\u0003\u0005!\bcA+\u0002l%\u0019\u0011QN0\u0003\u0013QC'o\\<bE2,\u0007")
public class ZkReplicaStateMachine
extends ReplicaStateMachine {
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;

    private int controllerId() {
        return this.controllerId;
    }

    @Override
    public void handleStateChanges(Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        if (replicas.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                replicas.groupBy((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.replica())).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                    ZkReplicaStateMachine.$anonfun$handleStateChanges$2(this, targetState, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Controller moved to another broker when moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0<ControllerMovedException> & Serializable & scala.Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error while moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    private void doHandleStateChanges(int replicaId, Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        replicas.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
            this.controllerContext.putReplicaStateIfNotExists(replica, NonExistentReplica$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>> tuple2 = this.controllerContext.checkValidReplicaStateChange(replicas, targetState);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<PartitionAndReplica> validReplicas = tuple2._1();
        Seq<PartitionAndReplica> invalidReplicas = tuple2._2();
        Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>> tuple22 = new Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>>(validReplicas, invalidReplicas);
        Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>> tuple23 = tuple22;
        Seq<PartitionAndReplica> validReplicas2 = tuple23._1();
        Seq<PartitionAndReplica> invalidReplicas2 = tuple23._2();
        invalidReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
            this.logInvalidTransition(replica, targetState);
            return BoxedUnit.UNIT;
        });
        ReplicaState replicaState = targetState;
        if (NewReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$3(this, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OnlineReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$4(this, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OfflineReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), replica.topicPartition(), false);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple24 = validReplicas2.partition((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean(ZkReplicaStateMachine.$anonfun$doHandleStateChanges$6(this, replica)));
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            Seq replicasWithLeadershipInfo = (Seq)tuple24._1();
            Seq replicasWithoutLeadershipInfo = (Seq)tuple24._2();
            Tuple2<Seq, Seq> tuple25 = new Tuple2<Seq, Seq>(replicasWithLeadershipInfo, replicasWithoutLeadershipInfo);
            Tuple2<Seq, Seq> tuple26 = tuple25;
            Seq replicasWithLeadershipInfo2 = tuple26._1();
            Seq replicasWithoutLeadershipInfo2 = tuple26._2();
            Map<TopicPartition, LeaderIsrAndControllerEpoch> updatedLeaderIsrAndControllerEpochs = this.removeReplicasFromIsr(replicaId, replicasWithLeadershipInfo2.map((Function1<PartitionAndReplica, TopicPartition> & Serializable & scala.Serializable)x$5 -> x$5.topicPartition(), Seq$.MODULE$.canBuildFrom()));
            updatedLeaderIsrAndControllerEpochs.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$8(this, replicaId, x0$1);
                return BoxedUnit.UNIT;
            });
            replicasWithoutLeadershipInfo2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$10(this, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$11(this, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$12(this, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$13(this, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NonExistentReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1<PartitionAndReplica, Object> & Serializable & scala.Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$14(this, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(replicaState);
        }
    }

    private Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        Map results = Predef$.MODULE$.Map().empty();
        Seq<TopicPartition> remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple3 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Map<TopicPartition, LeaderIsrAndControllerEpoch> successfulRemovals = tuple3._1();
            Seq<TopicPartition> removalsToRetry = tuple3._2();
            Map<TopicPartition, Exception> failedRemovals = tuple3._3();
            Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple32 = new Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>>(successfulRemovals, removalsToRetry, failedRemovals);
            Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple33 = tuple32;
            Map<TopicPartition, LeaderIsrAndControllerEpoch> successfulRemovals2 = tuple33._1();
            Seq<TopicPartition> removalsToRetry2 = tuple33._2();
            Map<TopicPartition, Exception> failedRemovals2 = tuple33._3();
            results = results.$plus$plus(successfulRemovals2);
            remaining = removalsToRetry2;
            failedRemovals2.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                ZkReplicaStateMachine.$anonfun$removeReplicasFromIsr$1(this, replicaId, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return results;
    }

    private Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple3 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Map<TopicPartition, LeaderAndIsr> leaderAndIsrs = tuple3._1();
        Seq<TopicPartition> partitionsWithNoLeaderAndIsrInZk = tuple3._2();
        Map<TopicPartition, Exception> failedStateReads = tuple3._3();
        Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple32 = new Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>>(leaderAndIsrs, partitionsWithNoLeaderAndIsrInZk, failedStateReads);
        Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple33 = tuple32;
        Map<TopicPartition, LeaderAndIsr> leaderAndIsrs2 = tuple33._1();
        Seq<TopicPartition> partitionsWithNoLeaderAndIsrInZk2 = tuple33._2();
        Map<TopicPartition, Exception> failedStateReads2 = tuple33._3();
        Tuple2 tuple2 = leaderAndIsrs2.partition((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$1(replicaId, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map leaderAndIsrsWithReplica = (Map)tuple2._1();
        Map leaderAndIsrsWithoutReplica = (Map)tuple2._2();
        Tuple2<Map, Map> tuple22 = new Tuple2<Map, Map>(leaderAndIsrsWithReplica, leaderAndIsrsWithoutReplica);
        Tuple2<Map, Map> tuple23 = tuple22;
        Map leaderAndIsrsWithReplica2 = tuple23._1();
        Map leaderAndIsrsWithoutReplica2 = tuple23._2();
        Map<TopicPartition, LeaderAndIsr> adjustedLeaderAndIsrs = leaderAndIsrsWithReplica2.mapValues((Function1<LeaderAndIsr, LeaderAndIsr> & Serializable & scala.Serializable)leaderAndIsr -> {
            int newLeader = replicaId == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
            List adjustedIsr = leaderAndIsr.isr().size() == 1 ? leaderAndIsr.isr() : (List)leaderAndIsr.isr().filter((JFunction1$mcZI$sp & scala.Serializable)x$11 -> x$11 != replicaId);
            return leaderAndIsr.newLeaderAndIsr(newLeader, adjustedIsr);
        });
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr(adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError(updateLeaderAndIsrResult);
        }
        Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
        Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple34 = new Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>>(successfulUpdates, updatesToRetry, failedUpdates);
        Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> tuple35 = tuple34;
        Map<TopicPartition, LeaderAndIsr> successfulUpdates2 = tuple35._1();
        Seq<TopicPartition> updatesToRetry2 = tuple35._2();
        Map<TopicPartition, Exception> failedUpdates2 = tuple35._3();
        Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = ((TraversableOnce)partitionsWithNoLeaderAndIsrInZk2.flatMap((Function1<TopicPartition, Iterable> & Serializable & scala.Serializable)partition -> {
            Iterable<Serializable> iterable;
            if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Failed to change state of replica ").append(replicaId).append(" for partition ").append(partition).append(" since the leader and isr path in zookeeper is empty").toString());
                iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), exception)));
            } else {
                iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map leaderIsrAndControllerEpochs = leaderAndIsrsWithoutReplica2.$plus$plus(successfulUpdates2).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            $this.controllerContext.partitionLeadershipInfo().put(partition, leaderIsrAndControllerEpoch);
            Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), leaderIsrAndControllerEpoch);
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return new Tuple3<Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, Map<TopicPartition, Exception>>(leaderIsrAndControllerEpochs, updatesToRetry2, failedStateReads2.$plus$plus(exceptionsForPartitionsWithNoLeaderAndIsrInZk).$plus$plus(failedUpdates2));
    }

    private Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> seq;
        GenMap leaderAndIsrs = Map$.MODULE$.empty();
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        GenMap failed = Map$.MODULE$.empty();
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            partitions.foreach(arg_0 -> ZkReplicaStateMachine.$anonfun$getTopicPartitionStatesFromZk$1((scala.collection.mutable.Map)failed, e, arg_0));
            return new Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>>(leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), partitionsWithNoLeaderAndIsrInZk, failed.toMap(Predef$.MODULE$.$conforms()));
        }
        Seq<GetDataResponse> getDataResponses = seq;
        getDataResponses.foreach(arg_0 -> ZkReplicaStateMachine.$anonfun$getTopicPartitionStatesFromZk$2(this, partitionsWithNoLeaderAndIsrInZk, (scala.collection.mutable.Map)failed, (scala.collection.mutable.Map)leaderAndIsrs, arg_0));
        return new Tuple3<Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, Map<TopicPartition, Exception>>(leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), partitionsWithNoLeaderAndIsrInZk, failed.toMap(Predef$.MODULE$.$conforms()));
    }

    private void logSuccessfulTransition(int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Changed state of replica ").append(replicaId).append(" for partition ").append(partition).append(" from ").append(currState).append(" to ").append(targetState).toString());
    }

    private void logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        ReplicaState currState = this.controllerContext.replicaState(replica);
        IllegalStateException e = new IllegalStateException(new StringBuilder(27).append("Replica ").append(replica).append(" should be in the ").append(targetState.validPreviousStates().mkString(",")).append(" ").append(new StringBuilder(55).append("states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(replica, currState, targetState, e);
    }

    private void logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" initiated state change of replica ").append(replica.replica()).append(" ").append(new StringBuilder(31).append("for partition ").append(replica.topicPartition()).append(" from ").append(currState).append(" to ").append(targetState).append(" failed").toString()).toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$2(ZkReplicaStateMachine $this, ReplicaState targetState$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int replicaId = tuple2._1$mcI$sp();
        Seq replicas = (Seq)tuple2._2();
        $this.doHandleStateChanges(replicaId, replicas, targetState$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkReplicaStateMachine $this, int replicaId$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        Option option = $this.controllerContext.partitionLeadershipInfo().get(partition);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
            if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId$1) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Replica ").append(replicaId$1).append(" for partition ").append(partition).append(" cannot be moved to NewReplica state as it is being requested to become leader").toString());
                $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(replica.topicPartition()), true);
                $this.logSuccessfulTransition(replicaId$1, partition, currentState, NewReplica$.MODULE$);
                $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            $this.logSuccessfulTransition(replicaId$1, partition, currentState, NewReplica$.MODULE$);
            $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$4(ZkReplicaStateMachine $this, int replicaId$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        ReplicaState replicaState = currentState;
        if (NewReplica$.MODULE$.equals(replicaState)) {
            BoxedUnit boxedUnit;
            Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
            if (!assignment.contains(BoxesRunTime.boxToInteger(replicaId$1))) {
                $this.controllerContext.updatePartitionReplicaAssignment(partition, assignment.$colon$plus(BoxesRunTime.boxToInteger(replicaId$1), Seq$.MODULE$.canBuildFrom()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            Option option = $this.controllerContext.partitionLeadershipInfo().get(partition);
            if (option instanceof Some) {
                Some some = (Some)option;
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), false);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        $this.logSuccessfulTransition(replicaId$1, partition, currentState, OnlineReplica$.MODULE$);
        $this.controllerContext.putReplicaState(replica, OnlineReplica$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$6(ZkReplicaStateMachine $this, PartitionAndReplica replica) {
        return $this.controllerContext.partitionLeadershipInfo().contains(replica.topicPartition());
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$8(ZkReplicaStateMachine $this, int replicaId$1, Tuple2 x0$1) {
        TopicPartition partition;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                Seq recipients = (Seq)$this.controllerContext.partitionReplicaAssignment(partition).filterNot((JFunction1$mcZI$sp & scala.Serializable)x$6 -> x$6 == replicaId$1);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers(recipients, partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), false);
            }
        } else {
            throw new MatchError(tuple2);
        }
        PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$1);
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        $this.logSuccessfulTransition(replicaId$1, partition, currentState, OfflineReplica$.MODULE$);
        $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$10(ZkReplicaStateMachine $this, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        $this.logSuccessfulTransition(replicaId$1, replica.topicPartition(), currentState, OfflineReplica$.MODULE$);
        $this.controllerBrokerRequestBatch.addUpdateMetadataRequestForBrokers($this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{replica.topicPartition()})));
        $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$11(ZkReplicaStateMachine $this, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        $this.logSuccessfulTransition(replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionStarted$.MODULE$);
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionStarted$.MODULE$);
        $this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), replica.topicPartition(), true);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$12(ZkReplicaStateMachine $this, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        $this.logSuccessfulTransition(replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionIneligible$.MODULE$);
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$13(ZkReplicaStateMachine $this, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        $this.logSuccessfulTransition(replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionSuccessful$.MODULE$);
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionSuccessful$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$14(ZkReplicaStateMachine $this, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        Seq<Object> currentAssignedReplicas = $this.controllerContext.partitionReplicaAssignment(replica.topicPartition());
        $this.controllerContext.updatePartitionReplicaAssignment(replica.topicPartition(), (Seq)currentAssignedReplicas.filterNot((JFunction1$mcZI$sp & scala.Serializable)x$7 -> x$7 == replica.replica()));
        $this.logSuccessfulTransition(replicaId$1, replica.topicPartition(), currentState, NonExistentReplica$.MODULE$);
        $this.controllerContext.removeReplicaState(replica);
    }

    public static final /* synthetic */ void $anonfun$removeReplicasFromIsr$1(ZkReplicaStateMachine $this, int replicaId$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Exception e = (Exception)tuple2._2();
        PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$2);
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$1(int replicaId$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        boolean bl = leaderAndIsr.isr().contains(BoxesRunTime.boxToInteger(replicaId$3));
        return bl;
    }

    public static final /* synthetic */ Option $anonfun$getTopicPartitionStatesFromZk$1(scala.collection.mutable.Map failed$1, Exception e$3, TopicPartition partition) {
        return failed$1.put(partition, e$3);
    }

    public static final /* synthetic */ Object $anonfun$getTopicPartitionStatesFromZk$2(ZkReplicaStateMachine $this, Buffer partitionsWithNoLeaderAndIsrInZk$1, scala.collection.mutable.Map failed$1, scala.collection.mutable.Map leaderAndIsrs$1, GetDataResponse getDataResponse) {
        Object object;
        TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
        KeeperException.Code code = getDataResponse.resultCode();
        KeeperException.Code code2 = KeeperException.Code.OK;
        if (!(code != null ? !code.equals(code2) : code2 != null)) {
            Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
            if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                object = partitionsWithNoLeaderAndIsrInZk$1.$plus$eq(partition);
            } else {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = leaderIsrAndControllerEpochOpt.get();
                if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(64).append("Leader and isr path written by another controller. This probably").append(new StringBuilder(81).append("means the current controller with epoch ").append($this.controllerContext.epoch()).append(" went through a soft failure and another ").toString()).append(new StringBuilder(76).append("controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(". Aborting state change by this controller").toString()).toString());
                    object = failed$1.put(partition, exception);
                } else {
                    object = leaderAndIsrs$1.put(partition, leaderIsrAndControllerEpoch.leaderAndIsr());
                }
            }
        } else {
            KeeperException.Code code3 = getDataResponse.resultCode();
            KeeperException.Code code4 = KeeperException.Code.NONODE;
            object = !(code3 != null ? !code3.equals(code4) : code4 != null) ? partitionsWithNoLeaderAndIsrInZk$1.$plus$eq(partition) : failed$1.put(partition, getDataResponse.resultException().get());
        }
        return object;
    }

    public ZkReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(36).append("[ReplicaStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }
}

