/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering$Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction1$mcZJ$sp;

@ScalaSignature(bytes="\u0006\u0001\r\u0005u!B0a\u0011\u0003)g!B4a\u0011\u0003A\u0007\"B8\u0002\t\u0003\u0001\bbB9\u0002\u0005\u0004%IA\u001d\u0005\u0007m\u0006\u0001\u000b\u0011B:\t\u000f]\f!\u0019!C\u0005q\"9\u00111A\u0001!\u0002\u0013I\b\u0002CA\u0003\u0003\t\u0007I\u0011\u0002=\t\u000f\u0005\u001d\u0011\u0001)A\u0005s\"A\u0011\u0011B\u0001C\u0002\u0013%\u0001\u0010C\u0004\u0002\f\u0005\u0001\u000b\u0011B=\t\u0011\u00055\u0011A1A\u0005\naDq!a\u0004\u0002A\u0003%\u0011\u0010\u0003\u0005\u0002\u0012\u0005\u0011\r\u0011\"\u0003y\u0011\u001d\t\u0019\"\u0001Q\u0001\neD\u0001\"!\u0006\u0002\u0005\u0004%I\u0001\u001f\u0005\b\u0003/\t\u0001\u0015!\u0003z\u0011!\tI\"\u0001b\u0001\n\u0013A\bbBA\u000e\u0003\u0001\u0006I!\u001f\u0005\t\u0003;\t!\u0019!C\u0005q\"9\u0011qD\u0001!\u0002\u0013I\b\u0002CA\u0011\u0003\t\u0007I\u0011\u0002=\t\u000f\u0005\r\u0012\u0001)A\u0005s\"A\u0011QE\u0001C\u0002\u0013%\u0001\u0010C\u0004\u0002(\u0005\u0001\u000b\u0011B=\t\u0011\u0005%\u0012A1A\u0005\naDq!a\u000b\u0002A\u0003%\u0011\u0010C\u0005\u0002.\u0005\u0011\r\u0011\"\u0003\u00020!A\u0011qG\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002:\u0005\u0011\r\u0011\"\u0003\u00020!A\u00111H\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002>\u0005\u0011\r\u0011\"\u0003\u00020!A\u0011qH\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002B\u0005\u0011\r\u0011\"\u0001\u0002D!A\u00111M\u0001!\u0002\u0013\t)\u0005C\u0005\u0002f\u0005\u0011\r\u0011\"\u0001\u0002D!A\u0011qM\u0001!\u0002\u0013\t)\u0005C\u0004\u0002j\u0005!\t!a\u001b\t\u000f\u0005m\u0015\u0001\"\u0003\u0002\u001e\"9\u0011\u0011Y\u0001\u0005\n\u0005\r\u0007\u0002CAg\u0003\u0011\u0005\u0001-a4\t\u0011\u0005m\u0017\u0001\"\u0001a\u0003;Dq!!:\u0002\t\u0013\t9\u000fC\u0005\u0002v\u0006\t\n\u0011\"\u0003\u0002x\"I!QB\u0001\u0012\u0002\u0013\u0005!q\u0002\u0004\u0006O\u0002\u0004!1\u0003\u0005\u000b\u0005Ci#Q1A\u0005\u0002\t\r\u0002B\u0003B\u0017[\t\u0005\t\u0015!\u0003\u0003&!Q!qF\u0017\u0003\u0002\u0004%\tA!\r\t\u0015\tMRF!a\u0001\n\u0003\u0011)\u0004\u0003\u0006\u0003<5\u0012\t\u0011)Q\u0005\u0003\u001fC!B!\u0012.\u0005\u000b\u0007I\u0011AA\u0018\u0011)\u00119%\fB\u0001B\u0003%\u0011\u0011\u0007\u0005\u0007_6\"\tA!\u0013\t\u0013\tMSF1A\u0005\n\tU\u0003\u0002\u0003B,[\u0001\u0006I!a+\t\u0013\teS\u00061A\u0005\n\tm\u0003\"\u0003B/[\u0001\u0007I\u0011\u0002B0\u0011!\u0011\u0019'\fQ!\n\u0005m\u0006\"\u0003B3[\u0001\u0007I\u0011\u0002B.\u0011%\u00119'\fa\u0001\n\u0013\u0011I\u0007\u0003\u0005\u0003n5\u0002\u000b\u0015BA^\u0011%\u0011y'\fb\u0001\n\u0013\u0011\t\b\u0003\u0005\u0003\u00066\u0002\u000b\u0011\u0002B:\u0011%\u00119)\fb\u0001\n\u0013\u0011\t\b\u0003\u0005\u0003\n6\u0002\u000b\u0011\u0002B:\u0011\u001d\u0011Y)\fC\u0001\u0005\u001bCqA!).\t\u0003\u0011\u0019\u000bC\u0004\u0003*6\"\tAa+\t\u000f\t=V\u0006\"\u0001\u0003\\!9!\u0011W\u0017\u0005\u0002\tM\u0006b\u0002B`[\u0011\u0005!\u0011\u0019\u0005\b\u0005\u0007lC\u0011\u0002Bc\u0011!\u0011y-\fC\u0001A\nE\u0007b\u0002Bl[\u0011%!\u0011\u001c\u0005\b\u0005GlC\u0011\u0001Bs\u0011\u001d\u0011I/\fC\u0001\u0005WDqA!>.\t\u0003\u00119\u0010C\u0004\u0004\b5\"\ta!\u0003\t\u000f\r=Q\u0006\"\u0001\u0004\u0012!91qC\u0017\u0005\u0002\re\u0001bBB\u0010[\u0011\u00051\u0011\u0005\u0005\b\u0007GiC\u0011\u0001BV\u0011\u001d\u0019)#\fC\u0001\u0005WCqaa\n.\t\u0013\u0019I\u0003C\u0004\u000425\"\taa\r\t\u000f\r]R\u0006\"\u0003\u0004:!91qI\u0017\u0005\n\r%\u0003bBB'[\u0011\u00051\u0011\u0005\u0005\b\u0007\u001fjC\u0011AB)\u0011\u001d\u0019i&\fC\u0001\u0007?Bq!a7.\t\u0003\u0019\u0019\u0007C\u0004\u0004p5\"Ia!\u001d\t\u000f\rUT\u0006\"\u0003\u0004r!9\u0011QZ\u0017\u0005\n\r]\u0014\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002bE\u0006\u0019An\\4\u000b\u0003\r\fQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002g\u00035\t\u0001M\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u0003%\u0004\"A[7\u000e\u0003-T\u0011\u0001\\\u0001\u0006g\u000e\fG.Y\u0005\u0003].\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001f\u0003]\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|GOV3sg&|g.F\u0001t!\tQG/\u0003\u0002vW\n)1\u000b[8si\u0006A\u0002K]8ek\u000e,'o\u00158baNDw\u000e\u001e,feNLwN\u001c\u0011\u0002\u0019Y+'o]5p]\u001aKW\r\u001c3\u0016\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\t1\fgn\u001a\u0006\u0002}\u0006!!.\u0019<b\u0013\r\t\ta\u001f\u0002\u0007'R\u0014\u0018N\\4\u0002\u001bY+'o]5p]\u001aKW\r\u001c3!\u0003!\u0019%o\u0019$jK2$\u0017!C\"sG\u001aKW\r\u001c3!\u0003=\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0017\u0001\u0005)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3!\u0003Ea\u0015m\u001d;TKF,XM\\2f\r&,G\u000eZ\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007%\u0001\nQe>$WoY3s\u000bB|7\r\u001b$jK2$\u0017a\u0005)s_\u0012,8-\u001a:Fa>\u001c\u0007NR5fY\u0012\u0004\u0013a\u0004'bgR|eMZ:fi\u001aKW\r\u001c3\u0002!1\u000b7\u000f^(gMN,GOR5fY\u0012\u0004\u0013\u0001E(gMN,G\u000fR3mi\u00064\u0015.\u001a7e\u0003EyeMZ:fi\u0012+G\u000e^1GS\u0016dG\rI\u0001\u000f)&lWm\u001d;b[B4\u0015.\u001a7e\u0003=!\u0016.\\3ti\u0006l\u0007OR5fY\u0012\u0004\u0013\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG-A\u000bQe>$WoY3s\u000b:$(/[3t\r&,G\u000e\u001a\u0011\u0002+\r{wN\u001d3j]\u0006$xN]#q_\u000eDg)[3mI\u000612i\\8sI&t\u0017\r^8s\u000bB|7\r\u001b$jK2$\u0007%\u0001\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG-A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\rI\u0001\u000e-\u0016\u00148/[8o\u001f\u001a47/\u001a;\u0016\u0005\u0005E\u0002c\u00016\u00024%\u0019\u0011QG6\u0003\u0007%sG/\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\u0002\u0013\r\u00138m\u00144gg\u0016$\u0018AC\"sG>3gm]3uA\u0005)\u0002K]8ek\u000e,'/\u00128ue&,7o\u00144gg\u0016$\u0018A\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:PM\u001a\u001cX\r\u001e\u0011\u00027A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$XI\u001c;ssN\u001b\u0007.Z7b+\t\t)\u0005\u0005\u0003\u0002H\u0005}SBAA%\u0015\u0011\tY%!\u0014\u0002\u000bQL\b/Z:\u000b\t\u0005=\u0013\u0011K\u0001\taJ|Go\\2pY*!\u00111KA+\u0003\u0019\u0019w.\\7p]*\u00191-a\u0016\u000b\t\u0005e\u00131L\u0001\u0007CB\f7\r[3\u000b\u0005\u0005u\u0013aA8sO&!\u0011\u0011MA%\u0005\u0019\u00196\r[3nC\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0013\u0001\u0006)jINs\u0017\r]:i_Rl\u0015\r]*dQ\u0016l\u0017-A\u000bQS\u0012\u001cf.\u00199tQ>$X*\u00199TG\",W.\u0019\u0011\u0002\u0019I,\u0017\rZ*oCB\u001c\bn\u001c;\u0015\t\u00055\u00141\u0012\t\u0007\u0003_\ny(!\"\u000f\t\u0005E\u00141\u0010\b\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011q\u000f3\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0017bAA?W\u00069\u0001/Y2lC\u001e,\u0017\u0002BAA\u0003\u0007\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003{Z\u0007c\u00014\u0002\b&\u0019\u0011\u0011\u00121\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\b\u0003\u001b+\u0003\u0019AAH\u0003\u00111\u0017\u000e\\3\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&~\u0003\tIw.\u0003\u0003\u0002\u001a\u0006M%\u0001\u0002$jY\u0016\fQb\u001e:ji\u0016\u001cf.\u00199tQ>$HCBAP\u0003K\u000b9\u000bE\u0002k\u0003CK1!a)l\u0005\u0011)f.\u001b;\t\u000f\u00055e\u00051\u0001\u0002\u0010\"9\u0011\u0011\u0016\u0014A\u0002\u0005-\u0016aB3oiJLWm\u001d\t\t\u0003[\u000b9,a/\u0002\u00066\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0004nkR\f'\r\\3\u000b\u0007\u0005U6.\u0001\u0006d_2dWm\u0019;j_:LA!!/\u00020\n\u0019Q*\u00199\u0011\u0007)\fi,C\u0002\u0002@.\u0014A\u0001T8oO\u0006q\u0011n]*oCB\u001c\bn\u001c;GS2,G\u0003BAc\u0003\u0017\u00042A[Ad\u0013\r\tIm\u001b\u0002\b\u0005>|G.Z1o\u0011\u001d\tii\na\u0001\u0003\u001f\u000b\u0011\u0003\\5tiNs\u0017\r]:i_R4\u0015\u000e\\3t)\u0011\t\t.a6\u0011\r\u0005=\u00141[AH\u0013\u0011\t).a!\u0003\u0007M+\u0017\u000fC\u0004\u0002Z\"\u0002\r!a$\u0002\u0007\u0011L'/A\u000beK2,G/Z*oCB\u001c\bn\u001c;t\u0005\u00164wN]3\u0015\r\u0005}\u0015q\\Aq\u0011\u001d\tI.\u000ba\u0001\u0003\u001fCq!a9*\u0001\u0004\tY,\u0001\u0004pM\u001a\u001cX\r^\u0001\u0014I\u0016dW\r^3T]\u0006\u00048\u000f[8u\r&dWm\u001d\u000b\u0007\u0003?\u000bI/a;\t\u000f\u0005e'\u00061\u0001\u0002\u0010\"I\u0011Q\u001e\u0016\u0011\u0002\u0003\u0007\u0011q^\u0001\naJ,G-[2bi\u0016\u0004rA[Ay\u0003w\u000b)-C\u0002\u0002t.\u0014\u0011BR;oGRLwN\\\u0019\u0002;\u0011,G.\u001a;f':\f\u0007o\u001d5pi\u001aKG.Z:%I\u00164\u0017-\u001e7uII*\"!!?+\t\u0005=\u00181`\u0016\u0003\u0003{\u0004B!a@\u0003\n5\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\u0011)!A\u0005v]\u000eDWmY6fI*\u0019!qA6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\f\t\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"A!\u0005+\t\u0005E\u00121`\n\u0005[%\u0014)\u0002\u0005\u0003\u0003\u0018\tuQB\u0001B\r\u0015\r\u0011YBY\u0001\u0006kRLGn]\u0005\u0005\u0005?\u0011IBA\u0004M_\u001e<\u0017N\\4\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011!Q\u0005\t\u0005\u0005O\u0011I#\u0004\u0002\u0002R%!!1FA)\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0007Y><G)\u001b:\u0016\u0005\u0005=\u0015A\u00037pO\u0012K'o\u0018\u0013fcR!\u0011q\u0014B\u001c\u0011%\u0011I$MA\u0001\u0002\u0004\ty)A\u0002yIE\nq\u0001\\8h\t&\u0014\b\u0005K\u00023\u0005\u007f\u00012A\u001bB!\u0013\r\u0011\u0019e\u001b\u0002\tm>d\u0017\r^5mK\u0006IR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'t\u0003ii\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:!)!\u0011YE!\u0014\u0003P\tE\u0003C\u00014.\u0011\u001d\u0011\t#\u000ea\u0001\u0005KAqAa\f6\u0001\u0004\ty\tC\u0005\u0003FU\u0002\n\u00111\u0001\u00022\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003W\u000b!\u0002\u001d:pIV\u001cWM]:!\u00035a\u0017m\u001d;NCB|eMZ:fiV\u0011\u00111X\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BAP\u0005CB\u0011B!\u000f:\u0003\u0003\u0005\r!a/\u0002\u001d1\f7\u000f^'ba>3gm]3uA\u0005qA.Y:u':\f\u0007o\u00144gg\u0016$\u0018A\u00057bgR\u001cf.\u00199PM\u001a\u001cX\r^0%KF$B!a(\u0003l!I!\u0011\b\u001f\u0002\u0002\u0003\u0007\u00111X\u0001\u0010Y\u0006\u001cHo\u00158ba>3gm]3uA\u0005YqN\\4pS:<G\u000b\u001f8t+\t\u0011\u0019\b\u0005\u0005\u0003v\tm\u00141\u0018B@\u001b\t\u00119HC\u0002\u0003zu\fA!\u001e;jY&!!Q\u0010B<\u0005\u001d!&/Z3NCB\u00042A\u001aBA\u0013\r\u0011\u0019\t\u0019\u0002\f)btW*\u001a;bI\u0006$\u0018-\u0001\u0007p]\u001e|\u0017N\\4Uq:\u001c\b%\u0001\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\u0006\tRO\u001c:fa2L7-\u0019;fIRChn\u001d\u0011\u0002'\u0019L'o\u001d;V]N$\u0018M\u00197f\u001f\u001a47/\u001a;\u0016\u0005\t=\u0005#\u00026\u0003\u0012\nU\u0015b\u0001BJW\n1q\n\u001d;j_:\u0004BAa&\u0003\u001e6\u0011!\u0011\u0014\u0006\u0004\u00057\u0013\u0017AB:feZ,'/\u0003\u0003\u0003 \ne%!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\u00061rN\u001c%jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,G\r\u0006\u0003\u0002 \n\u0015\u0006b\u0002BT\u0007\u0002\u0007\u00111X\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\u0002)\u0019L'o\u001d;V]\u0012,7-\u001b3fI>3gm]3u+\t\u0011i\u000bE\u0003k\u0005#\u000bY,\u0001\u0007nCB,e\u000eZ(gMN,G/A\bbGRLg/\u001a)s_\u0012,8-\u001a:t+\t\u0011)\f\u0005\u0005\u00038\nu\u00161XAC\u001b\t\u0011IL\u0003\u0003\u0003<\u0006M\u0016!C5n[V$\u0018M\u00197f\u0013\u0011\tIL!/\u0002\u000f%\u001cX)\u001c9usV\u0011\u0011QY\u0001\u0011Y>\fGM\u0012:p[Ns\u0017\r]:i_R$b!a(\u0003H\n-\u0007b\u0002Be\u0011\u0002\u0007\u00111X\u0001\u000fY><7\u000b^1si>3gm]3u\u0011\u001d\u0011i\r\u0013a\u0001\u0003w\u000b1bY;se\u0016tG\u000fV5nK\u0006\tBn\\1e!J|G-^2fe\u0016sGO]=\u0015\t\u0005}%1\u001b\u0005\b\u0005+L\u0005\u0019AAC\u0003\u0015)g\u000e\u001e:z\u0003EI7\u000f\u0015:pIV\u001cWM]#ya&\u0014X\r\u001a\u000b\u0007\u0003\u000b\u0014YNa8\t\u000f\tu'\n1\u0001\u0002<\u0006i1-\u001e:sK:$H+[7f\u001bNDqA!9K\u0001\u0004\t))A\u0007qe>$WoY3s'R\fG/Z\u0001\u0017e\u0016lwN^3FqBL'/\u001a3Qe>$WoY3sgR!\u0011q\u0014Bt\u0011\u001d\u0011in\u0013a\u0001\u0003w\u000b\u0011\u0003\u001e:v]\u000e\fG/Z!oIJ+Gn\\1e)!\tyJ!<\u0003p\nM\bb\u0002Be\u0019\u0002\u0007\u00111\u0018\u0005\b\u0005cd\u0005\u0019AA^\u00031awnZ#oI>3gm]3u\u0011\u001d\u0011i\u000e\u0014a\u0001\u0003w\u000bQ\u0002\u001d:fa\u0006\u0014X-\u00169eCR,GC\u0002B}\u0005\u007f\u001c\u0019\u0001E\u0002g\u0005wL1A!@a\u0005I\u0001&o\u001c3vG\u0016\u0014\u0018\t\u001d9f]\u0012LeNZ8\t\u000f\r\u0005Q\n1\u0001\u0002<\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\r\u0015Q\n1\u0001\u0002F\u0006a\u0011n\u001d$s_6\u001cE.[3oi\u00061Q\u000f\u001d3bi\u0016$B!a(\u0004\f!91Q\u0002(A\u0002\te\u0018AC1qa\u0016tG-\u00138g_\u0006\u0011R\u000f\u001d3bi\u0016l\u0015\r]#oI>3gm]3u)\u0011\tyja\u0005\t\u000f\rUq\n1\u0001\u0002<\u0006QA.Y:u\u001f\u001a47/\u001a;\u0002\u00131\f7\u000f^#oiJLH\u0003BB\u000e\u0007;\u0001RA\u001bBI\u0003\u000bCqa!\u0001Q\u0001\u0004\tY,\u0001\u0007uC.,7K\\1qg\"|G\u000f\u0006\u0002\u0002 \u0006!B.\u0019;fgR\u001cf.\u00199tQ>$xJ\u001a4tKR\fAc\u001c7eKN$8K\\1qg\"|Go\u00144gg\u0016$\u0018AE5t!J|G-^2feJ+G/Y5oK\u0012$b!!2\u0004,\r=\u0002bBB\u0017)\u0002\u0007\u0011QQ\u0001\u0013aJ|G-^2feN#\u0018\r^3F]R\u0014\u0018\u0010C\u0004\u0003JR\u0003\r!a/\u0002\u0019Q\u0014XO\\2bi\u0016DU-\u00193\u0015\t\u0005}5Q\u0007\u0005\b\u0005\u0013,\u0006\u0019AA^\u0003\u0001\u0012X-\\8wK\u00163\u0018n\u0019;fI>swm\\5oOR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005}51\b\u0005\b\u0007{1\u0006\u0019AB \u0003I)\u0007\u0010]5sK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:\u0011\r\r\u000531IA^\u001b\t\t\u0019,\u0003\u0003\u0004F\u0005M&aA*fi\u0006q\"/Z7pm\u0016,fN]3qY&\u001c\u0017\r^3e)J\fgn]1di&|gn\u001d\u000b\u0005\u0003?\u001bY\u0005C\u0004\u0002d^\u0003\r!a/\u0002\u0011Q\u0014XO\\2bi\u0016\f\u0001\u0003\\1tiN#\u0018M\u00197f\u001f\u001a47/\u001a;\u0015\t\u0005m61\u000b\u0005\b\u0007+J\u0006\u0019AB,\u00031\u0019w.\u001c9mKR,G\r\u0016=o!\r17\u0011L\u0005\u0004\u00077\u0002'\u0001D\"p[BdW\r^3e)bt\u0017aC2p[BdW\r^3Uq:$B!a(\u0004b!91Q\u000b.A\u0002\r]C\u0003BAP\u0007KBq!a9\\\u0001\u0004\tY\fK\u0002\\\u0007S\u0002BAa\u0006\u0004l%!1Q\u000eB\r\u0005)!\bN]3bIN\fg-Z\u0001\u0013_2$Wm\u001d;T]\u0006\u00048\u000f[8u\r&dW-\u0006\u0002\u0004tA)!N!%\u0002\u0010\u0006\u0011B.\u0019;fgR\u001cf.\u00199tQ>$h)\u001b7f+\t\t\t\u000eK\u0002.\u0007w\u0002BAa\u0006\u0004~%!1q\u0010B\r\u00055qwN\u001c;ie\u0016\fGm]1gK\u0002")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1<Map.Entry, LogOffsetMetadata> & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option<LogOffsetMetadata> undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1<Map.Entry, LogOffsetMetadata> & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (undecidedFirstOffset.get().messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : var1_1));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1<Map.Entry, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong(ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        while (true) {
            Option<File> option;
            if ((option = this.latestSnapshotFile()) instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                try {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(file).append("'").toString());
                    Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1<ProducerStateEntry, Object> & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean(ProducerStateManager.$anonfun$loadFromSnapshot$2(this, logStartOffset, currentTime, producerEntry)));
                    loadedProducers.foreach((Function1<ProducerStateEntry, Object> & Serializable & scala.Serializable)entry -> {
                        this.loadProducerEntry(entry);
                        return BoxedUnit.UNIT;
                    });
                    this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                    this.lastMapOffset_$eq(this.lastSnapOffset());
                    return;
                }
                catch (CorruptSnapshotException e) {
                    this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(file).append("': ").append(e.getMessage()).toString());
                    boolean bl = Files.deleteIfExists(file.toPath());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    this.lastSnapOffset_$eq(logStartOffset);
                    this.lastMapOffset_$eq(logStartOffset);
                    return;
                }
                throw new MatchError(option);
            }
        }
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put(BoxesRunTime.boxToLong(producerId), entry);
        entry.currentTxnFirstOffset().foreach((Function1<Object, TxnMetadata> & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong(offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2<Object, ProducerStateEntry, Object> & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, BoxesRunTime.unboxToLong(x0$1), x1$1)));
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (JFunction1$mcZJ$sp & scala.Serializable)snapOffset -> snapOffset > logEndOffset || snapOffset <= logStartOffset);
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        ValidationType validationType;
        if (!isFromClient) {
            validationType = ValidationType$None$.MODULE$;
        } else {
            String string = this.topicPartition().topic();
            String string2 = "__consumer_offsets";
            validationType = !(string != null ? !string.equals(string2) : string2 != null) ? ValidationType$EpochOnly$.MODULE$ : ValidationType$Full$.MODULE$;
        }
        ValidationType$None$ validationToPerform = validationType;
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0<ProducerStateEntry> & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, validationToPerform);
    }

    public void update(ProducerAppendInfo appendInfo) {
        Serializable serializable;
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append(new StringBuilder(14).append("for partition ").append(this.topicPartition()).toString()).toString());
        }
        this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get(BoxesRunTime.boxToLong(appendInfo.producerId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            ProducerStateEntry currentEntry = (ProducerStateEntry)some.value();
            currentEntry.update(updatedEntry);
            serializable = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            serializable = this.producers().put(BoxesRunTime.boxToLong(appendInfo.producerId()), updatedEntry);
        } else {
            throw new MatchError(option);
        }
        appendInfo.startedTransactions().foreach((Function1<TxnMetadata, TxnMetadata> & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong(txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get(BoxesRunTime.boxToLong(producerId));
    }

    public void takeSnapshot() {
        block0: {
            if (this.lastMapOffset() <= this.lastSnapOffset()) break block0;
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.lastMapOffset());
            this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writing producer snapshot at offset ").append(this.lastMapOffset()).toString());
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1<File, Object> & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong(Log$.MODULE$.offsetFromFile(file)));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1<File, Object> & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong(Log$.MODULE$.offsetFromFile(file)));
    }

    private boolean isProducerRetained(ProducerStateEntry producerStateEntry, long logStartOffset) {
        producerStateEntry.removeBatchesOlderThan(logStartOffset);
        return producerStateEntry.lastDataOffset() >= logStartOffset;
    }

    public void truncateHead(long logStartOffset) {
        Map evictedProducerEntries = (Map)this.producers().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ProducerStateManager.$anonfun$truncateHead$1(this, logStartOffset, x0$1)));
        Set<Object> evictedProducerIds = evictedProducerEntries.keySet();
        this.producers().$minus$minus$eq(evictedProducerIds);
        this.removeEvictedOngoingTransactions(evictedProducerIds);
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong(this.latestSnapshotOffset().getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> logStartOffset)));
    }

    private void removeEvictedOngoingTransactions(Set<Object> expiredProducerIds) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.ongoingTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            if (!expiredProducerIds.contains(BoxesRunTime.boxToLong(txnEntry.getValue().producerId()))) continue;
            iterator.remove();
        }
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((JFunction1$mcZJ$sp & scala.Serializable)x$7 -> x$7 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(0L);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        Option nextIncompleteTxn = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1<TxnMetadata, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$8)));
        return BoxesRunTime.unboxToLong(nextIncompleteTxn.map((Function1<TxnMetadata, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong(ProducerStateManager.$anonfun$lastStableOffset$2(x$9))).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong(completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq(new Some<Object>(BoxesRunTime.boxToLong(completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong(completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files2 = this.listSnapshotFiles();
        return files2.nonEmpty() ? new Some(files2.minBy((Function1<File, Object> & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong(Log$.MODULE$.offsetFromFile(file)), Ordering$Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files2 = this.listSnapshotFiles();
        return files2.nonEmpty() ? new Some(files2.maxBy((Function1<File, Object> & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong(Log$.MODULE$.offsetFromFile(file)), Ordering$Long$.MODULE$)) : None$.MODULE$;
    }

    private Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long logStartOffset$1, long currentTime$1, ProducerStateEntry producerEntry) {
        return $this.isProducerRetained(producerEntry, logStartOffset$1) && !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong(offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, long x0$1, ProducerStateEntry x1$1) {
        Tuple2<Long, ProducerStateEntry> tuple2 = new Tuple2<Long, ProducerStateEntry>(BoxesRunTime.boxToLong(x0$1), x1$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ProducerStateEntry lastEntry = tuple2._2();
        boolean bl = !$this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$truncateHead$1(ProducerStateManager $this, long logStartOffset$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ProducerStateEntry producerState = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerRetained(producerState, logStartOffset$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$8) {
        return x$8.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$9) {
        return x$9.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

