/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenManager$ {
    public static DelegationTokenManager$ MODULE$;
    private final String DefaultHmacAlgorithm;
    private final String OwnerKey;
    private final String RenewersKey;
    private final String IssueTimestampKey;
    private final String MaxTimestampKey;
    private final String ExpiryTimestampKey;
    private final String TokenIdKey;
    private final String VersionKey;
    private final int CurrentVersion;
    private final int ErrorTimestamp;

    static {
        new DelegationTokenManager$();
    }

    public String DefaultHmacAlgorithm() {
        return this.DefaultHmacAlgorithm;
    }

    public String OwnerKey() {
        return this.OwnerKey;
    }

    public String RenewersKey() {
        return this.RenewersKey;
    }

    public String IssueTimestampKey() {
        return this.IssueTimestampKey;
    }

    public String MaxTimestampKey() {
        return this.MaxTimestampKey;
    }

    public String ExpiryTimestampKey() {
        return this.ExpiryTimestampKey;
    }

    public String TokenIdKey() {
        return this.TokenIdKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public int ErrorTimestamp() {
        return this.ErrorTimestamp;
    }

    public byte[] createHmac(String tokenId, String secretKey) {
        return this.createHmac(tokenId, this.createSecretKey(secretKey.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretKey createSecretKey(byte[] keybytes) {
        return new SecretKeySpec(keybytes, this.DefaultHmacAlgorithm());
    }

    public String createBase64HMAC(String tokenId, SecretKey secretKey) {
        byte[] hmac = this.createHmac(tokenId, secretKey);
        return Base64.getEncoder().encodeToString(hmac);
    }

    public byte[] createHmac(String tokenId, SecretKey secretKey) {
        Mac mac = Mac.getInstance(this.DefaultHmacAlgorithm());
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
    }

    public Map<String, Object> toJsonCompatibleMap(DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        scala.collection.mutable.Map tokenInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        tokenInfoMap.update(this.VersionKey(), BoxesRunTime.boxToInteger(this.CurrentVersion()));
        tokenInfoMap.update(this.OwnerKey(), Sanitizer.sanitize(tokenInfo.ownerAsString()));
        tokenInfoMap.update(this.RenewersKey(), JavaConverters$.MODULE$.asJavaIterableConverter(((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewersAsString()).asScala()).map((Function1<String, String> & Serializable & scala.Serializable)e -> Sanitizer.sanitize(e), Iterable$.MODULE$.canBuildFrom())).asJava());
        tokenInfoMap.update(this.IssueTimestampKey(), BoxesRunTime.boxToLong(tokenInfo.issueTimestamp()));
        tokenInfoMap.update(this.MaxTimestampKey(), BoxesRunTime.boxToLong(tokenInfo.maxTimestamp()));
        tokenInfoMap.update(this.ExpiryTimestampKey(), BoxesRunTime.boxToLong(tokenInfo.expiryTimestamp()));
        tokenInfoMap.update(this.TokenIdKey(), tokenInfo.tokenId());
        return tokenInfoMap.toMap(Predef$.MODULE$.$conforms());
    }

    public Option<TokenInformation> fromBytes(byte[] bytes) {
        Option option;
        if (bytes == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return None$.MODULE$;
        }
        Option<JsonValue> option2 = Json$.MODULE$.parseBytes(bytes);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            JsonValue js = (JsonValue)some.value();
            JsonObject mainJs = js.asJsonObject();
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt(mainJs.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$)) == this.CurrentVersion());
            KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal(Sanitizer.desanitize(mainJs.apply(this.OwnerKey()).to(DecodeJson$DecodeString$.MODULE$)));
            Seq renewerStr = mainJs.apply(this.RenewersKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Seq renewers = ((TraversableLike)renewerStr.map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> Sanitizer.desanitize(x$1), Seq$.MODULE$.canBuildFrom())).map((Function1<String, KafkaPrincipal> & Serializable & scala.Serializable)x$2 -> SecurityUtils.parseKafkaPrincipal(x$2), Seq$.MODULE$.canBuildFrom());
            long issueTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.IssueTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long expiryTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.ExpiryTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long maxTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.MaxTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            String tokenId = mainJs.apply(this.TokenIdKey()).to(DecodeJson$DecodeString$.MODULE$);
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimestamp, maxTimestamp, expiryTimestamp);
            option = new Some<TokenInformation>(tokenInfo);
        } else if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public boolean filterToken(KafkaPrincipal requestedPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken) {
        boolean allow = !owners.isEmpty() && !((LinearSeqOptimized)owners.get()).exists((Function1<KafkaPrincipal, Object> & Serializable & scala.Serializable)owner -> BoxesRunTime.boxToBoolean(token.ownerOrRenewer(owner))) ? false : (token.ownerOrRenewer(requestedPrincipal) ? true : BoxesRunTime.unboxToBoolean(authorizeToken.apply(token.tokenId())));
        return allow;
    }

    private DelegationTokenManager$() {
        MODULE$ = this;
        this.DefaultHmacAlgorithm = "HmacSHA512";
        this.OwnerKey = "owner";
        this.RenewersKey = "renewers";
        this.IssueTimestampKey = "issueTimestamp";
        this.MaxTimestampKey = "maxTimestamp";
        this.ExpiryTimestampKey = "expiryTimestamp";
        this.TokenIdKey = "tokenId";
        this.VersionKey = "version";
        this.CurrentVersion = 1;
        this.ErrorTimestamp = -1;
    }
}

