/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rMd\u0001B\u001f?\u0001\rC\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u00199\u0007\u0001)A\u00057\"9\u0001\u000e\u0001a\u0001\n\u0013I\u0007\"\u0003B\u0003\u0001\u0001\u0007I\u0011\u0002B\u0004\u0011\u001d\u0011\t\u0002\u0001Q!\n)D\u0011Ba\u0007\u0001\u0005\u0004%IA!\b\t\u0011\t-\u0002\u0001)A\u0005\u0005?AqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u0003`\u0001!IA!\u0019\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\"9!\u0011\u0013\u0001\u0005\u0002\tM\u0005\"\u0003BW\u0001E\u0005I\u0011\u0001BX\u0011%\u0011\u0019\fAI\u0001\n\u0003\u0011y\u000bC\u0004\u00036\u0002!\tAa.\t\u000f\te\u0006\u0001\"\u0001\u0003<\"9!Q\u0017\u0001\u0005\n\t\u0015\u0007b\u0002B]\u0001\u0011%!\u0011\u001a\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0011\u001d\u00119\u000e\u0001C\u0001\u00053DqA!8\u0001\t\u0003\u0011y\u000eC\u0004\u0003d\u0002!IA!:\t\u000f\tM\b\u0001\"\u0001\u0003v\"9!Q \u0001\u0005\u0002\t}\bbBB\u0004\u0001\u0011\u0005\u0011q\b\u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0011\u001d\u0019I\u0002\u0001C\u0001\u00077Aqa!\f\u0001\t\u0003\u0019y\u0003C\u0004\u0004.\u0001!\taa\r\t\u000f\re\u0002\u0001\"\u0003\u0004<\u0019!A\u000e\u0001!n\u0011!!\bE!f\u0001\n\u0003)\b\"CA\u001eA\tE\t\u0015!\u0003w\u0011)\ti\u0004\tBK\u0002\u0013\u0005\u0011q\b\u0005\u000b\u0003\u000f\u0002#\u0011#Q\u0001\n\u0005\u0005\u0003BCA%A\tU\r\u0011\"\u0001\u0002L!Q\u00111\f\u0011\u0003\u0012\u0003\u0006I!!\u0014\t\u0015\u0005u\u0003E!f\u0001\n\u0003\ty\u0006\u0003\u0006\u0002\u0000\u0001\u0012\t\u0012)A\u0005\u0003CBa\u0001\u0016\u0011\u0005\u0002\u0005\u0005\u0005\"CAFA\u0005\u0005I\u0011AAG\u0011%\t9\nII\u0001\n\u0003\tI\nC\u0005\u00020\u0002\n\n\u0011\"\u0001\u00022\"I\u0011Q\u0017\u0011\u0012\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003w\u0003\u0013\u0013!C\u0001\u0003{C\u0011\"!1!\u0003\u0003%\t%a1\t\u0013\u0005=\u0007%!A\u0005\u0002\u0005E\u0007\"CAjA\u0005\u0005I\u0011AAk\u0011%\t\t\u000fIA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002l\u0002\n\t\u0011\"\u0001\u0002n\"I\u0011q\u001f\u0011\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0003w\u0004\u0013\u0011!C!\u0003{D\u0011\"a@!\u0003\u0003%\tE!\u0001\b\u0013\r\r\u0003!!A\t\u0002\r\u0015c\u0001\u00037\u0001\u0003\u0003E\taa\u0012\t\rQCD\u0011AB+\u0011%\tY\u0010OA\u0001\n\u000b\ni\u0010C\u0005\u0004Xa\n\t\u0011\"!\u0004Z!I11\r\u001d\u0002\u0002\u0013\u00055Q\r\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u000b\u0005}\u0002\u0015AB:feZ,'OC\u0001B\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001#K!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0019\te.\u001f*fMB\u00111JT\u0007\u0002\u0019*\u0011Q\nQ\u0001\u0006kRLGn]\u0005\u0003\u001f2\u0013q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\t)%+\u0003\u0002T\r\n\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\t1\u0006\f\u0005\u0002X\u00015\ta\bC\u0003Q\u0005\u0001\u0007\u0011+A\u000bqCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006dunY6\u0016\u0003m\u0003\"\u0001X3\u000e\u0003uS!AX0\u0002\u000b1|7m[:\u000b\u0005\u0001\f\u0017AC2p]\u000e,(O]3oi*\u0011!mY\u0001\u0005kRLGNC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019l&A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u0002-A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dW\u0002\n\u0001#\\3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0016\u0003)\u0004\"a\u001b\u0011\u000e\u0003\u0001\u0011\u0001#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0014\t\u0001\"e.\u001d\t\u0003\u000b>L!\u0001\u001d$\u0003\u000fA\u0013x\u000eZ;diB\u0011QI]\u0005\u0003g\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0002mB)q\u000f @\u0002\u00145\t\u0001P\u0003\u0002zu\u00069Q.\u001e;bE2,'BA>G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{b\u0014\u0011\"\u00118z%\u00164W*\u00199\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002\r6\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\u0011\u0015A\u0002\u001fs_>$h(C\u0002\u0002\f\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006\rB)q/!\u0006\u0002\u001a%\u0019\u0011q\u0003=\u0003\u000f1{gnZ'baB!\u00111DA\u001b\u001d\u0011\ti\"!\r\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003K\t9#\u0001\u0004d_6lwN\u001c\u0006\u0004\u0003\u0006%\"\u0002BA\u0016\u0003[\ta!\u00199bG\",'BAA\u0018\u0003\ry'oZ\u0005\u0005\u0003g\ty\"A\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\n\t\u0005]\u0012\u0011\b\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\t\u0019$a\b\u0002!A\f'\u000f^5uS>t7\u000b^1uKN\u0004\u0013\u0001D2p]R\u0014x\u000e\u001c7fe&#WCAA!!\u0011)\u00151I)\n\u0007\u0005\u0015cI\u0001\u0004PaRLwN\\\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002\u0019\u0005d\u0017N^3Ce>\\WM]:\u0016\u0005\u00055\u0003#B<\u0002\u0016\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U\u0003)A\u0004dYV\u001cH/\u001a:\n\t\u0005e\u00131\u000b\u0002\u0007\u0005J|7.\u001a:\u0002\u001b\u0005d\u0017N^3Ce>\\WM]:!\u0003)\tG.\u001b<f\u001d>$Wm]\u000b\u0003\u0003C\u0002Ra^A\u000b\u0003G\u0002\u0002\"!\u001a\u0002h\u0005-\u0014qO\u0007\u0002u&\u0019\u0011\u0011\u000e>\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002n\u0005MTBAA8\u0015\u0011\t\t(a\t\u0002\u000f9,Go^8sW&!\u0011QOA8\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\tI(a\u001f\u000e\u0005\u0005\r\u0012\u0002BA?\u0003G\u0011AAT8eK\u0006Y\u0011\r\\5wK:{G-Z:!)%Q\u00171QAC\u0003\u000f\u000bI\tC\u0003uS\u0001\u0007a\u000fC\u0004\u0002>%\u0002\r!!\u0011\t\u000f\u0005%\u0013\u00061\u0001\u0002N!9\u0011QL\u0015A\u0002\u0005\u0005\u0014\u0001B2paf$\u0012B[AH\u0003#\u000b\u0019*!&\t\u000fQT\u0003\u0013!a\u0001m\"I\u0011Q\b\u0016\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003\u0013R\u0003\u0013!a\u0001\u0003\u001bB\u0011\"!\u0018+!\u0003\u0005\r!!\u0019\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0014\u0016\u0004m\u0006u5FAAP!\u0011\t\t+a+\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%f)\u0001\u0006b]:|G/\u0019;j_:LA!!,\u0002$\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0017\u0016\u0005\u0003\u0003\ni*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e&\u0006BA'\u0003;\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002@*\"\u0011\u0011MAO\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0019\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111Z2\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\tI-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001R\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a6\u0002^B\u0019Q)!7\n\u0007\u0005mgIA\u0002B]fD\u0001\"a82\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\bCBA3\u0003O\f9.C\u0002\u0002jj\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q^A{!\r)\u0015\u0011_\u0005\u0004\u0003g4%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003?\u001c\u0014\u0011!a\u0001\u0003/\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002#\u0006AAo\\*ue&tw\r\u0006\u0002\u0002F\u00061Q-];bYN$B!a<\u0003\u0004!I\u0011q\u001c\u001c\u0002\u0002\u0003\u0007\u0011q[\u0001\u0015[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R|F%Z9\u0015\t\t%!q\u0002\t\u0004\u000b\n-\u0011b\u0001B\u0007\r\n!QK\\5u\u0011!\tyNBA\u0001\u0002\u0004Q\u0017!E7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8uA!\u001aqA!\u0006\u0011\u0007\u0015\u00139\"C\u0002\u0003\u001a\u0019\u0013\u0001B^8mCRLG.Z\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014XC\u0001B\u0010!\u0011\u0011\tCa\n\u000e\u0005\t\r\"b\u0001B\u0013\u0001\u0006Q1m\u001c8ue>dG.\u001a:\n\t\t%\"1\u0005\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018AE:uCR,7\t[1oO\u0016dunZ4fe\u0002\nAbZ3u\u000b:$\u0007o\\5oiN$\"B!\r\u00038\tm\"q\u000bB.!\u0019\t)Ga\r\u0002x%\u0019!Q\u0007>\u0003\u0007M+\u0017\u000f\u0003\u0004\u0003:)\u0001\rA[\u0001\tg:\f\u0007o\u001d5pi\"9!Q\b\u0006A\u0002\t}\u0012a\u00022s_.,'o\u001d\t\u0007\u0005\u0003\u0012YE!\u0015\u000f\t\t\r#q\t\b\u0005\u0003\u0007\u0011)%C\u0001H\u0013\r\u0011IER\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iEa\u0014\u0003\u0011%#XM]1cY\u0016T1A!\u0013G!\u0011\t9Ma\u0015\n\t\tU\u0013\u0011\u001a\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011IF\u0003a\u0001\u0003W\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016DqA!\u0018\u000b\u0001\u0004\ty/\u0001\u000egS2$XM]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8/\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\r\u0005G\u0012)Ha\u001e\u0003|\tu$\u0011\u0011\t\u0006\u000b\u0006\r#Q\r\t\u0007\u0005\u0003\u0012YEa\u001a\u0011\t\t%$q\u000e\b\u0005\u0003;\u0011Y'\u0003\u0003\u0003n\u0005}\u0011\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0013\u0011\u0011\tHa\u001d\u0003#A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018M\u0003\u0003\u0003n\u0005}\u0001B\u0002B\u001d\u0017\u0001\u0007!\u000e\u0003\u0004\u0003z-\u0001\rA`\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u00053Z\u0001\u0019AA6\u0011\u001d\u0011yh\u0003a\u0001\u0003_\f\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3F]\u0012\u0004x.\u001b8ug\"9!1Q\u0006A\u0002\u0005=\u0018!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u0019&\u001cH/\u001a8feN\f\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\t%%1\u0012BG\u0005\u001f\u0003R!RA\"\u0003oBaA!\u000f\r\u0001\u0004Q\u0007\"\u0002)\r\u0001\u0004\t\u0006b\u0002B-\u0019\u0001\u0007\u00111N\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\"B!&\u0003\u001e\n\u001d&\u0011\u0016BV!\u0019\t)Ga\r\u0003\u0018B!!\u0011\u000eBM\u0013\u0011\u0011YJa\u001d\u0003\u001bQ{\u0007/[2NKR\fG-\u0019;b\u0011\u001d\u0011y*\u0004a\u0001\u0005C\u000ba\u0001^8qS\u000e\u001c\b#BA3\u0005Gs\u0018b\u0001BSu\n\u00191+\u001a;\t\u000f\teS\u00021\u0001\u0002l!I!qP\u0007\u0011\u0002\u0003\u0007\u0011q\u001e\u0005\n\u0005\u0007k\u0001\u0013!a\u0001\u0003_\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"A!-+\t\u0005=\u0018QT\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$H\u0005N\u0001\rO\u0016$\u0018\t\u001c7U_BL7m\u001d\u000b\u0003\u0005C\u000b\u0001cZ3u\u00032d\u0007+\u0019:uSRLwN\\:\u0015\u0005\tu\u0006CBA3\u0005G\u0013y\f\u0005\u0003\u0002z\t\u0005\u0017\u0002\u0002Bb\u0003G\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003\"\n\u001d\u0007B\u0002B\u001d%\u0001\u0007!\u000e\u0006\u0003\u0003L\n=\u0007cB@\u0003N\n}\u0016\u0011D\u0005\u0005\u0003S\n\t\u0002\u0003\u0004\u0003:M\u0001\rA[\u0001\u0015O\u0016$hj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY:\u0015\t\t\u0005&Q\u001b\u0005\b\u0005?#\u0002\u0019\u0001BQ\u00035I7O\u0011:pW\u0016\u0014\u0018\t\\5wKR!\u0011q\u001eBn\u0011\u0015\u0001V\u00031\u0001R\u0003=9W\r^!mSZ,'I]8lKJ\u001cXC\u0001Bq!\u0019\t)Ga\r\u0002P\u0005A\u0012\r\u001a3PeV\u0003H-\u0019;f!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\u0015\t%!q\u001dBu\u0005W\u0014y\u000fC\u0003u/\u0001\u0007a\u000f\u0003\u0004\u0003z]\u0001\rA \u0005\u0007\u0005[<\u0002\u0019A)\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0005c<\u0002\u0019AA\r\u0003%\u0019H/\u0019;f\u0013:4w.\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R1!q\u001fB}\u0005w\u0004R!RA\"\u00033AaA!\u001f\u0019\u0001\u0004q\bB\u0002Bw1\u0001\u0007\u0011+\u0001\u000ehKR\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0005\u0003\n\u000e\u000511AB\u0003\u0011\u0019\u0011I(\u0007a\u0001}\"1!Q^\rA\u0002ECqA!\u0017\u001a\u0001\u0004\tY'A\bhKR\u001cuN\u001c;s_2dWM]%e\u0003I9W\r^\"mkN$XM]'fi\u0006$\u0017\r^1\u0015\r\r511CB\f!\u0011\tIha\u0004\n\t\rE\u00111\u0005\u0002\b\u00072,8\u000f^3s\u0011\u0019\u0019)b\u0007a\u0001}\u0006I1\r\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u00053Z\u0002\u0019AA6\u00039)\b\u000fZ1uK6+G/\u00193bi\u0006$ba!\b\u0004 \r\r\u0002CBA3\u0005g\u0011y\f\u0003\u0004\u0004\"q\u0001\r!U\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u000f\r\u0015B\u00041\u0001\u0004(\u0005)R\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\b\u0003BA\u000f\u0007SIAaa\u000b\u0002 \t)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\u0018\u0001C2p]R\f\u0017N\\:\u0015\t\u0005=8\u0011\u0007\u0005\u0007\u0005sj\u0002\u0019\u0001@\u0015\t\u0005=8Q\u0007\u0005\b\u0007oq\u0002\u0019\u0001B`\u0003\t!\b/A\nsK6|g/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0005\u0002p\u000eu2qHB!\u0011\u0015!x\u00041\u0001w\u0011\u0019\u0011Ih\ba\u0001}\"1!Q^\u0010A\u0002E\u000b\u0001#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0011\u0005-D4\u0003\u0002\u001d\u0004JE\u0004Bba\u0013\u0004RY\f\t%!\u0014\u0002b)l!a!\u0014\u000b\u0007\r=c)A\u0004sk:$\u0018.\\3\n\t\rM3Q\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAB#\u0003\u0015\t\u0007\u000f\u001d7z)%Q71LB/\u0007?\u001a\t\u0007C\u0003uw\u0001\u0007a\u000fC\u0004\u0002>m\u0002\r!!\u0011\t\u000f\u0005%3\b1\u0001\u0002N!9\u0011QL\u001eA\u0002\u0005\u0005\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007O\u001ay\u0007E\u0003F\u0003\u0007\u001aI\u0007\u0005\u0006F\u0007W2\u0018\u0011IA'\u0003CJ1a!\u001cG\u0005\u0019!V\u000f\u001d7fi!A1\u0011\u000f\u001f\u0002\u0002\u0003\u0007!.A\u0002yIA\u0002")
public class MetadataCache
implements Logging {
    private volatile MetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public MetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(MetadataSnapshot snapshot, Iterable<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer<Node> result2 = new ArrayBuffer<Node>(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1<Integer, Object> & Serializable & scala.Serializable)brokerId -> {
            MetadataCache.$anonfun$getEndpoints$1(this, snapshot, listenerName, filterUnavailableEndpoints, result2, brokerId);
            return BoxedUnit.UNIT;
        });
        return result2;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get(topic).map((Function1<LongMap, Iterable> & Serializable & scala.Serializable)partitions -> partitions.map((Function1<Tuple2, MetadataResponse.PartitionMetadata> & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            long partitionId = tuple2._1$mcJ$sp();
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.basePartitionState.leader;
            int leaderEpoch = partitionState.basePartitionState.leaderEpoch;
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            Buffer<Integer> replicas = JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.replicas).asScala();
            Seq<Node> replicaInfo = this.getEndpoints(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints(snapshot, (Iterable<Integer>)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas).asScala(), listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                Errors errors;
                if (!snapshot.aliveBrokers().contains($this.brokerId)) {
                    this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" not found on leader ").append(leaderBrokerId).toString());
                    errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors;
                partitionMetadata = new MetadataResponse.PartitionMetadata(error, (int)partitionId, Node.noNode(), Optional.empty(), JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList(), JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                Buffer<Integer> isr = JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.isr).asScala();
                Seq<Node> isrInfo = this.getEndpoints(snapshot, isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String> & Serializable & scala.Serializable)() -> {
                        Seq seq = replicaInfo.map((Function1<Node, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(74).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)replicas.filterNot((Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String> & Serializable & scala.Serializable)() -> {
                        Seq seq = isrInfo.map((Function1<Node, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(82).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)isr.filterNot((Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, (int)partitionId, leader, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get(brokerId).flatMap((Function1<Map, Option> & Serializable & scala.Serializable)x$3 -> x$3.get(listenerName));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return topics.toSeq().flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1<Iterable, MetadataResponse.TopicMetadata> & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, (String)topic, Topic.isInternal(topic), JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    public Set<TopicPartition> getAllPartitions() {
        return ((TraversableOnce)this.metadataSnapshot().partitionStates().flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String topicName = (String)tuple2._1();
            LongMap partitionsAndStates = (LongMap)tuple2._2();
            Iterable iterable = partitionsAndStates.keys().map((Function1<Object, TopicPartition> & Serializable & scala.Serializable)partitionId -> MetadataCache.$anonfun$getAllPartitions$2(topicName, BoxesRunTime.unboxToLong(partitionId)), scala.collection.Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1<Tuple2, scala.collection.mutable.Map> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String topic = (String)tuple2._1();
            LongMap partitionStates = (LongMap)tuple2._2();
            scala.collection.mutable.Map map = partitionStates.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long partition = tuple2._1$mcJ$sp();
                UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
                Tuple2<TopicPartition, UpdateMetadataRequest.PartitionState> tuple22 = new Tuple2<TopicPartition, UpdateMetadataRequest.PartitionState>(new TopicPartition(topic, (int)partition), state);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.$minus$minus(this.metadataSnapshot().partitionStates().keySet());
    }

    public boolean isBrokerAlive(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains(brokerId);
    }

    public Seq<Broker> getAliveBrokers() {
        return this.metadataSnapshot().aliveBrokers().values().toBuffer();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequest.PartitionState stateInfo) {
        LongMap<UpdateMetadataRequest.PartitionState> infos = partitionStates.getOrElseUpdate(topic, (Function0<LongMap<UpdateMetadataRequest.PartitionState>>)(Function0<LongMap> & Serializable & scala.Serializable)() -> LongMap$.MODULE$.apply(Nil$.MODULE$));
        infos.update(partitionId, stateInfo);
    }

    public Option<UpdateMetadataRequest.PartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get(topic).flatMap((Function1<LongMap, Option> & Serializable & scala.Serializable)x$4 -> x$4.get(partitionId));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get(topic).flatMap((Function1<LongMap, Option> & Serializable & scala.Serializable)x$5 -> x$5.get(partitionId)).map((Function1<UpdateMetadataRequest.PartitionState, Node> & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.basePartitionState.leader;
            Option<Map<ListenerName, Node>> option = snapshot.aliveNodes().get(leaderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse(listenerName, (Function0<Node> & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError(option);
            }
            return node;
        });
    }

    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            Map nodes = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2(BoxesRunTime.boxToLong(id), nodes.get(listenerName).orNull(Predef$.MODULE$.$conforms()));
            return tuple22;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = ((TraversableLike)this.getAllPartitions(snapshot).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean(MetadataCache.$anonfun$getClusterMetadata$2(x0$2)))).map((Function1<Tuple2, PartitionInfo> & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), MetadataCache.node$1(Predef$.MODULE$.int2Integer(state.basePartitionState.leader), nodes), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.replicas).asScala()).map((Function1<Integer, Node> & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.isr).asScala()).map((Function1<Integer, Node> & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas).asScala()).map((Function1<Integer, Node> & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set<String> unauthorizedTopics = Collections.emptySet();
        java.util.Set<String> internalTopics = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(MetadataCache.$anonfun$getClusterMetadata$7(x$1)))).asJava();
        return new Cluster(clusterId, JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)nodes.values().filter((Function1<Node, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(MetadataCache.$anonfun$getClusterMetadata$8(x$6)))).toList()).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(partitions.toList()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1<Object, Node> & Serializable & scala.Serializable)id -> MetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0<ArrayBuffer> & Serializable & scala.Serializable)() -> {
            LongMap<Broker> aliveBrokers = new LongMap<Broker>(this.metadataSnapshot().aliveBrokers().size());
            LongMap<Map<ListenerName, Node>> aliveNodes = new LongMap<Map<ListenerName, Node>>(this.metadataSnapshot().aliveNodes().size());
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            Option controllerId = n < 0 ? None$.MODULE$ : new Some<Integer>(BoxesRunTime.boxToInteger(n));
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1<UpdateMetadataRequest.Broker, Object> & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateMetadata$2(aliveBrokers, aliveNodes, broker);
                return BoxedUnit.UNIT;
            });
            aliveNodes.get($this.brokerId).foreach((Function1<Map, Object> & Serializable & scala.Serializable)listenerMap -> {
                MetadataCache.$anonfun$updateMetadata$4(this, aliveNodes, listenerMap);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            if (updateMetadataRequest.partitionStates().isEmpty()) {
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, this.metadataSnapshot().partitionStates(), controllerId, aliveBrokers, aliveNodes));
            } else {
                AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates = new AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>(this.metadataSnapshot().partitionStates().size());
                this.metadataSnapshot().partitionStates().foreach((Function1<Tuple2, AnyRefMap> & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String topic = (String)tuple2._1();
                    LongMap oldPartitionStates = (LongMap)tuple2._2();
                    LongMap copy = new LongMap(oldPartitionStates.size());
                    copy.$plus$plus$eq(oldPartitionStates);
                    MapLike mapLike = partitionStates.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), copy));
                    return mapLike;
                });
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
                    Object object;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        UpdateMetadataRequest.PartitionState info = (UpdateMetadataRequest.PartitionState)tuple2._2();
                        int controllerId = updateMetadataRequest.controllerId();
                        int controllerEpoch = updateMetadataRequest.controllerEpoch();
                        if (info.basePartitionState.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                            this.removePartitionInfo(partitionStates, tp.topic(), tp.partition());
                            this.stateChangeLogger().trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append(new StringBuilder(55).append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                            object = deletedPartitions.$plus$eq(tp);
                        } else {
                            this.addOrUpdatePartitionInfo(partitionStates, tp.topic(), tp.partition(), info);
                            this.stateChangeLogger().trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Cached leader info ").append(info).append(" for partition ").append(tp).append(" in response to ").append(new StringBuilder(70).append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                            object = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError(tuple2);
                    }
                    Object object2 = object;
                    return object2;
                });
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, partitionStates, controllerId, aliveBrokers, aliveNodes));
            }
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains(topic);
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, String topic, int partitionId) {
        return partitionStates.get(topic).exists((Function1<LongMap<UpdateMetadataRequest.PartitionState>, Object>)(Function1<LongMap, Object> & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean(MetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new MetadataCache$MetadataSnapshot$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getEndpoints$1(MetadataCache $this, MetadataSnapshot snapshot$1, ListenerName listenerName$1, boolean filterUnavailableEndpoints$1, ArrayBuffer result$1, Integer brokerId) {
        Option option;
        Option<Node> option2 = $this.getAliveEndpoint(snapshot$1, Predef$.MODULE$.Integer2int(brokerId), listenerName$1);
        if (None$.MODULE$.equals(option2)) {
            option = !filterUnavailableEndpoints$1 ? new Some<Node>(new Node(Predef$.MODULE$.Integer2int(brokerId), "", -1)) : None$.MODULE$;
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            Node node = (Node)some.value();
            option = new Some<Node>(node);
        } else {
            throw new MatchError(option2);
        }
        Option endpoint = option;
        endpoint.foreach((Function1<Node, ArrayBuffer> & Serializable & scala.Serializable)elem -> result$1.$plus$eq(elem));
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$2(String topicName$1, long partitionId) {
        return new TopicPartition(topicName$1, (int)partitionId);
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.get(Predef$.MODULE$.Integer2int(id)).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
        boolean bl = state.basePartitionState.leader != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$7(String x$1) {
        return Topic.isInternal(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$8(Node x$6) {
        return x$6 != null;
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$2(LongMap aliveBrokers$1, LongMap aliveNodes$1, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer<EndPoint> endPoints = new ArrayBuffer<EndPoint>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1<UpdateMetadataRequest.EndPoint, Node> & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        aliveBrokers$1.update(broker.id, new Broker(broker.id, endPoints, Option$.MODULE$.apply(broker.rack)));
        aliveNodes$1.update(broker.id, JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$7) {
        Set set = x$7.keySet();
        Set set2 = listeners$1;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(MetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        block0: {
            Set listeners = listenerMap.keySet();
            if (aliveNodes$1.values().forall((Function1<Map, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(MetadataCache.$anonfun$updateMetadata$5(listeners, x$7)))) break block0;
            $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, LongMap infos) {
        infos.remove(BoxesRunTime.boxToLong(partitionId$3));
        Serializable serializable = infos.isEmpty() ? partitionStates$2.remove(topic$4) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, AnyRefMap$.MODULE$.empty(), None$.MODULE$, LongMap$.MODULE$.empty(), LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ MetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$MetadataCache$MetadataSnapshot$$$outer(), partitionStates, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public Option<Object> copy$default$2() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$3() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$4() {
            return this.aliveNodes();
        }

        @Override
        public String productPrefix() {
            return "MetadataSnapshot";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int x$1) {
            scala.Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = this.partitionStates();
                    break;
                }
                case 1: {
                    serializable = this.controllerId();
                    break;
                }
                case 2: {
                    serializable = this.aliveBrokers();
                    break;
                }
                case 3: {
                    serializable = this.aliveNodes();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return serializable;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)object).kafka$server$MetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$MetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!((Object)anyRefMap).equals(anyRefMap2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!((Object)longMap).equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!((Object)longMap3).equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetadataCache kafka$server$MetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(MetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

