/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType$AlterLogDirsReplication$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$LeaderReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class QuotaFactory$
implements Logging {
    public static QuotaFactory$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new QuotaFactory$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        QuotaFactory$ quotaFactory$ = this;
        synchronized (quotaFactory$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix) {
        Option<ClientQuotaCallback> clientQuotaCallback = Option$.MODULE$.apply(cfg.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class));
        return new QuotaFactory.QuotaManagers(new ClientQuotaManager(this.clientFetchConfig(cfg), metrics, QuotaType$Fetch$.MODULE$, time, threadNamePrefix, clientQuotaCallback), new ClientQuotaManager(this.clientProduceConfig(cfg), metrics, QuotaType$Produce$.MODULE$, time, threadNamePrefix, clientQuotaCallback), new ClientRequestQuotaManager(this.clientRequestConfig(cfg), metrics, time, threadNamePrefix, clientQuotaCallback), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$LeaderReplication$.MODULE$, time), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$FollowerReplication$.MODULE$, time), new ReplicationQuotaManager(this.alterLogDirsReplicationConfig(cfg), metrics, QuotaType$AlterLogDirsReplication$.MODULE$, time), clientQuotaCallback);
    }

    public ClientQuotaManagerConfig clientProduceConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject(cfg.producerQuotaBytesPerSecondDefault(), BoxesRunTime.boxToLong(Long.MAX_VALUE))) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(109).append(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp()).append(" has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead.").toString());
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.producerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
    }

    public ClientQuotaManagerConfig clientFetchConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject(cfg.consumerQuotaBytesPerSecondDefault(), BoxesRunTime.boxToLong(Long.MAX_VALUE))) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(109).append(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp()).append(" has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead.").toString());
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.consumerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
    }

    public ClientQuotaManagerConfig clientRequestConfig(KafkaConfig cfg) {
        int x$1 = Predef$.MODULE$.Integer2int(cfg.numQuotaSamples());
        int x$2 = Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds());
        long x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ClientQuotaManagerConfig(x$3, x$1, x$2);
    }

    public ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        int x$1 = Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples());
        int x$2 = Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds());
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$3, x$1, x$2);
    }

    public ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        int x$1 = Predef$.MODULE$.Integer2int(cfg.numAlterLogDirsReplicationQuotaSamples());
        int x$2 = Predef$.MODULE$.Integer2int(cfg.alterLogDirsReplicationQuotaWindowSizeSeconds());
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$3, x$1, x$2);
    }

    private QuotaFactory$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

