/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.tools.DumpLogSegments;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class DumpLogSegments$ {
    public static DumpLogSegments$ MODULE$;
    private final String RecordIndent;

    static {
        new DumpLogSegments$();
    }

    public String RecordIndent() {
        return this.RecordIndent;
    }

    public void main(String[] args) {
        DumpLogSegments.DumpLogSegmentsOptions opts = new DumpLogSegments.DumpLogSegmentsOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        opts.checkArgs();
        Map misMatchesForIndexFilesMap = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        Map nonConsecutivePairsForLogFilesMap = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])opts.files())).foreach((Function1<String, Object> & Serializable & scala.Serializable)arg -> {
            DumpLogSegments$.$anonfun$main$1(opts, nonConsecutivePairsForLogFilesMap, misMatchesForIndexFilesMap, timeIndexDumpErrors, arg);
            return BoxedUnit.UNIT;
        });
        misMatchesForIndexFilesMap.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$2(x0$1);
            return BoxedUnit.UNIT;
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
            DumpLogSegments$.$anonfun$main$4(x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void dumpTxnIndex(File file) {
        TransactionIndex index = new TransactionIndex(Log$.MODULE$.offsetFromFile(file), file);
        index.allAbortedTxns().foreach((Function1<AbortedTxn, Object> & Serializable & scala.Serializable)abortedTxn -> {
            Predef$.MODULE$.println(new StringBuilder(37).append("version: ").append(abortedTxn.version()).append(" producerId: ").append(abortedTxn.producerId()).append(" firstOffset: ").append(abortedTxn.firstOffset()).append(" ").append(new StringBuilder(31).append("lastOffset: ").append(abortedTxn.lastOffset()).append(" lastStableOffset: ").append(abortedTxn.lastStableOffset()).toString()).toString());
            return BoxedUnit.UNIT;
        });
    }

    private void dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager$.MODULE$.readSnapshot(file).foreach((Function1<ProducerStateEntry, Object> & Serializable & scala.Serializable)entry -> {
                DumpLogSegments$.$anonfun$dumpProducerIdSnapshot$1(entry);
                return BoxedUnit.UNIT;
            });
        }
        catch (CorruptSnapshotException e) {
            System.err.println(e.getMessage());
        }
    }

    public void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, Map<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString());
            FileRecords fileRecords = FileRecords.open(logFile, false);
            File x$1 = file;
            long x$2 = startOffset;
            boolean x$3 = false;
            int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
            OffsetIndex index = new OffsetIndex(x$1, x$2, x$4, x$3);
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println(new StringBuilder(21).append(file).append(" passed sanity check.").toString());
                return;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
                block3: {
                    Serializable serializable;
                    OffsetPosition entry = index.entry(i);
                    if (entry.offset() == index.baseOffset() && i > 0) {
                        throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                    }
                    FileRecords slice = fileRecords.slice(entry.position(), maxMessageSize);
                    long firstBatchLastOffset = ((RecordBatch)slice.batches().iterator().next()).lastOffset();
                    if (firstBatchLastOffset != entry.offset()) {
                        List<Tuple2$mcJJ$sp> misMatchesSeq = (List<Tuple2$mcJJ$sp>)misMatchesForIndexFilesMap.getOrElse(file.getAbsolutePath(), (Function0<List> & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                        misMatchesSeq = misMatchesSeq.$colon$colon(new Tuple2$mcJJ$sp(entry.offset(), firstBatchLastOffset));
                        serializable = misMatchesForIndexFilesMap.put(file.getAbsolutePath(), misMatchesSeq);
                    } else {
                        serializable = BoxedUnit.UNIT;
                    }
                    if (verifyOnly) break block3;
                    Predef$.MODULE$.println(new StringBuilder(19).append("offset: ").append(entry.offset()).append(" position: ").append(entry.position()).toString());
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        block8: {
            Object object = new Object();
            try {
                block7: {
                    File indexFile;
                    long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                    File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.LogFileSuffix()).toString());
                    FileRecords fileRecords = FileRecords.open(logFile, false);
                    File x$1 = indexFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder(0).append(file.getName().split("\\.")[0]).append(Log$.MODULE$.IndexFileSuffix()).toString());
                    long x$2 = startOffset;
                    boolean x$3 = false;
                    int x$4 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
                    OffsetIndex index = new OffsetIndex(x$1, x$2, x$4, x$3);
                    File x$5 = file;
                    long x$6 = startOffset;
                    boolean x$7 = false;
                    int x$8 = TimeIndex$.MODULE$.$lessinit$greater$default$3();
                    TimeIndex timeIndex = new TimeIndex(x$5, x$6, x$8, x$7);
                    try {
                        if (indexSanityOnly) {
                            timeIndex.sanityCheck();
                            Predef$.MODULE$.println(new StringBuilder(21).append(file).append(" passed sanity check.").toString());
                            break block7;
                        }
                        LongRef prevTimestamp = LongRef.create(-1L);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp(arg_0 -> DumpLogSegments$.$anonfun$dumpTimeIndex$1(timeIndex, object, index, fileRecords, timeIndexDumpErrors, file, prevTimestamp, verifyOnly, arg_0));
                        break block8;
                    }
                    finally {
                        fileRecords.closeHandlers();
                        index.closeHandler();
                        timeIndex.closeHandler();
                    }
                }
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                }
                throw ex;
            }
        }
    }

    private void dumpLog(File file, boolean printContents, Map<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
        Predef$.MODULE$.println(new StringBuilder(17).append("Starting offset: ").append(startOffset).toString());
        FileRecords fileRecords = FileRecords.open(file, false);
        try {
            LongRef validBytes = LongRef.create(0L);
            LongRef lastOffset = LongRef.create(-1L);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fileRecords.batches()).asScala()).foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable & scala.Serializable)batch -> {
                DumpLogSegments$.$anonfun$dumpLog$1(validBytes, isDeepIteration, lastOffset, nonConsecutivePairsForLogFilesMap, file, printContents, parser, batch);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)fileRecords.sizeInBytes() - validBytes.elem;
            if (trailingBytes > 0L) {
                Predef$.MODULE$.println(new StringBuilder(35).append("Found ").append(trailingBytes).append(" invalid bytes at the end of ").append(file.getName()).toString());
            }
        }
        finally {
            fileRecords.closeHandlers();
        }
    }

    private void printBatchLevel(FileLogInputStream.FileChannelRecordBatch batch, long accumulativeBytes) {
        if (batch.magic() >= 2) {
            Predef$.MODULE$.print(new StringBuilder(145).append("baseOffset: ").append(batch.baseOffset()).append(" lastOffset: ").append(batch.lastOffset()).append(" count: ").append(batch.countOrNull()).append(" baseSequence: ").append(batch.baseSequence()).append(" lastSequence: ").append(batch.lastSequence()).append(" producerId: ").append(batch.producerId()).append(" producerEpoch: ").append(batch.producerEpoch()).append(" partitionLeaderEpoch: ").append(batch.partitionLeaderEpoch()).append(" isTransactional: ").append(batch.isTransactional()).append(" isControl: ").append(batch.isControlBatch()).toString());
        } else {
            Predef$.MODULE$.print(new StringBuilder(8).append("offset: ").append(batch.lastOffset()).toString());
        }
        Predef$.MODULE$.println(new StringBuilder(61).append(" position: ").append(accumulativeBytes).append(" ").append((Object)batch.timestampType()).append(": ").append(batch.maxTimestamp()).append(" size: ").append(batch.sizeInBytes()).append(" magic: ").append(batch.magic()).append(" compresscodec: ").append((Object)batch.compressionType()).append(" crc: ").append(batch.checksum()).append(" isvalid: ").append(batch.isValid()).toString());
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments.DumpLogSegmentsOptions opts$1, Map nonConsecutivePairsForLogFilesMap$1, Map misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, String arg) {
        String suffix;
        File file = new File(arg);
        Predef$.MODULE$.println(new StringBuilder(8).append("Dumping ").append(file).toString());
        String filename = file.getName();
        String string = suffix = filename.substring(filename.lastIndexOf("."));
        String string2 = Log$.MODULE$.LogFileSuffix();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            MODULE$.dumpLog(file, opts$1.shouldPrintDataLog(), nonConsecutivePairsForLogFilesMap$1, opts$1.isDeepIteration(), opts$1.maxMessageSize(), opts$1.messageParser());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = Log$.MODULE$.IndexFileSuffix();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                MODULE$.dumpIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), misMatchesForIndexFilesMap$1, opts$1.maxMessageSize());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = Log$.MODULE$.TimeIndexFileSuffix();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    MODULE$.dumpTimeIndex(file, opts$1.indexSanityOnly(), opts$1.verifyOnly(), timeIndexDumpErrors$1, opts$1.maxMessageSize());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = Log$.MODULE$.ProducerSnapshotFileSuffix();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        MODULE$.dumpProducerIdSnapshot(file);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string10 = Log$.MODULE$.TxnIndexFileSuffix();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            MODULE$.dumpTxnIndex(file);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            System.err.println(new StringBuilder(22).append("Ignoring unknown file ").append(file).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long indexOffset = tuple2._1$mcJ$sp();
        long logOffset = tuple2._2$mcJ$sp();
        System.err.println(new StringBuilder(30).append("  Index offset: ").append(indexOffset).append(", log offset: ").append(logOffset).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfMismatches = (List)tuple2._2();
        System.err.println(new StringBuilder(15).append("Mismatches in :").append(fileName).toString());
        listOfMismatches.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
            DumpLogSegments$.$anonfun$main$3(x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long first = tuple2._1$mcJ$sp();
        long second = tuple2._2$mcJ$sp();
        System.err.println(new StringBuilder(18).append("  ").append(first).append(" is followed by ").append(second).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfNonConsecutivePairs = (List)tuple2._2();
        System.err.println(new StringBuilder(27).append("Non-consecutive offsets in ").append(fileName).toString());
        listOfNonConsecutivePairs.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$4 -> {
            DumpLogSegments$.$anonfun$main$5(x0$4);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$dumpProducerIdSnapshot$1(ProducerStateEntry entry) {
        Predef$.MODULE$.print(new StringBuilder(29).append("producerId: ").append(entry.producerId()).append(" producerEpoch: ").append(entry.producerEpoch()).append(" ").append(new StringBuilder(43).append("coordinatorEpoch: ").append(entry.coordinatorEpoch()).append(" currentTxnFirstOffset: ").append(entry.currentTxnFirstOffset()).append(" ").toString()).toString());
        entry.batchMetadata().headOption().foreach((Function1<BatchMetadata, Object> & Serializable & scala.Serializable)metadata -> {
            Predef$.MODULE$.print(new StringBuilder(31).append("firstSequence: ").append(metadata.firstSeq()).append(" lastSequence: ").append(metadata.lastSeq()).append(" ").append(new StringBuilder(38).append("lastOffset: ").append(metadata.lastOffset()).append(" offsetDelta: ").append(metadata.offsetDelta()).append(" timestamp: ").append(metadata.timestamp()).toString()).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return x$1.lastOffset() >= entry$1.offset();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(TimeIndex timeIndex$1, Object nonLocalReturnKey2$1, OffsetIndex index$2, FileRecords fileRecords$2, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, File file$2, LongRef prevTimestamp$1, boolean verifyOnly$2, int i) {
        block10: {
            block9: {
                entry = timeIndex$1.entry(i);
                if (entry.offset() == timeIndex$1.baseOffset() && i > 0) {
                    throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                position = index$2.lookup(entry.offset()).position();
                partialFileRecords = fileRecords$2.slice(position, 0x7FFFFFFF);
                batches = JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.batches()).asScala();
                maxTimestamp = LongRef.create(-1L);
                var15_14 = false;
                var16_15 = null;
                var17_16 = batches.find((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(kafka.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelRecordBatch ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelRecordBatch;)Ljava/lang/Object;)((TimestampOffset)entry));
                if (!None$.MODULE$.equals(var17_16)) break block9;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), -1);
                var9_17 = BoxedUnit.UNIT;
                break block10;
            }
            if (!(var17_16 instanceof Some)) ** GOTO lbl-1000
            var15_14 = true;
            var16_15 = (Some)var17_16;
            batch = (FileLogInputStream.FileChannelRecordBatch)var16_15.value();
            if (batch.lastOffset() != entry.offset()) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$2, entry.offset(), batch.lastOffset());
                var9_18 = BoxedUnit.UNIT;
            } else if (var15_14) {
                batch = (FileLogInputStream.FileChannelRecordBatch)var16_15.value();
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach((Function1<Record, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.Record ), (Lorg/apache/kafka/common/record/Record;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp()) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$2, entry.timestamp(), maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp()) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$2, entry.timestamp(), prevTimestamp$1.elem);
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                var9_19 = v0;
            } else {
                throw new MatchError(var17_16);
            }
        }
        if (!verifyOnly$2) {
            Predef$.MODULE$.println(new StringBuilder(20).append("timestamp: ").append(entry.timestamp()).append(" offset: ").append(entry.offset()).toString());
        }
        prevTimestamp$1.elem = entry.timestamp();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$2(LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, FileLogInputStream.FileChannelRecordBatch batch$1, boolean printContents$1, DumpLogSegments.MessageParser parser$1, Record record) {
        Serializable serializable;
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = record.offset();
            serializable = BoxedUnit.UNIT;
        } else if (record.offset() != lastOffset$1.elem + 1L) {
            List<Tuple2$mcJJ$sp> nonConsecutivePairsSeq = (List<Tuple2$mcJJ$sp>)nonConsecutivePairsForLogFilesMap$2.getOrElse(file$3.getAbsolutePath(), (Function0<List> & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon(new Tuple2$mcJJ$sp(lastOffset$1.elem, record.offset()));
            serializable = nonConsecutivePairsForLogFilesMap$2.put(file$3.getAbsolutePath(), nonConsecutivePairsSeq);
        } else {
            serializable = BoxedUnit.UNIT;
        }
        lastOffset$1.elem = record.offset();
        Predef$.MODULE$.print(new StringBuilder(13).append(MODULE$.RecordIndent()).append(" offset: ").append(record.offset()).append(" ").append((Object)batch$1.timestampType()).append(": ").append(record.timestamp()).append(" ").append(new StringBuilder(21).append("keysize: ").append(record.keySize()).append(" valuesize: ").append(record.valueSize()).toString()).toString());
        if (batch$1.magic() >= 2) {
            Predef$.MODULE$.print(new StringBuilder(24).append(" sequence: ").append(record.sequence()).append(" headerKeys: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])record.headers())).map((Function1<Header, String> & Serializable & scala.Serializable)x$2 -> x$2.key(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).toString());
        } else {
            Predef$.MODULE$.print(new StringBuilder(16).append(" crc: ").append(record.checksumOrNull()).append(" isvalid: ").append(record.isValid()).toString());
        }
        if (batch$1.isControlBatch()) {
            short controlTypeId = ControlRecordType.parseTypeId(record.key());
            ControlRecordType controlRecordType = ControlRecordType.fromTypeId(controlTypeId);
            boolean bl = ((Object)((Object)ControlRecordType.ABORT)).equals((Object)controlRecordType) ? true : ((Object)((Object)ControlRecordType.COMMIT)).equals((Object)controlRecordType);
            if (bl) {
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize(record);
                Predef$.MODULE$.print(new StringBuilder(34).append(" endTxnMarker: ").append((Object)endTxnMarker.controlType()).append(" coordinatorEpoch: ").append(endTxnMarker.coordinatorEpoch()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.print(new StringBuilder(16).append(" controlType: ").append((Object)controlRecordType).append("(").append(controlTypeId).append(")").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else if (printContents$1) {
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option key2 = tuple2._1();
            Option payload2 = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key2, payload2);
            Tuple2 tuple23 = tuple22;
            Option key3 = tuple23._1();
            Option payload3 = tuple23._2();
            key3.foreach((Function1<Object, Object> & Serializable & scala.Serializable)key -> {
                Predef$.MODULE$.print(new StringBuilder(6).append(" key: ").append(key).toString());
                return BoxedUnit.UNIT;
            });
            payload3.foreach((Function1<Object, Object> & Serializable & scala.Serializable)payload -> {
                Predef$.MODULE$.print(new StringBuilder(10).append(" payload: ").append(payload).toString());
                return BoxedUnit.UNIT;
            });
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(LongRef validBytes$1, boolean isDeepIteration$1, LongRef lastOffset$1, Map nonConsecutivePairsForLogFilesMap$2, File file$3, boolean printContents$1, DumpLogSegments.MessageParser parser$1, FileLogInputStream.FileChannelRecordBatch batch) {
        MODULE$.printBatchLevel(batch, validBytes$1.elem);
        if (isDeepIteration$1) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach((Function1<Record, Object> & Serializable & scala.Serializable)record -> {
                DumpLogSegments$.$anonfun$dumpLog$2(lastOffset$1, nonConsecutivePairsForLogFilesMap$2, file$3, batch, printContents$1, parser$1, record);
                return BoxedUnit.UNIT;
            });
        }
        validBytes$1.elem += (long)batch.sizeInBytes();
    }

    private DumpLogSegments$() {
        MODULE$ = this;
        this.RecordIndent = "|";
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return BoxesRunTime.boxToBoolean(DumpLogSegments$.$anonfun$dumpTimeIndex$2(entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, Record record) {
        maxTimestamp$1.elem = package$.MODULE$.max(maxTimestamp$1.elem, record.timestamp());
        return BoxedUnit.UNIT;
    }
}

