/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.net.SocketTimeoutException;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\b\u0010\tQA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!i\u0004A!A!\u0002\u0013q\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b5\u0003A\u0011\u0001(\t\u000f]\u0003!\u0019!C\u00051\"1\u0011\f\u0001Q\u0001\nyBqA\u0017\u0001C\u0002\u0013%1\f\u0003\u0004a\u0001\u0001\u0006I\u0001\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\b\u0003#\u0001A\u0011AA\n\u0005i\u0011V\r\u001d7jG\u00064U\r^2iKJ\u0014En\\2lS:<7+\u001a8e\u0015\t\u0001\u0012#A\u0003u_>d7OC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u0003)\u0019x.\u001e:dK:{G-\u001a\t\u0003;\u0015j\u0011A\b\u0006\u0003?\u0001\naaY8n[>t'B\u0001\n\"\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019r\"\u0001\u0002(pI\u0016\fabY8ogVlWM]\"p]\u001aLw\r\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005A1m\u001c8tk6,'O\u0003\u0002.A\u000591\r\\5f]R\u001c\u0018BA\u0018+\u00059\u0019uN\\:v[\u0016\u00148i\u001c8gS\u001e\fq!\\3ue&\u001c7\u000f\u0005\u00023i5\t1G\u0003\u00021=%\u0011Qg\r\u0002\b\u001b\u0016$(/[2t\u0003\u0011!\u0018.\\3\u0011\u0005aZT\"A\u001d\u000b\u0005ir\u0012!B;uS2\u001c\u0018B\u0001\u001f:\u0005\u0011!\u0016.\\3\u0002\u0013\u0019,Go\u00195fe&#\u0007C\u0001\f@\u0013\t\u0001uCA\u0002J]R\f\u0001b\u00197jK:$\u0018\n\u001a\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015;R\"\u0001$\u000b\u0005\u001d\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002J/\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIu#\u0001\u0004=S:LGO\u0010\u000b\b\u001fF\u00136\u000bV+W!\t\u0001\u0006!D\u0001\u0010\u0011\u0015Yr\u00011\u0001\u001d\u0011\u00159s\u00011\u0001)\u0011\u0015\u0001t\u00011\u00012\u0011\u00151t\u00011\u00018\u0011\u0015it\u00011\u0001?\u0011\u0015\tu\u00011\u0001C\u00035\u0019xnY6fiRKW.Z8viV\ta(\u0001\bt_\u000e\\W\r\u001e+j[\u0016|W\u000f\u001e\u0011\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u+\u0005a\u0006CA/_\u001b\u0005a\u0013BA0-\u00055qU\r^<pe.\u001cE.[3oi\u0006qa.\u001a;x_J\\7\t\\5f]R\u0004\u0013aC:f]\u0012\u0014V-];fgR$\"a\u00194\u0011\u0005u#\u0017BA3-\u00059\u0019E.[3oiJ+7\u000f]8og\u0016DQa\u001a\u0007A\u0002!\faB]3rk\u0016\u001cHOQ;jY\u0012,'\u000f\r\u0002j}B\u0019!.\u001f?\u000f\u0005-4hB\u00017u\u001d\ti7O\u0004\u0002oe:\u0011q.\u001d\b\u0003\u000bBL\u0011\u0001J\u0005\u0003E\rJ!AE\u0011\n\u0005}\u0001\u0013BA;\u001f\u0003!\u0011X-];fgR\u001c\u0018BA<y\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$(BA;\u001f\u0013\tQ8PA\u0004Ck&dG-\u001a:\u000b\u0005]D\bCA?\u007f\u0019\u0001!!b 4\u0002\u0002\u0003\u0005)\u0011AA\u0001\u0005\ryF%M\t\u0005\u0003\u0007\tI\u0001E\u0002\u0017\u0003\u000bI1!a\u0002\u0018\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0003\u0002\u000e5\t\u00010C\u0002\u0002\u0010a\u0014q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001\u0006G2|7/\u001a\u000b\u0003\u0003+\u00012AFA\f\u0013\r\tIb\u0006\u0002\u0005+:LG\u000f")
public class ReplicaFetcherBlockingSend {
    private final Node sourceNode;
    private final Time time;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ClientResponse clientResponse;
        try {
            if (!NetworkClientUtils.awaitReady(this.networkClient(), this.sourceNode, this.time, this.socketTimeout())) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout()).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger(this.sourceNode.id())).toString(), requestBuilder, this.time.milliseconds(), true);
            clientResponse = NetworkClientUtils.sendAndReceive(this.networkClient(), clientRequest, this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger(this.sourceNode.id())).toString());
            throw e;
        }
        return clientResponse;
    }

    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(Node sourceNode, ConsumerConfig consumerConfig, Metrics metrics, Time time, int fetcherId, String clientId) {
        this.sourceNode = sourceNode;
        this.time = time;
        this.socketTimeout = Predef$.MODULE$.Integer2int(consumerConfig.getInt("request.timeout.ms"));
        ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(consumerConfig, time);
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(consumerConfig.getLong("connections.max.idle.ms")), metrics, time, "replica-fetcher", JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker-id"), ((Object)BoxesRunTime.boxToInteger(sourceNode.id())).toString()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-id"), ((Object)BoxesRunTime.boxToInteger(fetcherId)).toString())}))).asJava(), false, channelBuilder, new LogContext());
        this.networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(consumerConfig.getInt("receive.buffer.bytes")), Predef$.MODULE$.Integer2int(consumerConfig.getInt("request.timeout.ms")), ClientDnsLookup.DEFAULT, time, false, new ApiVersions(), new LogContext());
    }
}

