/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcher;
import kafka.tools.ReplicaVerificationTool$;
import kafka.tools.TopicPartitionReplica;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.ToolsUtils$;
import kafka.utils.Whitelist;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0$mcV$sp;

public final class ReplicaVerificationTool$
implements Logging {
    public static ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaVerificationTool$ replicaVerificationTool$ = this;
        synchronized (replicaVerificationTool$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(Time.SYSTEM.milliseconds()));
    }

    public void main(String[] args) {
        Tuple2<Seq<TopicDescription>, Map<Object, Node>> tuple2;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x100000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo(".*", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(-1L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(30000L), (Long[])((Object[])new Long[0]));
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print usage information.").forHelp();
        AbstractOptionSpec versionOpt = parser.accepts("version", "Print version information and exit.").forHelp();
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has(helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        if (options.has(versionOpt)) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = options.valueOf(topicWhiteListOpt);
        Whitelist topicWhiteListFiler = new Whitelist(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(new StringBuilder(21).append(regex).append(" is an invalid regex.").toString());
        }
        int fetchSize = options.valueOf(fetchSizeOpt);
        int maxWaitMs = options.valueOf(maxWaitMsOpt);
        long initialOffsetTime = options.valueOf(initialOffsetTimeOpt);
        long reportInterval = options.valueOf(reportIntervalOpt);
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "Getting topic metadata...");
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        AdminClient adminClient = this.createAdminClient(brokerList);
        try {
            tuple2 = new Tuple2<Seq<TopicDescription>, Map<Object, Node>>(this.listTopicsMetadata(adminClient), this.brokerDetails(adminClient));
        }
        finally {
            CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> adminClient.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        Tuple2<Seq<TopicDescription>, Map<Object, Node>> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        Seq<TopicDescription> topicsMetadata = tuple22._1();
        Map<Object, Node> brokerInfo = tuple22._2();
        Tuple2<Seq<TopicDescription>, Map<Object, Node>> tuple23 = new Tuple2<Seq<TopicDescription>, Map<Object, Node>>(topicsMetadata, brokerInfo);
        Tuple2<Seq<TopicDescription>, Map<Object, Node>> tuple24 = tuple23;
        Seq<TopicDescription> topicsMetadata2 = tuple24._1();
        Map<Object, Node> brokerInfo2 = tuple24._2();
        Seq filteredTopicMetadata = (Seq)topicsMetadata2.filter((Function1<TopicDescription, Object> & Serializable & scala.Serializable)topicMetaData -> BoxesRunTime.boxToBoolean(topicWhiteListFiler.isTopicAllowed(topicMetaData.name(), false)));
        if (filteredTopicMetadata.isEmpty()) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(88).append("No topics found. ").append(topicWhiteListOpt).append(" if specified, is either filtering out all topics or there is no topic.").toString());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        Seq topicPartitionReplicas = filteredTopicMetadata.flatMap((Function1<TopicDescription, Buffer> & Serializable & scala.Serializable)topicMetadata -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitions()).asScala()).flatMap((Function1<TopicPartitionInfo, Buffer> & Serializable & scala.Serializable)partitionMetadata -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1<Node, TopicPartitionReplica> & Serializable & scala.Serializable)node -> new TopicPartitionReplica(topicMetadata.name(), partitionMetadata.partition(), node.id()), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Selected topic partitions: ").append(topicPartitionReplicas).toString());
        Map brokerToTopicPartitions = topicPartitionReplicas.groupBy((Function1<TopicPartitionReplica, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.replicaId())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int brokerId = tuple2._1$mcI$sp();
            Seq partitions = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(brokerId)), partitions.map((Function1<TopicPartitionReplica, TopicPartition> & Serializable & scala.Serializable)partition -> new TopicPartition(partition.topic(), partition.partitionId()), Seq$.MODULE$.canBuildFrom()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Topic partitions per broker: ").append(brokerToTopicPartitions).toString());
        Map<TopicPartition, Object> expectedReplicasPerTopicPartition = topicPartitionReplicas.groupBy((Function1<TopicPartitionReplica, TopicPartition> & Serializable & scala.Serializable)replica -> new TopicPartition(replica.topic(), replica.partitionId())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicAndPartition = (TopicPartition)tuple2._1();
            Seq replicaSet = (Seq)tuple2._2();
            Tuple2<TopicPartition, Integer> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), BoxesRunTime.boxToInteger(replicaSet.size()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Expected replicas per topic partition: ").append(expectedReplicasPerTopicPartition).toString());
        Seq<TopicPartition> topicPartitions = filteredTopicMetadata.flatMap((Function1<TopicDescription, Buffer> & Serializable & scala.Serializable)topicMetaData -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetaData.partitions()).asScala()).map((Function1<TopicPartitionInfo, TopicPartition> & Serializable & scala.Serializable)partitionMetadata -> new TopicPartition(topicMetaData.name(), partitionMetadata.partition()), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Properties consumerProps = this.consumerConfig(brokerList);
        ReplicaBuffer replicaBuffer = new ReplicaBuffer(expectedReplicasPerTopicPartition, this.initialOffsets(topicPartitions, consumerProps, initialOffsetTime), brokerToTopicPartitions.size(), reportInterval);
        int verificationBrokerId = ((Tuple2)brokerToTopicPartitions.head())._1$mcI$sp();
        AtomicInteger counter = new AtomicInteger(0);
        Iterable fetcherThreads = brokerToTopicPartitions.map((Function1<Tuple2, ReplicaFetcher> & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int brokerId = tuple2._1$mcI$sp();
            Seq topicPartitions = (Seq)tuple2._2();
            ReplicaFetcher replicaFetcher = new ReplicaFetcher(new StringBuilder(15).append("ReplicaFetcher-").append(brokerId).toString(), (Node)brokerInfo2.apply(BoxesRunTime.boxToInteger(brokerId)), topicPartitions, replicaBuffer, 30000, 256000, fetchSize, maxWaitMs, 1, brokerId == verificationBrokerId, consumerProps, counter.incrementAndGet());
            return replicaFetcher;
        }, Iterable$.MODULE$.canBuildFrom());
        Runtime.getRuntime().addShutdownHook(new Thread(fetcherThreads){
            private final Iterable fetcherThreads$1;

            public void run() {
                ReplicaVerificationTool$.MODULE$.info((Function0<String> & Serializable & scala.Serializable)() -> "Stopping all fetchers");
                this.fetcherThreads$1.foreach((Function1<ReplicaFetcher, Object> & Serializable & scala.Serializable)x$3 -> {
                    anon.1.$anonfun$run$2(x$3);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$2(ReplicaFetcher x$3) {
                x$3.shutdown();
            }
            {
                this.fetcherThreads$1 = fetcherThreads$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$2$adapted(kafka.tools.ReplicaFetcher )}, serializedLambda);
            }
        });
        fetcherThreads.foreach((Function1<ReplicaFetcher, Object> & Serializable & scala.Serializable)x$4 -> {
            x$4.start();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println(new StringBuilder(34).append(this.getCurrentTimeString()).append(": verification process is started.").toString());
    }

    private Seq<TopicDescription> listTopicsMetadata(AdminClient adminClient) {
        Set<String> topics = adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get();
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeTopics(topics).all().get().values()).asScala()).toBuffer();
    }

    private Map<Object, Node> brokerDetails(AdminClient adminClient) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).map((Function1<Node, Tuple2> & Serializable & scala.Serializable)n -> new Tuple2<Integer, Node>(BoxesRunTime.boxToInteger(n.id()), (Node)n), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private AdminClient createAdminClient(String brokerUrl) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerUrl);
        return AdminClient.create(props);
    }

    private Map<TopicPartition, Object> initialOffsets(Seq<TopicPartition> topicPartitions, Properties consumerConfig, long initialOffsetTime) {
        Map<TopicPartition, Object> map;
        try (KafkaConsumer<String, String> consumer = this.createConsumer(consumerConfig);){
            if (-1L == initialOffsetTime) {
                map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection<TopicPartition>)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).mapValues((Function1<Long, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong(x$5)).toMap(Predef$.MODULE$.$conforms());
            } else if (-2L == initialOffsetTime) {
                map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection<TopicPartition>)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).mapValues((Function1<Long, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong(x$6)).toMap(Predef$.MODULE$.$conforms());
            } else {
                Map timestampsToSearch = ((TraversableOnce)topicPartitions.map((Function1<TopicPartition, Tuple2> & Serializable & scala.Serializable)tp -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Predef$.MODULE$.long2Long(initialOffsetTime)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(JavaConverters$.MODULE$.mapAsJavaMapConverter(timestampsToSearch).asJava())).asScala()).mapValues((Function1<OffsetAndTimestamp, Object> & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong(v.offset())).toMap(Predef$.MODULE$.$conforms());
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Properties consumerConfig(String brokerUrl) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerUrl);
        properties.put("group.id", "ReplicaVerification");
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        return var2_2;
    }

    private KafkaConsumer<String, String> createConsumer(Properties consumerConfig) {
        return new KafkaConsumer<String, String>(consumerConfig);
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

