/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.CoreUtils$;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.utils.KafkaThread;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001\u0002\r\u001a\u0001yA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005]!A!\u0007\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u00035\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\"\u0002#\u0001\t\u0003)\u0005b\u0002&\u0001\u0001\u0004%Ia\u0013\u0005\b-\u0002\u0001\r\u0011\"\u0003X\u0011\u0019i\u0006\u0001)Q\u0005\u0019\"9a\f\u0001b\u0001\n\u0013y\u0006B\u00024\u0001A\u0003%\u0001\rC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003j\u0001\u0011\u0005\u0003\u000eC\u0003k\u0001\u0011\u00051\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!1\u00111\u0003\u0001\u0005\n!<\u0011\"!\b\u001a\u0003\u0003E\t!a\b\u0007\u0011aI\u0012\u0011!E\u0001\u0003CAa\u0001\u0012\u000b\u0005\u0002\u0005\r\u0002\"CA\u0013)E\u0005I\u0011AA\u0014\u0011%\ti\u0004FI\u0001\n\u0003\tyD\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u000b\u0005iY\u0012!B;uS2\u001c(\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aH\u0013*!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u00023%\u0011\u0001&\u0007\u0002\n'\u000eDW\rZ;mKJ\u0004\"A\n\u0016\n\u0005-J\"a\u0002'pO\u001eLgnZ\u0001\bi\"\u0014X-\u00193t+\u0005q\u0003C\u0001\u00110\u0013\t\u0001\u0014EA\u0002J]R\f\u0001\u0002\u001e5sK\u0006$7\u000fI\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb,\u0012\u0001\u000e\t\u0003kqr!A\u000e\u001e\u0011\u0005]\nS\"\u0001\u001d\u000b\u0005ej\u0012A\u0002\u001fs_>$h(\u0003\u0002<C\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\rM#(/\u001b8h\u0015\tY\u0014%A\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0002\na\u0001Z1f[>t\u0007C\u0001\u0011C\u0013\t\u0019\u0015EA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u00111u\tS%\u0011\u0005\u0019\u0002\u0001\"\u0002\u0017\u0007\u0001\u0004q\u0003b\u0002\u001a\u0007!\u0003\u0005\r\u0001\u000e\u0005\b\u0001\u001a\u0001\n\u00111\u0001B\u0003!)\u00070Z2vi>\u0014X#\u0001'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016AC2p]\u000e,(O]3oi*\u0011\u0011KU\u0001\u0005kRLGNC\u0001T\u0003\u0011Q\u0017M^1\n\u0005Us%aG*dQ\u0016$W\u000f\\3e)\"\u0014X-\u00193Q_>dW\t_3dkR|'/\u0001\u0007fq\u0016\u001cW\u000f^8s?\u0012*\u0017\u000f\u0006\u0002Y7B\u0011\u0001%W\u0005\u00035\u0006\u0012A!\u00168ji\"9A\fCA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005IQ\r_3dkR|'\u000fI\u0001\u0012g\u000eDW\rZ;mKJ$\u0006N]3bI&#W#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rt\u0015AB1u_6L7-\u0003\u0002fE\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\f!c]2iK\u0012,H.\u001a:UQJ,\u0017\rZ%eA\u000591\u000f^1siV\u0004H#\u0001-\u0002\u0011MDW\u000f\u001e3po:\fAb]2iK\u0012,H.Z(oG\u0016$2\u0001\u00177o\u0011\u0015ig\u00021\u00015\u0003\u0011q\u0017-\\3\t\u000b=t\u0001\u0019\u00019\u0002\u0007\u0019,h\u000eE\u0002!cbK!A]\u0011\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014\u0001C:dQ\u0016$W\u000f\\3\u0015\ra+ho\u001e?\u007f\u0011\u0015iw\u00021\u00015\u0011\u0015yw\u00021\u0001q\u0011\u001dAx\u0002%AA\u0002e\fQ\u0001Z3mCf\u0004\"\u0001\t>\n\u0005m\f#\u0001\u0002'p]\u001eDq!`\b\u0011\u0002\u0003\u0007\u00110\u0001\u0004qKJLw\u000e\u001a\u0005\t\u007f>\u0001\n\u00111\u0001\u0002\u0002\u0005!QO\\5u!\ri\u00151A\u0005\u0004\u0003\u000bq%\u0001\u0003+j[\u0016,f.\u001b;\u0002!I,7/\u001b>f)\"\u0014X-\u00193Q_>dGc\u0001-\u0002\f!1\u0011Q\u0002\tA\u00029\nqA\\3x'&TX-A\u0005jgN#\u0018M\u001d;fIV\t\u0011)A\u0007f]N,(/\u001a*v]:Lgn\u001a\u0015\u0004\u0001\u0005]\u0001c\u0001\u0014\u0002\u001a%\u0019\u00111D\r\u0003\u0015QD'/Z1eg\u00064W-\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0011\u0005\u0019\"2C\u0001\u000b )\t\ty\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003SQ3\u0001NA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001cC\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002B)\u001a\u0011)a\u000b")
public class KafkaScheduler
implements Scheduler,
Logging {
    private final int threads;
    private final String threadNamePrefix;
    public final boolean kafka$utils$KafkaScheduler$$daemon;
    private ScheduledThreadPoolExecutor executor;
    private final AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public long schedule$default$3() {
        return Scheduler.schedule$default$3$(this);
    }

    @Override
    public long schedule$default$4() {
        return Scheduler.schedule$default$4$(this);
    }

    @Override
    public TimeUnit schedule$default$5() {
        return Scheduler.schedule$default$5$(this);
    }

    private Logger logger$lzycompute() {
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int threads() {
        return this.threads;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void executor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    public AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId() {
        return this.kafka$utils$KafkaScheduler$$schedulerThreadId;
    }

    @Override
    public void startup() {
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> "Initializing task scheduler.");
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if (this.isStarted()) {
                throw new IllegalStateException("This scheduler has already been started!");
            }
            this.executor_$eq(new ScheduledThreadPoolExecutor(this.threads()));
            this.executor().setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.executor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor().setThreadFactory(new ThreadFactory(this){
                private final /* synthetic */ KafkaScheduler $outer;

                public Thread newThread(Runnable runnable) {
                    return new KafkaThread(new StringBuilder(0).append(this.$outer.threadNamePrefix()).append(this.$outer.kafka$utils$KafkaScheduler$$schedulerThreadId().getAndIncrement()).toString(), runnable, this.$outer.kafka$utils$KafkaScheduler$$daemon);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    @Override
    public void shutdown() {
        block3: {
            this.debug((Function0<String> & Serializable & scala.Serializable)() -> "Shutting down task scheduler.");
            ScheduledThreadPoolExecutor cachedExecutor = this.executor();
            if (cachedExecutor == null) break block3;
            KafkaScheduler kafkaScheduler = this;
            synchronized (kafkaScheduler) {
                cachedExecutor.shutdown();
                this.executor_$eq(null);
            }
            cachedExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    public void scheduleOnce(String name, Function0<BoxedUnit> fun) {
        this.schedule(name, fun, 0L, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void schedule(String name, Function0<BoxedUnit> fun, long delay, long period, TimeUnit unit) {
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Scheduling task %s with initial delay %d ms and period %d ms.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{name, BoxesRunTime.boxToLong(TimeUnit.MILLISECONDS.convert(delay, unit)), BoxesRunTime.boxToLong(TimeUnit.MILLISECONDS.convert(period, unit))})));
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            this.ensureRunning();
            Runnable runnable = CoreUtils$.MODULE$.runnable((JFunction0$mcV$sp & scala.Serializable)() -> {
                try {
                    try {
                        this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning execution of scheduled task '%s'.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{name})));
                        fun.apply$mcV$sp();
                    }
                    catch (Throwable t) {
                        this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Uncaught exception in scheduled task '").append(name).append("'").toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
                    }
                }
                finally {
                    this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Completed execution of scheduled task '%s'.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{name})));
                }
            });
            ScheduledFuture<?> scheduledFuture = period >= 0L ? this.executor().scheduleAtFixedRate(runnable, delay, period, unit) : this.executor().schedule(runnable, delay, unit);
        }
    }

    public void resizeThreadPool(int newSize) {
        this.executor().setCorePoolSize(newSize);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.executor() != null;
    }

    private void ensureRunning() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Kafka scheduler is not running.");
        }
    }

    public KafkaScheduler(int threads, String threadNamePrefix, boolean daemon) {
        this.threads = threads;
        this.threadNamePrefix = threadNamePrefix;
        this.kafka$utils$KafkaScheduler$$daemon = daemon;
        Logging.$init$(this);
        this.executor = null;
        this.kafka$utils$KafkaScheduler$$schedulerThreadId = new AtomicInteger(0);
    }
}

